<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * CalendarSettingsData.
 */
class CalendarSettingsData  {

  /*
   * @type List
   */
  public $workingDays;

  /*
   * @type Integer
   */
  public $dayStart;

  /*
   * @type Integer
   */
  public $dayEnd;

  /*
   * @type Integer
   */
  public $minDuration;

  /*
   * @type String
   */
  public $timezoneId;

  /*
   * Constructor
   */
  public function __construct() {
    $this->workingDays =  array();
    $this->dayStart = null;
    $this->dayEnd = null;
    $this->minDuration = null;
    $this->timezoneId = "";
  }

  public function toMap() {
    $data = array(    
        "workingDays" => empty($this->workingDays) ? null : $this->workingDays,    
        "dayStart" => empty($this->dayStart) ? null : $this->dayStart,    
        "dayEnd" => empty($this->dayEnd) ? null : $this->dayEnd,    
        "minDuration" => empty($this->minDuration) ? null : $this->minDuration,    
        "timezoneId" => empty($this->timezoneId) ? null : $this->timezoneId);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
