/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.icalendar.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsICalendarElementRRule extends JavaScriptObject {

	protected JsICalendarElementRRule() {}

	public final native net.bluemind.icalendar.api.gwt.js.JsICalendarElementRRuleFrequency getFrequency()
	/*-{
	return this["frequency"];
	}-*/;

	public final native void setFrequency(net.bluemind.icalendar.api.gwt.js.JsICalendarElementRRuleFrequency frequency)
	/*-{
       this["frequency"] = frequency;
	}-*/;

	public final native Integer getCount()
	/*-{
	return ( this["count"] != null) ? @java.lang.Integer::new(I)(this["count"]) : null;
	}-*/;

	public final native void setCount(Integer count)
	/*-{
       this["count"] =  ( count != null) ? count.@java.lang.Integer::intValue()() : null;
	}-*/;

	public final native net.bluemind.core.api.date.gwt.js.JsBmDateTime getUntil()
	/*-{
	return this["until"];
	}-*/;

	public final native void setUntil(net.bluemind.core.api.date.gwt.js.JsBmDateTime until)
	/*-{
       this["until"] = until;
	}-*/;

	public final native Integer getInterval()
	/*-{
	return ( this["interval"] != null) ? @java.lang.Integer::new(I)(this["interval"]) : null;
	}-*/;

	public final native void setInterval(Integer interval)
	/*-{
       this["interval"] =  ( interval != null) ? interval.@java.lang.Integer::intValue()() : null;
	}-*/;

	public final native com.google.gwt.core.client.JsArrayInteger getBySecond()
	/*-{
	return this["bySecond"];
	}-*/;

	public final native void setBySecond(com.google.gwt.core.client.JsArrayInteger bySecond)
	/*-{
       this["bySecond"] = bySecond;
	}-*/;

	public final native com.google.gwt.core.client.JsArrayInteger getByMinute()
	/*-{
	return this["byMinute"];
	}-*/;

	public final native void setByMinute(com.google.gwt.core.client.JsArrayInteger byMinute)
	/*-{
       this["byMinute"] = byMinute;
	}-*/;

	public final native com.google.gwt.core.client.JsArrayInteger getByHour()
	/*-{
	return this["byHour"];
	}-*/;

	public final native void setByHour(com.google.gwt.core.client.JsArrayInteger byHour)
	/*-{
       this["byHour"] = byHour;
	}-*/;

	public final native com.google.gwt.core.client.JsArray<net.bluemind.icalendar.api.gwt.js.JsICalendarElementRRuleWeekDay> getByDay()
	/*-{
	return this["byDay"];
	}-*/;

	public final native void setByDay(com.google.gwt.core.client.JsArray<net.bluemind.icalendar.api.gwt.js.JsICalendarElementRRuleWeekDay> byDay)
	/*-{
       this["byDay"] = byDay;
	}-*/;

	public final native com.google.gwt.core.client.JsArrayInteger getByMonthDay()
	/*-{
	return this["byMonthDay"];
	}-*/;

	public final native void setByMonthDay(com.google.gwt.core.client.JsArrayInteger byMonthDay)
	/*-{
       this["byMonthDay"] = byMonthDay;
	}-*/;

	public final native com.google.gwt.core.client.JsArrayInteger getByYearDay()
	/*-{
	return this["byYearDay"];
	}-*/;

	public final native void setByYearDay(com.google.gwt.core.client.JsArrayInteger byYearDay)
	/*-{
       this["byYearDay"] = byYearDay;
	}-*/;

	public final native com.google.gwt.core.client.JsArrayInteger getByWeekNo()
	/*-{
	return this["byWeekNo"];
	}-*/;

	public final native void setByWeekNo(com.google.gwt.core.client.JsArrayInteger byWeekNo)
	/*-{
       this["byWeekNo"] = byWeekNo;
	}-*/;

	public final native com.google.gwt.core.client.JsArrayInteger getByMonth()
	/*-{
	return this["byMonth"];
	}-*/;

	public final native void setByMonth(com.google.gwt.core.client.JsArrayInteger byMonth)
	/*-{
       this["byMonth"] = byMonth;
	}-*/;

	public final native com.google.gwt.core.client.JsArrayInteger getBySetPos()
	/*-{
	return this["bySetPos"];
	}-*/;

	public final native void setBySetPos(com.google.gwt.core.client.JsArrayInteger bySetPos)
	/*-{
       this["bySetPos"] = bySetPos;
	}-*/;

	public static native  JsICalendarElementRRule create()
	/*-{
       var ret = {};
       return ret;
	}-*/;

}