/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.domain.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class DomainsEndpointPromise implements net.bluemind.domain.api.IDomainsPromise {

	private net.bluemind.domain.api.IDomainsAsync impl;

	public DomainsEndpointPromise(net.bluemind.domain.api.IDomainsAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.domain.api.Domain>>> all() {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.domain.api.Domain>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.domain.api.Domain>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.domain.api.Domain>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.domain.api.Domain>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.domain.api.Domain>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.all( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> create(String uid ,  net.bluemind.domain.api.Domain domain  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.create(uid, domain,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> delete(String uid  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.delete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.task.api.TaskRef> deleteDomainItems(String uid  ) {
		
		CompletableFuture<net.bluemind.core.task.api.TaskRef> ret = new CompletableFuture<net.bluemind.core.task.api.TaskRef>();
		AsyncHandler<net.bluemind.core.task.api.TaskRef> handler = new AsyncHandler<net.bluemind.core.task.api.TaskRef>() {
			public void success(net.bluemind.core.task.api.TaskRef value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.deleteDomainItems(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.domain.api.Domain>> findByNameOrAliases(String name  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.domain.api.Domain>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.domain.api.Domain>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.domain.api.Domain>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.domain.api.Domain>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.domain.api.Domain> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.findByNameOrAliases(name,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.domain.api.Domain>> get(String uid  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.domain.api.Domain>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.domain.api.Domain>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.domain.api.Domain>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.domain.api.Domain>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.domain.api.Domain> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.get(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<String> getExternalUrl(String uid  ) {
		
		CompletableFuture<String> ret = new CompletableFuture<String>();
		AsyncHandler<String> handler = new AsyncHandler<String>() {
			public void success(String value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getExternalUrl(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Set<String>> getRoles(String uid  ) {
		
		CompletableFuture<Set<String>> ret = new CompletableFuture<Set<String>>();
		AsyncHandler<Set<String>> handler = new AsyncHandler<Set<String>>() {
			public void success(Set<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getRoles(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.task.api.TaskRef> setAliases(String uid ,  Set<String> aliases  ) {
		
		CompletableFuture<net.bluemind.core.task.api.TaskRef> ret = new CompletableFuture<net.bluemind.core.task.api.TaskRef>();
		AsyncHandler<net.bluemind.core.task.api.TaskRef> handler = new AsyncHandler<net.bluemind.core.task.api.TaskRef>() {
			public void success(net.bluemind.core.task.api.TaskRef value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setAliases(uid, aliases,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> setDefaultAlias(String uid ,  String defaultAlias  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setDefaultAlias(uid, defaultAlias,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> setRoles(String uid ,  Set<String> roles  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setRoles(uid, roles,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> update(String uid ,  net.bluemind.domain.api.Domain domain  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.update(uid, domain,  handler);
		return ret;
	}

}
