<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * TaskStatus.
 */
class TaskStatus  {

  /*
   * @type double
   */
  public $steps;

  /*
   * @type double
   */
  public $progress;

  /*
   * @type String
   */
  public $lastLogEntry;

  /*
   * @type TaskStatusState
   */
  public $state;

  /*
   * @type String
   */
  public $result;

  /*
   * Constructor
   */
  public function __construct() {
    $this->steps = 0;
    $this->progress = 0;
    $this->lastLogEntry = "";
    $this->result = "";
  }

  public function toMap() {
    $data = array(    
        "steps" => empty($this->steps) ? null : $this->steps,    
        "progress" => empty($this->progress) ? null : $this->progress,    
        "lastLogEntry" => empty($this->lastLogEntry) ? null : $this->lastLogEntry,    
        "state" => empty($this->state) ? null : $this->state,    
        "result" => empty($this->result) ? null : $this->result);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
