/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.filehosting.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ConfigurationGwtSerDer implements GwtSerDer<net.bluemind.filehosting.api.Configuration> {

	public ConfigurationGwtSerDer( ) {
	}

	@Override
	public net.bluemind.filehosting.api.Configuration deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.filehosting.api.Configuration ret = new net.bluemind.filehosting.api.Configuration();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.filehosting.api.Configuration ret, JSONObject json) {
		JSONValue maxFilesizeJSON = json.get("maxFilesize");
		ret.maxFilesize =  GwtSerDerUtils.LONG.deserialize(maxFilesizeJSON);
		JSONValue retentionTimeJSON = json.get("retentionTime");
		ret.retentionTime =  GwtSerDerUtils.INT.deserialize(retentionTimeJSON);
	}

	public void deserializeTo(net.bluemind.filehosting.api.Configuration ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("maxFilesize")) {
			JSONValue maxFilesizeJSON = json.get("maxFilesize");
			ret.maxFilesize =  GwtSerDerUtils.LONG.deserialize(maxFilesizeJSON);
		}
		if (!childPropertiesToIgnore.contains("retentionTime")) {
			JSONValue retentionTimeJSON = json.get("retentionTime");
			ret.retentionTime =  GwtSerDerUtils.INT.deserialize(retentionTimeJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.filehosting.api.Configuration o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.filehosting.api.Configuration o, JSONObject ret) {

		ret.put("maxFilesize",  GwtSerDerUtils.LONG.serialize( o.maxFilesize ));
		ret.put("retentionTime",  GwtSerDerUtils.INT.serialize( o.retentionTime ));
	}

	public void serializeTo(net.bluemind.filehosting.api.Configuration o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("maxFilesize")) {
			ret.put("maxFilesize",  GwtSerDerUtils.LONG.serialize( o.maxFilesize ));
		}
		if (!childPropertiesToIgnore.contains("retentionTime")) {
			ret.put("retentionTime",  GwtSerDerUtils.INT.serialize( o.retentionTime ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}