/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.core.container.repository;

import java.sql.SQLException;

import net.bluemind.core.container.model.Container;
import net.bluemind.core.container.model.ContainerUid;
import net.bluemind.core.container.model.DataLocation;

public interface IContainerRouteStore {

	DataLocation routeOf(ContainerUid cUid);

	void storeRoute(ContainerUid cUid, DataLocation route) throws SQLException;

	void deleteRoute(ContainerUid cUid) throws SQLException;

	default void storeRoute(Container cont, String location) throws SQLException {
		storeRoute(ContainerUid.of(cont.uid), DataLocation.of(location));
	}

	default void storeRoute(String contUid, String location) throws SQLException {
		storeRoute(ContainerUid.of(contUid), DataLocation.of(location));
	}

	default void storeRoute(String contUid, DataLocation location) throws SQLException {
		storeRoute(ContainerUid.of(contUid), location);
	}

}
