/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2020
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.cti.xivo.system;

import java.util.Base64;
import java.util.Map;

import net.bluemind.system.service.RegisteredExternalSystem;

public class XivoSystem extends RegisteredExternalSystem {

	public XivoSystem() {
		super("Xivo", "Xivo, An Open Source project to build your own IP telecom platform", AuthKind.SIMPLE_CREDENTIALS,
				Map.of("name", "Xivo"));
	}

	@Override
	public byte[] getLogo() {
		String img = "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";
		return Base64.getDecoder().decode(img);
	}

	@Override
	public boolean handles(String userAccountIdentifier) {
		return userAccountIdentifier.startsWith(super.identifier);
	}

}
