<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * VNoteChangesItemModify.
 */
class VNoteChangesItemModify  {

  /*
   * @type String
   */
  public $uid;

  /*
   * @type Long
   */
  public $version;

  /*
   * @type VNote
   */
  public $value;

  /*
   * @type boolean
   */
  public $sendNotification;

  /*
   * Constructor
   */
  public function __construct() {
    $this->uid = "";
    $this->version = null;
    $this->value =   new VNote();
    $this->sendNotification = false;
  }

  public function toMap() {
    $data = array(    
        "uid" => empty($this->uid) ? null : $this->uid,    
        "version" => empty($this->version) ? null : $this->version,    
        "value" => empty($this->value) ? null : $this->value,    
        "sendNotification" => empty($this->sendNotification) ? null : $this->sendNotification);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
