/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.core.command;

import com.github.dockerjava.api.command.RestartContainerCmd;
import com.github.dockerjava.api.exception.NotFoundException;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.testcontainers.shaded.com.github.dockerjava.core.command.AbstrDockerCmd;
import org.testcontainers.shaded.com.google.common.base.Preconditions;

public class RestartContainerCmdImpl
extends AbstrDockerCmd<RestartContainerCmd, Void>
implements RestartContainerCmd {
    private String containerId;
    private Integer timeout = 10;
    private String signal;

    public RestartContainerCmdImpl(RestartContainerCmd.Exec exec, String containerId) {
        super(exec);
        this.withContainerId(containerId);
    }

    @Override
    public String getContainerId() {
        return this.containerId;
    }

    @Override
    public Integer getTimeout() {
        return this.timeout;
    }

    @Override
    @CheckForNull
    public String getSignal() {
        return this.signal;
    }

    @Override
    public RestartContainerCmd withContainerId(String containerId) {
        Objects.requireNonNull(containerId, "containerId was not specified");
        this.containerId = containerId;
        return this;
    }

    @Override
    public RestartContainerCmd withTimeout(Integer timeout) {
        Objects.requireNonNull(timeout, "timeout was not specified");
        Preconditions.checkArgument(timeout >= 0, "timeout must be greater or equal 0");
        this.timeout = timeout;
        return this;
    }

    @Override
    public RestartContainerCmd withSignal(String signal) {
        Objects.requireNonNull(signal, "signal was not specified");
        this.signal = signal;
        return this;
    }

    @Override
    public Void exec() throws NotFoundException {
        return (Void)super.exec();
    }
}

