/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.protocol;

import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.FrameCodec;
import com.datastax.oss.protocol.internal.Segment;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class SegmentToFrameDecoder
extends MessageToMessageDecoder<Segment<ByteBuf>> {
    private static final Logger LOG = LoggerFactory.getLogger(SegmentToFrameDecoder.class);
    private static final int UNKNOWN_LENGTH = Integer.MIN_VALUE;
    private final FrameCodec<ByteBuf> frameCodec;
    private final String logPrefix;
    private int targetLength = Integer.MIN_VALUE;
    private final List<ByteBuf> accumulatedSlices = new ArrayList<ByteBuf>();
    private int accumulatedLength;

    public SegmentToFrameDecoder(@NonNull FrameCodec<ByteBuf> frameCodec, @NonNull String logPrefix) {
        this.logPrefix = logPrefix;
        this.frameCodec = frameCodec;
    }

    protected void decode(@NonNull ChannelHandlerContext ctx, @NonNull Segment<ByteBuf> segment, @NonNull List<Object> out) {
        if (segment.isSelfContained) {
            this.decodeSelfContained(segment, out);
        } else {
            this.decodeSlice(segment, ctx.alloc(), out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeSelfContained(Segment<ByteBuf> segment, List<Object> out) {
        ByteBuf payload = (ByteBuf)segment.payload;
        int frameCount = 0;
        try {
            do {
                Frame frame = this.frameCodec.decode(payload);
                LOG.trace("[{}] Decoded response frame {} from self-contained segment", (Object)this.logPrefix, (Object)frame.streamId);
                out.add(frame);
                ++frameCount;
            } while (payload.isReadable());
        }
        finally {
            payload.release();
        }
        LOG.trace("[{}] Done processing self-contained segment ({} frames)", (Object)this.logPrefix, (Object)frameCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeSlice(Segment<ByteBuf> segment, ByteBufAllocator allocator, List<Object> out) {
        assert (this.targetLength != Integer.MIN_VALUE ^ (this.accumulatedSlices.isEmpty() && this.accumulatedLength == 0));
        ByteBuf slice = (ByteBuf)segment.payload;
        if (this.targetLength == Integer.MIN_VALUE) {
            this.targetLength = 9 + this.frameCodec.decodeBodySize(slice);
        }
        this.accumulatedSlices.add(slice);
        this.accumulatedLength += slice.readableBytes();
        int accumulatedSlicesSize = this.accumulatedSlices.size();
        LOG.trace("[{}] Decoded slice {}, {}/{} bytes", new Object[]{this.logPrefix, accumulatedSlicesSize, this.accumulatedLength, this.targetLength});
        assert (this.accumulatedLength <= this.targetLength);
        if (this.accumulatedLength == this.targetLength) {
            Frame frame;
            CompositeByteBuf encodedFrame = allocator.compositeBuffer(accumulatedSlicesSize);
            encodedFrame.addComponents(true, this.accumulatedSlices);
            try {
                frame = this.frameCodec.decode((ByteBuf)encodedFrame);
            }
            finally {
                encodedFrame.release();
                this.targetLength = Integer.MIN_VALUE;
                this.accumulatedSlices.clear();
                this.accumulatedLength = 0;
            }
            LOG.trace("[{}] Decoded response frame {} from {} slices", new Object[]{this.logPrefix, frame.streamId, accumulatedSlicesSize});
            out.add(frame);
        }
    }
}

