/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRequestHandler;
import com.datastax.oss.driver.internal.core.adminrequest.AdminResult;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRow;
import com.datastax.oss.driver.internal.core.adminrequest.UnexpectedResponseException;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.control.ControlConnection;
import com.datastax.oss.driver.internal.core.metadata.DefaultEndPoint;
import com.datastax.oss.driver.internal.core.metadata.DefaultNodeInfo;
import com.datastax.oss.driver.internal.core.metadata.NodeInfo;
import com.datastax.oss.driver.internal.core.metadata.PeerRowValidator;
import com.datastax.oss.driver.internal.core.metadata.SchemaAgreementChecker;
import com.datastax.oss.driver.internal.core.metadata.TopologyMonitor;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableCollection;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.datastax.oss.protocol.internal.response.Error;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DefaultTopologyMonitor
implements TopologyMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTopologyMonitor.class);
    private static final int INFINITE_PAGE_SIZE = -1;
    private final String logPrefix;
    private final InternalDriverContext context;
    private final ControlConnection controlConnection;
    private final Duration timeout;
    private final boolean reconnectOnInit;
    private final CompletableFuture<Void> closeFuture;
    @VisibleForTesting
    volatile boolean isSchemaV2;
    @VisibleForTesting
    volatile int port = -1;

    public DefaultTopologyMonitor(InternalDriverContext context) {
        this.logPrefix = context.getSessionName();
        this.context = context;
        this.controlConnection = context.getControlConnection();
        DriverExecutionProfile config = context.getConfig().getDefaultProfile();
        this.timeout = config.getDuration(DefaultDriverOption.CONTROL_CONNECTION_TIMEOUT);
        this.reconnectOnInit = config.getBoolean(DefaultDriverOption.RECONNECT_ON_INIT);
        this.closeFuture = new CompletableFuture();
        this.isSchemaV2 = true;
    }

    @Override
    public CompletionStage<Void> init() {
        if (this.closeFuture.isDone()) {
            return CompletableFutures.failedFuture(new IllegalStateException("closed"));
        }
        return this.controlConnection.init(true, this.reconnectOnInit, true);
    }

    @Override
    public CompletionStage<Void> initFuture() {
        return this.controlConnection.initFuture();
    }

    @Override
    public CompletionStage<Optional<NodeInfo>> refreshNode(Node node) {
        if (this.closeFuture.isDone()) {
            return CompletableFutures.failedFuture(new IllegalStateException("closed"));
        }
        LOG.debug("[{}] Refreshing info for {}", (Object)this.logPrefix, (Object)node);
        DriverChannel channel = this.controlConnection.channel();
        EndPoint localEndPoint = channel.getEndPoint();
        if (node.getEndPoint().equals(channel.getEndPoint())) {
            LOG.debug("[{}] Ignoring refresh of control node", (Object)this.logPrefix);
            return CompletableFuture.completedFuture(Optional.empty());
        }
        if (node.getBroadcastAddress().isPresent()) {
            CompletionStage<AdminResult> query = this.isSchemaV2 ? this.query(channel, "SELECT * FROM " + this.getPeerTableName() + " WHERE peer = :address and peer_port = :port", ImmutableMap.of("address", node.getBroadcastAddress().get().getAddress(), "port", node.getBroadcastAddress().get().getPort())) : this.query(channel, "SELECT * FROM " + this.getPeerTableName() + " WHERE peer = :address", ImmutableMap.of("address", node.getBroadcastAddress().get().getAddress()));
            return query.thenApply(result -> this.firstPeerRowAsNodeInfo((AdminResult)result, localEndPoint));
        }
        return this.query(channel, "SELECT * FROM " + this.getPeerTableName()).thenApply(result -> this.findInPeers((AdminResult)result, node.getHostId(), localEndPoint));
    }

    @Override
    public CompletionStage<Optional<NodeInfo>> getNewNodeInfo(InetSocketAddress broadcastRpcAddress) {
        if (this.closeFuture.isDone()) {
            return CompletableFutures.failedFuture(new IllegalStateException("closed"));
        }
        LOG.debug("[{}] Fetching info for new node {}", (Object)this.logPrefix, (Object)broadcastRpcAddress);
        DriverChannel channel = this.controlConnection.channel();
        EndPoint localEndPoint = channel.getEndPoint();
        return this.query(channel, "SELECT * FROM " + this.getPeerTableName()).thenApply(result -> this.findInPeers((AdminResult)result, broadcastRpcAddress, localEndPoint));
    }

    @Override
    public CompletionStage<Iterable<NodeInfo>> refreshNodeList() {
        if (this.closeFuture.isDone()) {
            return CompletableFutures.failedFuture(new IllegalStateException("closed"));
        }
        LOG.debug("[{}] Refreshing node list", (Object)this.logPrefix);
        DriverChannel channel = this.controlConnection.channel();
        EndPoint localEndPoint = channel.getEndPoint();
        this.savePort(channel);
        CompletionStage<AdminResult> localQuery = this.query(channel, "SELECT * FROM system.local");
        CompletionStage<AdminResult> peersV2Query = this.query(channel, "SELECT * FROM system.peers_v2");
        CompletableFuture peersQuery = new CompletableFuture();
        peersV2Query.whenComplete((r, t) -> {
            if (t != null) {
                if (t instanceof UnexpectedResponseException && ((UnexpectedResponseException)t).message instanceof Error) {
                    Error error = (Error)((UnexpectedResponseException)t).message;
                    if (error.code == 8704 || error.code == 0 && error.message.contains("Unknown keyspace/cf pair (system.peers_v2)")) {
                        this.isSchemaV2 = false;
                        CompletableFutures.completeFrom(this.query(channel, "SELECT * FROM system.peers"), peersQuery);
                        return;
                    }
                }
                peersQuery.completeExceptionally((Throwable)t);
            } else {
                peersQuery.complete(r);
            }
        });
        return localQuery.thenCombine(peersQuery, (controlNodeResult, peersResult) -> {
            ArrayList<DefaultNodeInfo> nodeInfos = new ArrayList<DefaultNodeInfo>();
            AdminRow localRow = controlNodeResult.iterator().next();
            InetSocketAddress localBroadcastRpcAddress = this.getBroadcastRpcAddress(localRow, localEndPoint);
            nodeInfos.add(this.nodeInfoBuilder(localRow, localBroadcastRpcAddress, localEndPoint).build());
            for (AdminRow peerRow : peersResult) {
                InetSocketAddress peerBroadcastRpcAddress;
                if (!this.isPeerValid(peerRow) || (peerBroadcastRpcAddress = this.getBroadcastRpcAddress(peerRow, localEndPoint)) == null) continue;
                DefaultNodeInfo nodeInfo = this.nodeInfoBuilder(peerRow, peerBroadcastRpcAddress, localEndPoint).build();
                nodeInfos.add(nodeInfo);
            }
            return nodeInfos;
        });
    }

    @Override
    public CompletionStage<Boolean> checkSchemaAgreement() {
        if (this.closeFuture.isDone()) {
            return CompletableFuture.completedFuture(true);
        }
        DriverChannel channel = this.controlConnection.channel();
        return new SchemaAgreementChecker(channel, this.context, this.logPrefix).run();
    }

    @Override
    @NonNull
    public CompletionStage<Void> closeFuture() {
        return this.closeFuture;
    }

    @Override
    @NonNull
    public CompletionStage<Void> closeAsync() {
        this.closeFuture.complete(null);
        return this.closeFuture;
    }

    @Override
    @NonNull
    public CompletionStage<Void> forceCloseAsync() {
        return this.closeAsync();
    }

    @VisibleForTesting
    protected CompletionStage<AdminResult> query(DriverChannel channel, String queryString, Map<String, Object> parameters) {
        AdminRequestHandler<AdminResult> handler;
        try {
            handler = AdminRequestHandler.query(channel, queryString, parameters, this.timeout, -1, this.logPrefix);
        }
        catch (Exception e) {
            return CompletableFutures.failedFuture(e);
        }
        return handler.start();
    }

    private CompletionStage<AdminResult> query(DriverChannel channel, String queryString) {
        return this.query(channel, queryString, Collections.emptyMap());
    }

    private String getPeerTableName() {
        return this.isSchemaV2 ? "system.peers_v2" : "system.peers";
    }

    private Optional<NodeInfo> firstPeerRowAsNodeInfo(AdminResult result, EndPoint localEndPoint) {
        AdminRow row;
        Iterator<AdminRow> iterator = result.iterator();
        if (iterator.hasNext() && this.isPeerValid(row = iterator.next())) {
            return Optional.ofNullable(this.getBroadcastRpcAddress(row, localEndPoint)).map(broadcastRpcAddress -> this.nodeInfoBuilder(row, (InetSocketAddress)broadcastRpcAddress, localEndPoint).build());
        }
        return Optional.empty();
    }

    @NonNull
    protected DefaultNodeInfo.Builder nodeInfoBuilder(@NonNull AdminRow row, @Nullable InetSocketAddress broadcastRpcAddress, @NonNull EndPoint localEndPoint) {
        ImmutableCollection workloads;
        Set<String> modernWorkloads;
        String legacyWorkload;
        EndPoint endPoint = this.buildNodeEndPoint(row, broadcastRpcAddress, localEndPoint);
        InetAddress broadcastInetAddress = row.getInetAddress("broadcast_address");
        if (broadcastInetAddress == null) {
            broadcastInetAddress = row.getInetAddress("peer");
        }
        Integer broadcastPort = 0;
        if (row.contains("broadcast_port")) {
            broadcastPort = row.getInteger("broadcast_port");
        } else if (row.contains("peer_port")) {
            broadcastPort = row.getInteger("peer_port");
        }
        InetSocketAddress broadcastAddress = null;
        if (broadcastInetAddress != null && broadcastPort != null) {
            broadcastAddress = new InetSocketAddress(broadcastInetAddress, (int)broadcastPort);
        }
        InetAddress listenInetAddress = row.getInetAddress("listen_address");
        Integer listenPort = 0;
        if (row.contains("listen_port")) {
            listenPort = row.getInteger("listen_port");
        }
        InetSocketAddress listenAddress = null;
        if (listenInetAddress != null && listenPort != null) {
            listenAddress = new InetSocketAddress(listenInetAddress, (int)listenPort);
        }
        DefaultNodeInfo.Builder builder = DefaultNodeInfo.builder().withEndPoint(endPoint).withBroadcastRpcAddress(broadcastRpcAddress).withBroadcastAddress(broadcastAddress).withListenAddress(listenAddress).withDatacenter(row.getString("data_center")).withRack(row.getString("rack")).withCassandraVersion(row.getString("release_version")).withTokens(row.getSetOfString("tokens")).withPartitioner(row.getString("partitioner")).withHostId(Objects.requireNonNull(row.getUuid("host_id"))).withSchemaVersion(row.getUuid("schema_version"));
        String rawVersion = row.getString("dse_version");
        if (rawVersion != null) {
            builder.withExtra("DSE_VERSION", Version.parse(rawVersion));
        }
        ImmutableSet.Builder workloadsBuilder = ImmutableSet.builder();
        Boolean legacyGraph = row.getBoolean("graph");
        if (legacyGraph != null && legacyGraph.booleanValue()) {
            workloadsBuilder.add("Graph");
        }
        if ((legacyWorkload = row.getString("workload")) != null) {
            workloadsBuilder.add(legacyWorkload);
        }
        if ((modernWorkloads = row.getSetOfString("workloads")) != null) {
            workloadsBuilder.addAll(modernWorkloads);
        }
        if (!(workloads = workloadsBuilder.build()).isEmpty()) {
            builder.withExtra("DSE_WORKLOADS", workloads);
        }
        builder.withExtra("SERVER_ID", row.getString("server_id")).withExtra("NATIVE_TRANSPORT_PORT", row.getInteger("native_transport_port")).withExtra("NATIVE_TRANSPORT_PORT_SSL", row.getInteger("native_transport_port_ssl")).withExtra("STORAGE_PORT", row.getInteger("storage_port")).withExtra("STORAGE_PORT_SSL", row.getInteger("storage_port_ssl")).withExtra("JMX_PORT", row.getInteger("jmx_port"));
        return builder;
    }

    @NonNull
    protected EndPoint buildNodeEndPoint(@NonNull AdminRow row, @Nullable InetSocketAddress broadcastRpcAddress, @NonNull EndPoint localEndPoint) {
        boolean peer = row.contains("peer");
        if (peer) {
            Objects.requireNonNull(broadcastRpcAddress, "broadcastRpcAddress cannot be null for a peer row");
            return new DefaultEndPoint(this.context.getAddressTranslator().translate(broadcastRpcAddress));
        }
        return localEndPoint;
    }

    private Optional<NodeInfo> findInPeers(AdminResult result, InetSocketAddress broadcastRpcAddressToFind, EndPoint localEndPoint) {
        for (AdminRow row : result) {
            InetSocketAddress broadcastRpcAddress = this.getBroadcastRpcAddress(row, localEndPoint);
            if (broadcastRpcAddress == null || !broadcastRpcAddress.equals(broadcastRpcAddressToFind) || !this.isPeerValid(row)) continue;
            return Optional.of(this.nodeInfoBuilder(row, broadcastRpcAddress, localEndPoint).build());
        }
        LOG.debug("[{}] Could not find any peer row matching {}", (Object)this.logPrefix, (Object)broadcastRpcAddressToFind);
        return Optional.empty();
    }

    private Optional<NodeInfo> findInPeers(AdminResult result, UUID hostIdToFind, EndPoint localEndPoint) {
        for (AdminRow row : result) {
            UUID hostId = row.getUuid("host_id");
            if (hostId == null || !hostId.equals(hostIdToFind) || !this.isPeerValid(row)) continue;
            return Optional.ofNullable(this.getBroadcastRpcAddress(row, localEndPoint)).map(broadcastRpcAddress -> this.nodeInfoBuilder(row, (InetSocketAddress)broadcastRpcAddress, localEndPoint).build());
        }
        LOG.debug("[{}] Could not find any peer row matching {}", (Object)this.logPrefix, (Object)hostIdToFind);
        return Optional.empty();
    }

    private void savePort(DriverChannel channel) {
        SocketAddress address;
        if (this.port < 0 && (address = channel.getEndPoint().resolve()) instanceof InetSocketAddress) {
            this.port = ((InetSocketAddress)address).getPort();
        }
    }

    @Nullable
    protected InetSocketAddress getBroadcastRpcAddress(@NonNull AdminRow row, @NonNull EndPoint localEndPoint) {
        InetAddress broadcastRpcInetAddress = row.getInetAddress("rpc_address");
        if (broadcastRpcInetAddress == null && (broadcastRpcInetAddress = row.getInetAddress("native_address")) == null) {
            return null;
        }
        Integer broadcastRpcPort = row.getInteger("rpc_port");
        if (!(broadcastRpcPort != null && broadcastRpcPort != 0 || (broadcastRpcPort = row.getInteger("native_port")) != null && broadcastRpcPort != 0)) {
            broadcastRpcPort = this.port == -1 ? 0 : this.port;
        }
        InetSocketAddress broadcastRpcAddress = new InetSocketAddress(broadcastRpcInetAddress, (int)broadcastRpcPort);
        if (row.contains("peer") && broadcastRpcAddress.equals(localEndPoint.resolve())) {
            LOG.warn("[{}] Control node {} has an entry for itself in {}: this entry will be ignored. This is likely due to a misconfiguration; please verify your rpc_address configuration in cassandra.yaml on all nodes in your cluster.", new Object[]{this.logPrefix, localEndPoint, this.getPeerTableName()});
            return null;
        }
        return broadcastRpcAddress;
    }

    protected boolean isPeerValid(AdminRow peerRow) {
        if (PeerRowValidator.isValid(peerRow, this.context.getConfig().getDefaultProfile().getBoolean(DefaultDriverOption.METADATA_ALLOW_ZERO_TOKEN_PEERS))) {
            return true;
        }
        LOG.warn("[{}] Found invalid row in {} for peer: {}. This is likely a gossip or snitch issue, this node will be ignored.", new Object[]{this.logPrefix, this.getPeerTableName(), peerRow.getInetAddress("peer")});
        return false;
    }
}

