/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.data;

import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.base.Predicates;
import com.datastax.oss.driver.shaded.guava.common.base.Splitter;
import com.datastax.oss.driver.shaded.guava.common.collect.Iterables;
import com.datastax.oss.driver.shaded.guava.common.collect.Streams;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CqlVector<T extends Number>
implements Iterable<T>,
Serializable {
    private final List<T> list;

    public static <V extends Number> CqlVector<V> newInstance(V ... vals) {
        return new CqlVector<V>(Arrays.asList(vals));
    }

    public static <V extends Number> CqlVector<V> newInstance(List<V> list) {
        Preconditions.checkArgument(list != null, "Input list should not be null");
        return new CqlVector<V>(list);
    }

    public static <V extends Number> CqlVector<V> from(@NonNull String str, @NonNull TypeCodec<V> subtypeCodec) {
        Preconditions.checkArgument(str != null, "Cannot create CqlVector from null string");
        Preconditions.checkArgument(!str.isEmpty(), "Cannot create CqlVector from empty string");
        ArrayList vals = Streams.stream(Splitter.on(", ").split(str.substring(1, str.length() - 1))).map(subtypeCodec::parse).collect(Collectors.toCollection(ArrayList::new));
        return new CqlVector(vals);
    }

    private CqlVector(@NonNull List<T> list) {
        Preconditions.checkArgument(Iterables.all(list, Predicates.notNull()), "CqlVectors cannot contain null values");
        this.list = list;
    }

    public T get(int idx) {
        return (T)((Number)this.list.get(idx));
    }

    public T set(int idx, T val) {
        return (T)((Number)this.list.set(idx, val));
    }

    public int size() {
        return this.list.size();
    }

    public CqlVector<T> subVector(int from, int to) {
        return new CqlVector<T>(this.list.subList(from, to));
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    public Stream<T> stream() {
        return this.list.stream();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CqlVector) {
            CqlVector that = (CqlVector)o;
            return this.list.equals(that.list);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.list);
    }

    public String toString() {
        return Iterables.toString(this.list);
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static class SerializationProxy<T extends Number>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient List<T> list;

        SerializationProxy(CqlVector<T> vector) {
            this.list = ((CqlVector)vector).list;
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            int size = stream.readInt();
            this.list = new ArrayList<T>();
            for (int i = 0; i < size; ++i) {
                this.list.add((Number)stream.readObject());
            }
        }

        private Object readResolve() throws ObjectStreamException {
            return new CqlVector(this.list);
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
            stream.writeInt(this.list.size());
            for (Number item : this.list) {
                stream.writeObject(item);
            }
        }
    }
}

