/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.insights;

import com.datastax.dse.driver.api.core.DseProtocolVersion;
import com.datastax.dse.driver.internal.core.insights.AddressFormatter;
import com.datastax.dse.driver.internal.core.insights.ConfigAntiPatternsFinder;
import com.datastax.dse.driver.internal.core.insights.DataCentersFinder;
import com.datastax.dse.driver.internal.core.insights.ExecutionProfilesInfoFinder;
import com.datastax.dse.driver.internal.core.insights.InsightsSupportVerifier;
import com.datastax.dse.driver.internal.core.insights.PackageUtil;
import com.datastax.dse.driver.internal.core.insights.PlatformInfoFinder;
import com.datastax.dse.driver.internal.core.insights.ReconnectionPolicyInfoFinder;
import com.datastax.dse.driver.internal.core.insights.configuration.InsightsConfiguration;
import com.datastax.dse.driver.internal.core.insights.exceptions.InsightEventFormatException;
import com.datastax.dse.driver.internal.core.insights.schema.AuthProviderType;
import com.datastax.dse.driver.internal.core.insights.schema.Insight;
import com.datastax.dse.driver.internal.core.insights.schema.InsightMetadata;
import com.datastax.dse.driver.internal.core.insights.schema.InsightType;
import com.datastax.dse.driver.internal.core.insights.schema.InsightsStartupData;
import com.datastax.dse.driver.internal.core.insights.schema.InsightsStatusData;
import com.datastax.dse.driver.internal.core.insights.schema.PoolSizeByHostDistance;
import com.datastax.dse.driver.internal.core.insights.schema.SSL;
import com.datastax.dse.driver.internal.core.insights.schema.SessionStateForNode;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.session.SessionBuilder;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRequestHandler;
import com.datastax.oss.driver.internal.core.context.DefaultDriverContext;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.control.ControlConnection;
import com.datastax.oss.driver.internal.core.pool.ChannelPool;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.protocol.internal.request.Query;
import com.datastax.oss.protocol.internal.request.query.QueryOptions;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsightsClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(InsightsClient.class);
    private static final String STARTUP_MESSAGE_NAME = "driver.startup";
    private static final String STATUS_MESSAGE_NAME = "driver.status";
    private static final String REPORT_INSIGHT_RPC = "CALL InsightsRpc.reportInsight(?)";
    private static final Map<String, String> TAGS = ImmutableMap.of("language", "java");
    private static final String STARTUP_VERSION_1_ID = "v1";
    private static final String STATUS_VERSION_1_ID = "v1";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final int MAX_NUMBER_OF_STATUS_ERROR_LOGS = 5;
    static final String DEFAULT_JAVA_APPLICATION = "Default Java Application";
    private final ControlConnection controlConnection;
    private final String id = Uuids.random().toString();
    private final InsightsConfiguration insightsConfiguration;
    private final AtomicInteger numberOfStatusEventErrors = new AtomicInteger();
    private final InternalDriverContext driverContext;
    private final Supplier<Long> timestampSupplier;
    private final PlatformInfoFinder platformInfoFinder;
    private final ReconnectionPolicyInfoFinder reconnectionPolicyInfoInfoFinder;
    private final ExecutionProfilesInfoFinder executionProfilesInfoFinder;
    private final ConfigAntiPatternsFinder configAntiPatternsFinder;
    private final DataCentersFinder dataCentersFinder;
    private final StackTraceElement[] initCallStackTrace;
    private volatile ScheduledFuture<?> scheduleInsightsTask;

    public static InsightsClient createInsightsClient(InsightsConfiguration insightsConfiguration, InternalDriverContext driverContext, StackTraceElement[] initCallStackTrace) {
        DataCentersFinder dataCentersFinder = new DataCentersFinder();
        return new InsightsClient(driverContext, () -> new Date().getTime(), insightsConfiguration, new PlatformInfoFinder(), new ReconnectionPolicyInfoFinder(), new ExecutionProfilesInfoFinder(), new ConfigAntiPatternsFinder(), dataCentersFinder, initCallStackTrace);
    }

    InsightsClient(InternalDriverContext driverContext, Supplier<Long> timestampSupplier, InsightsConfiguration insightsConfiguration, PlatformInfoFinder platformInfoFinder, ReconnectionPolicyInfoFinder reconnectionPolicyInfoInfoFinder, ExecutionProfilesInfoFinder executionProfilesInfoFinder, ConfigAntiPatternsFinder configAntiPatternsFinder, DataCentersFinder dataCentersFinder, StackTraceElement[] initCallStackTrace) {
        this.driverContext = driverContext;
        this.controlConnection = driverContext.getControlConnection();
        this.timestampSupplier = timestampSupplier;
        this.insightsConfiguration = insightsConfiguration;
        this.platformInfoFinder = platformInfoFinder;
        this.reconnectionPolicyInfoInfoFinder = reconnectionPolicyInfoInfoFinder;
        this.executionProfilesInfoFinder = executionProfilesInfoFinder;
        this.configAntiPatternsFinder = configAntiPatternsFinder;
        this.dataCentersFinder = dataCentersFinder;
        this.initCallStackTrace = initCallStackTrace;
    }

    public CompletionStage<Void> sendStartupMessage() {
        try {
            if (!this.shouldSendEvent()) {
                return CompletableFuture.completedFuture(null);
            }
            String startupMessage = this.createStartupMessage();
            return this.sendJsonMessage(startupMessage).whenComplete((aVoid, throwable) -> {
                if (throwable != null) {
                    LOGGER.debug("Error while sending startup message to Insights. Message was: " + InsightsClient.trimToFirst500characters(startupMessage), throwable);
                }
            });
        }
        catch (Exception e) {
            LOGGER.debug("Unexpected error while sending startup message to Insights.", (Throwable)e);
            return CompletableFutures.failedFuture(e);
        }
    }

    private static String trimToFirst500characters(String startupMessage) {
        return startupMessage.substring(0, Math.min(startupMessage.length(), 500));
    }

    public void scheduleStatusMessageSend() {
        if (!this.shouldSendEvent()) {
            return;
        }
        this.scheduleInsightsTask = InsightsClient.scheduleInsightsTask(this.insightsConfiguration.getStatusEventDelayMillis(), (ScheduledExecutorService)this.insightsConfiguration.getExecutor(), this::sendStatusMessage);
    }

    public void shutdown() {
        if (this.scheduleInsightsTask != null) {
            this.scheduleInsightsTask.cancel(false);
        }
    }

    @VisibleForTesting
    public CompletionStage<Void> sendStatusMessage() {
        try {
            String statusMessage = this.createStatusMessage();
            CompletionStage<Void> result = this.sendJsonMessage(statusMessage);
            return result.whenComplete((aVoid, throwable) -> {
                if (throwable != null && this.numberOfStatusEventErrors.getAndIncrement() < 5) {
                    LOGGER.debug("Error while sending status message to Insights. Message was: " + InsightsClient.trimToFirst500characters(statusMessage), throwable);
                }
            });
        }
        catch (Exception e) {
            LOGGER.debug("Unexpected error while sending status message to Insights.", (Throwable)e);
            return CompletableFutures.failedFuture(e);
        }
    }

    private CompletionStage<Void> sendJsonMessage(String jsonMessage) {
        QueryOptions queryOptions = this.createQueryOptionsWithJson(jsonMessage);
        String logPrefix = this.driverContext.getSessionName();
        Duration timeout = this.driverContext.getConfig().getDefaultProfile().getDuration(DefaultDriverOption.CONTROL_CONNECTION_TIMEOUT);
        LOGGER.debug("sending JSON message: {}", (Object)jsonMessage);
        Query query = new Query(REPORT_INSIGHT_RPC, queryOptions);
        return AdminRequestHandler.call(this.controlConnection.channel(), query, timeout, logPrefix).start();
    }

    private QueryOptions createQueryOptionsWithJson(String json) {
        TypeCodec<Class<String>> codec = this.driverContext.getCodecRegistry().codecFor(DataTypes.TEXT, String.class);
        ByteBuffer startupMessageSerialized = codec.encode((Class<String>)((Object)json), DseProtocolVersion.DSE_V2);
        return new QueryOptions(QueryOptions.DEFAULT.consistency, Collections.singletonList(startupMessageSerialized), QueryOptions.DEFAULT.namedValues, QueryOptions.DEFAULT.skipMetadata, QueryOptions.DEFAULT.pageSize, QueryOptions.DEFAULT.pagingState, QueryOptions.DEFAULT.serialConsistency, QueryOptions.DEFAULT.defaultTimestamp, QueryOptions.DEFAULT.keyspace, QueryOptions.DEFAULT.nowInSeconds);
    }

    private boolean shouldSendEvent() {
        try {
            return this.insightsConfiguration.isMonitorReportingEnabled() && InsightsSupportVerifier.supportsInsights(this.driverContext.getMetadataManager().getMetadata().getNodes().values());
        }
        catch (Exception e) {
            LOGGER.debug("Unexpected error while checking Insights support.", (Throwable)e);
            return false;
        }
    }

    @VisibleForTesting
    String createStartupMessage() {
        InsightMetadata insightMetadata = this.createMetadata(STARTUP_MESSAGE_NAME, "v1");
        InsightsStartupData data = this.createStartupData();
        try {
            return OBJECT_MAPPER.writeValueAsString(new Insight<InsightsStartupData>(insightMetadata, data));
        }
        catch (JsonProcessingException e) {
            throw new InsightEventFormatException("Problem when creating: driver.startup", e);
        }
    }

    @VisibleForTesting
    String createStatusMessage() {
        InsightMetadata insightMetadata = this.createMetadata(STATUS_MESSAGE_NAME, "v1");
        InsightsStatusData data = this.createStatusData();
        try {
            return OBJECT_MAPPER.writeValueAsString(new Insight<InsightsStatusData>(insightMetadata, data));
        }
        catch (JsonProcessingException e) {
            throw new InsightEventFormatException("Problem when creating: driver.status", e);
        }
    }

    private InsightsStatusData createStatusData() {
        Map<String, String> startupOptions = this.driverContext.getStartupOptions();
        return InsightsStatusData.builder().withClientId(this.getClientId(startupOptions)).withSessionId(this.id).withControlConnection(this.getControlConnectionSocketAddress()).withConnectedNodes(this.getConnectedNodes()).build();
    }

    private Map<String, SessionStateForNode> getConnectedNodes() {
        Map<Node, ChannelPool> pools = this.driverContext.getPoolManager().getPools();
        return pools.entrySet().stream().collect(Collectors.toMap(entry -> AddressFormatter.nullSafeToString(((Node)entry.getKey()).getEndPoint().resolve()), this::constructSessionStateForNode));
    }

    private SessionStateForNode constructSessionStateForNode(Map.Entry<Node, ChannelPool> entry) {
        return new SessionStateForNode(entry.getKey().getOpenConnections(), entry.getValue().getInFlight());
    }

    private InsightsStartupData createStartupData() {
        Map<String, String> startupOptions = this.driverContext.getStartupOptions();
        return InsightsStartupData.builder().withClientId(this.getClientId(startupOptions)).withSessionId(this.id).withApplicationName(this.getApplicationName(startupOptions)).withApplicationVersion(this.getApplicationVersion(startupOptions)).withDriverName(this.getDriverName(startupOptions)).withDriverVersion(this.getDriverVersion(startupOptions)).withContactPoints(InsightsClient.getResolvedContactPoints(this.driverContext.getMetadataManager().getContactPoints().stream().map(n -> n.getEndPoint().resolve()).filter(InetSocketAddress.class::isInstance).map(InetSocketAddress.class::cast).collect(Collectors.toSet()))).withInitialControlConnection(this.getControlConnectionSocketAddress()).withProtocolVersion(this.driverContext.getProtocolVersion().getCode()).withLocalAddress(this.getLocalAddress()).withExecutionProfiles(this.executionProfilesInfoFinder.getExecutionProfilesInfo(this.driverContext)).withPoolSizeByHostDistance(this.getPoolSizeByHostDistance()).withHeartbeatInterval(this.driverContext.getConfig().getDefaultProfile().getDuration(DefaultDriverOption.HEARTBEAT_INTERVAL).toMillis()).withCompression(this.driverContext.getConfig().getDefaultProfile().getString(DefaultDriverOption.PROTOCOL_COMPRESSION, "none")).withReconnectionPolicy(this.reconnectionPolicyInfoInfoFinder.getReconnectionPolicyInfo(this.driverContext.getReconnectionPolicy(), this.driverContext.getConfig().getDefaultProfile())).withSsl(this.getSsl()).withAuthProvider(this.getAuthProvider()).withOtherOptions(this.getOtherOptions()).withPlatformInfo(this.platformInfoFinder.getInsightsPlatformInfo()).withConfigAntiPatterns(this.configAntiPatternsFinder.findAntiPatterns(this.driverContext)).withPeriodicStatusInterval(this.getPeriodicStatusInterval()).withHostName(this.getLocalHostName()).withApplicationNameWasGenerated(this.isApplicationNameGenerated(startupOptions)).withDataCenters(this.dataCentersFinder.getDataCenters(this.driverContext)).build();
    }

    private AuthProviderType getAuthProvider() {
        String authProviderClassName = this.driverContext.getConfig().getDefaultProfile().getString(DefaultDriverOption.AUTH_PROVIDER_CLASS, "NoAuthProvider");
        PackageUtil.ClassSettingDetails authProviderDetails = PackageUtil.getAuthProviderDetails(authProviderClassName);
        return new AuthProviderType(authProviderDetails.getClassName(), authProviderDetails.getFullPackage());
    }

    private long getPeriodicStatusInterval() {
        return TimeUnit.MILLISECONDS.toSeconds(this.insightsConfiguration.getStatusEventDelayMillis());
    }

    @VisibleForTesting
    static Map<String, List<String>> getResolvedContactPoints(Set<InetSocketAddress> contactPoints) {
        if (contactPoints == null) {
            return Collections.emptyMap();
        }
        return contactPoints.stream().collect(Collectors.groupingBy(InetSocketAddress::getHostName, Collectors.mapping(AddressFormatter::nullSafeToString, Collectors.toList())));
    }

    private String getDriverVersion(Map<String, String> startupOptions) {
        return startupOptions.get("DRIVER_VERSION");
    }

    private String getDriverName(Map<String, String> startupOptions) {
        return startupOptions.get("DRIVER_NAME");
    }

    private String getClientId(Map<String, String> startupOptions) {
        return startupOptions.get("CLIENT_ID");
    }

    private boolean isApplicationNameGenerated(Map<String, String> startupOptions) {
        return startupOptions.get("APPLICATION_NAME") == null;
    }

    private String getApplicationVersion(Map<String, String> startupOptions) {
        String applicationVersion = startupOptions.get("APPLICATION_VERSION");
        if (applicationVersion == null) {
            return "";
        }
        return applicationVersion;
    }

    private String getApplicationName(Map<String, String> startupOptions) {
        String applicationName = startupOptions.get("APPLICATION_NAME");
        if (applicationName == null || applicationName.isEmpty()) {
            return InsightsClient.getClusterCreateCaller(this.initCallStackTrace);
        }
        return applicationName;
    }

    @VisibleForTesting
    static String getClusterCreateCaller(StackTraceElement[] stackTrace) {
        for (int i = 0; i < stackTrace.length - 1; ++i) {
            int nextElement;
            if (!InsightsClient.isClusterStackTrace(stackTrace[i]) || InsightsClient.isClusterStackTrace(stackTrace[nextElement = i + 1])) continue;
            return stackTrace[nextElement].getClassName();
        }
        return DEFAULT_JAVA_APPLICATION;
    }

    private static boolean isClusterStackTrace(StackTraceElement stackTraceElement) {
        return stackTraceElement.getClassName().equals(DefaultDriverContext.class.getName()) || stackTraceElement.getClassName().equals(SessionBuilder.class.getName());
    }

    private String getLocalHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Can not resolve the name of a host, returning null", (Throwable)e);
            return null;
        }
    }

    private Map<String, Object> getOtherOptions() {
        return Collections.emptyMap();
    }

    private SSL getSsl() {
        boolean isSslDefined = this.driverContext.getConfig().getDefaultProfile().isDefined(DefaultDriverOption.SSL_ENGINE_FACTORY_CLASS);
        boolean certValidation = this.driverContext.getConfig().getDefaultProfile().getBoolean(DefaultDriverOption.SSL_HOSTNAME_VALIDATION, false);
        return new SSL(isSslDefined, certValidation);
    }

    private PoolSizeByHostDistance getPoolSizeByHostDistance() {
        return new PoolSizeByHostDistance(this.driverContext.getConfig().getDefaultProfile().getInt(DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE), this.driverContext.getConfig().getDefaultProfile().getInt(DefaultDriverOption.CONNECTION_POOL_REMOTE_SIZE), 0);
    }

    private String getControlConnectionSocketAddress() {
        SocketAddress controlConnectionAddress = this.controlConnection.channel().getEndPoint().resolve();
        return AddressFormatter.nullSafeToString(controlConnectionAddress);
    }

    private String getLocalAddress() {
        SocketAddress controlConnectionLocalAddress = this.controlConnection.channel().localAddress();
        if (controlConnectionLocalAddress instanceof InetSocketAddress) {
            return AddressFormatter.nullSafeToString(((InetSocketAddress)controlConnectionLocalAddress).getAddress());
        }
        return null;
    }

    private InsightMetadata createMetadata(String messageName, String messageVersion) {
        return new InsightMetadata(messageName, this.timestampSupplier.get(), TAGS, InsightType.EVENT, messageVersion);
    }

    @VisibleForTesting
    static ScheduledFuture<?> scheduleInsightsTask(long statusEventDelayMillis, ScheduledExecutorService scheduledTasksExecutor, Runnable runnable) {
        long initialDelay = (long)Math.floor((double)statusEventDelayMillis - InsightsClient.zeroToTenPercentRandom(statusEventDelayMillis));
        return scheduledTasksExecutor.scheduleWithFixedDelay(runnable, initialDelay, statusEventDelayMillis, TimeUnit.MILLISECONDS);
    }

    private static double zeroToTenPercentRandom(long statusEventDelayMillis) {
        return 0.1 * (double)statusEventDelayMillis * Math.random();
    }
}

