/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.factories;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.styledxmlparser.node.IElementNode;
import com.itextpdf.svg.exceptions.SvgProcessingException;
import com.itextpdf.svg.renderers.INoDrawSvgNodeRenderer;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.factories.DefaultSvgNodeRendererMapper;
import com.itextpdf.svg.renderers.factories.ISvgNodeRendererFactory;
import com.itextpdf.svg.renderers.impl.DefsSvgNodeRenderer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSvgNodeRendererFactory
implements ISvgNodeRendererFactory {
    private final Map<String, DefaultSvgNodeRendererMapper.ISvgNodeRendererCreator> rendererMap = new HashMap<String, DefaultSvgNodeRendererMapper.ISvgNodeRendererCreator>();
    private final Collection<String> ignoredTags = new HashSet<String>();

    public DefaultSvgNodeRendererFactory() {
        DefaultSvgNodeRendererMapper defaultMapper = new DefaultSvgNodeRendererMapper();
        this.rendererMap.putAll(defaultMapper.getMapping());
        this.ignoredTags.addAll(defaultMapper.getIgnoredTags());
    }

    @Override
    public ISvgNodeRenderer createSvgNodeRendererForTag(IElementNode tag, ISvgNodeRenderer parent) {
        if (tag == null) {
            throw new SvgProcessingException("Tag parameter must not be null");
        }
        DefaultSvgNodeRendererMapper.ISvgNodeRendererCreator svgNodeRendererCreator = this.rendererMap.get(tag.name());
        if (svgNodeRendererCreator == null) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.warn(MessageFormatUtil.format("Could not find implementation for tag {0}", tag.name()));
            return null;
        }
        ISvgNodeRenderer result = svgNodeRendererCreator.create();
        if (parent != null && !(result instanceof INoDrawSvgNodeRenderer) && !(parent instanceof DefsSvgNodeRenderer)) {
            result.setParent(parent);
        }
        return result;
    }

    @Override
    public boolean isTagIgnored(IElementNode tag) {
        return this.ignoredTags.contains(tag.name());
    }
}

