/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.util;

import com.itextpdf.commons.utils.MessageFormatUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EscapeGroup {
    private static final Logger LOGGER = LoggerFactory.getLogger(EscapeGroup.class);
    private final char openCharacter;
    private final char closeCharacter;
    private int counter = 0;

    public EscapeGroup(char openCharacter, char closeCharacter) {
        this.openCharacter = openCharacter;
        this.closeCharacter = closeCharacter;
    }

    public EscapeGroup(char escapeChar) {
        this.openCharacter = escapeChar;
        this.closeCharacter = escapeChar;
    }

    boolean isEscaped() {
        return this.counter != 0;
    }

    void processCharacter(char nextCharacter) {
        if (this.openCharacter == this.closeCharacter) {
            if (nextCharacter == this.openCharacter) {
                this.counter = this.isEscaped() ? ++this.counter : --this.counter;
            }
        } else if (nextCharacter == this.openCharacter) {
            ++this.counter;
        } else if (nextCharacter == this.closeCharacter) {
            --this.counter;
            if (this.counter < 0) {
                LOGGER.warn(MessageFormatUtil.format("Incorrect character sequence.", new Object[0]));
                this.counter = 0;
            }
        }
    }
}

