/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.util;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.colors.gradients.AbstractLinearGradientBuilder;
import com.itextpdf.kernel.colors.gradients.GradientColorStop;
import com.itextpdf.kernel.colors.gradients.GradientSpreadMethod;
import com.itextpdf.kernel.colors.gradients.StrategyBasedLinearGradientBuilder;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.styledxmlparser.css.parse.CssDeclarationValueTokenizer;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;
import com.itextpdf.styledxmlparser.exceptions.StyledXMLParserException;
import java.util.ArrayList;
import java.util.List;

public final class CssGradientUtil {
    private static final String LINEAR_GRADIENT_FUNCTION_SUFFIX = "linear-gradient(";
    private static final String REPEATING_LINEAR_GRADIENT_FUNCTION_SUFFIX = "repeating-linear-gradient(";

    private CssGradientUtil() {
    }

    public static boolean isCssLinearGradientValue(String cssValue) {
        if (cssValue == null) {
            return false;
        }
        String normalizedValue = cssValue.toLowerCase().trim();
        return normalizedValue.endsWith(")") && (normalizedValue.startsWith(LINEAR_GRADIENT_FUNCTION_SUFFIX) || normalizedValue.startsWith(REPEATING_LINEAR_GRADIENT_FUNCTION_SUFFIX));
    }

    public static StrategyBasedLinearGradientBuilder parseCssLinearGradient(String cssGradientValue, float emValue, float remValue) {
        if (CssGradientUtil.isCssLinearGradientValue(cssGradientValue)) {
            cssGradientValue = cssGradientValue.toLowerCase().trim();
            boolean isRepeating = false;
            String argumentsPart = null;
            if (cssGradientValue.startsWith(LINEAR_GRADIENT_FUNCTION_SUFFIX)) {
                argumentsPart = cssGradientValue.substring(LINEAR_GRADIENT_FUNCTION_SUFFIX.length(), cssGradientValue.length() - 1);
                isRepeating = false;
            } else if (cssGradientValue.startsWith(REPEATING_LINEAR_GRADIENT_FUNCTION_SUFFIX)) {
                argumentsPart = cssGradientValue.substring(REPEATING_LINEAR_GRADIENT_FUNCTION_SUFFIX.length(), cssGradientValue.length() - 1);
                isRepeating = true;
            }
            if (argumentsPart != null) {
                CssDeclarationValueTokenizer.Token nextToken;
                ArrayList<String> argumentsList = new ArrayList<String>();
                StringBuilder buff = new StringBuilder();
                CssDeclarationValueTokenizer tokenizer = new CssDeclarationValueTokenizer(argumentsPart);
                while ((nextToken = tokenizer.getNextValidToken()) != null) {
                    if (nextToken.getType() == CssDeclarationValueTokenizer.TokenType.COMMA) {
                        if (buff.length() == 0) continue;
                        argumentsList.add(buff.toString().trim());
                        buff = new StringBuilder();
                        continue;
                    }
                    buff.append(" ").append(nextToken.getValue());
                }
                if (buff.length() != 0) {
                    argumentsList.add(buff.toString().trim());
                }
                if (argumentsList.isEmpty()) {
                    throw new StyledXMLParserException(MessageFormatUtil.format("Invalid gradient function arguments list: {0}", cssGradientValue));
                }
                return CssGradientUtil.parseCssLinearGradient(argumentsList, isRepeating, emValue, remValue);
            }
        }
        return null;
    }

    private static StrategyBasedLinearGradientBuilder parseCssLinearGradient(List<String> argumentsList, boolean isRepeating, float emValue, float remValue) {
        int colorStopListStartIndex;
        StrategyBasedLinearGradientBuilder builder = new StrategyBasedLinearGradientBuilder();
        GradientSpreadMethod gradientSpreadMethod = isRepeating ? GradientSpreadMethod.REPEAT : GradientSpreadMethod.PAD;
        builder.setSpreadMethod(gradientSpreadMethod);
        String firstArgument = argumentsList.get(0);
        if (CssTypesValidationUtils.isAngleValue(firstArgument)) {
            double radAngle = CssDimensionParsingUtils.parseAngle(firstArgument);
            builder.setGradientDirectionAsCentralRotationAngle(-radAngle);
            colorStopListStartIndex = 1;
        } else if (firstArgument.startsWith("to ")) {
            StrategyBasedLinearGradientBuilder.GradientStrategy gradientStrategy = CssGradientUtil.parseDirection(firstArgument);
            builder.setGradientDirectionAsStrategy(gradientStrategy);
            colorStopListStartIndex = 1;
        } else {
            builder.setGradientDirectionAsStrategy(StrategyBasedLinearGradientBuilder.GradientStrategy.TO_BOTTOM);
            colorStopListStartIndex = 0;
        }
        CssGradientUtil.addStopColors(builder, argumentsList, colorStopListStartIndex, emValue, remValue);
        return builder;
    }

    private static void addStopColors(AbstractLinearGradientBuilder builder, List<String> argumentsList, int stopsStartIndex, float emValue, float remValue) {
        GradientColorStop lastCreatedStopColor = null;
        int lastStopIndex = argumentsList.size() - 1;
        for (int i = stopsStartIndex; i <= lastStopIndex; ++i) {
            CssDeclarationValueTokenizer.Token nextToken;
            String argument = argumentsList.get(i);
            ArrayList<String> elementsList = new ArrayList<String>();
            CssDeclarationValueTokenizer tokenizer = new CssDeclarationValueTokenizer(argument);
            while ((nextToken = tokenizer.getNextValidToken()) != null) {
                elementsList.add(nextToken.getValue());
            }
            if (elementsList.isEmpty() || elementsList.size() > 3) {
                throw new StyledXMLParserException(MessageFormatUtil.format("Invalid color stop value: {0}", argument));
            }
            if (CssTypesValidationUtils.isColorProperty((String)elementsList.get(0))) {
                float[] rgba = CssDimensionParsingUtils.parseRgbaColor((String)elementsList.get(0));
                if (elementsList.size() == 1) {
                    UnitValue offset = i == stopsStartIndex ? new UnitValue(2, 0.0f) : (i == lastStopIndex ? new UnitValue(2, 100.0f) : null);
                    lastCreatedStopColor = CssGradientUtil.createStopColor(rgba, offset);
                    builder.addColorStop(lastCreatedStopColor);
                    continue;
                }
                for (int j = 1; j < elementsList.size(); ++j) {
                    if (CssTypesValidationUtils.isNumber((String)elementsList.get(j))) {
                        throw new StyledXMLParserException(MessageFormatUtil.format("Invalid color stop value: {0}", argument));
                    }
                    UnitValue offset = CssDimensionParsingUtils.parseLengthValueToPt((String)elementsList.get(j), emValue, remValue);
                    if (offset == null) {
                        throw new StyledXMLParserException(MessageFormatUtil.format("Invalid color stop value: {0}", argument));
                    }
                    lastCreatedStopColor = CssGradientUtil.createStopColor(rgba, offset);
                    builder.addColorStop(lastCreatedStopColor);
                }
                continue;
            }
            if (elementsList.size() != 1 || lastCreatedStopColor == null || lastCreatedStopColor.getHintOffsetType() != GradientColorStop.HintOffsetType.NONE || i == lastStopIndex) {
                throw new StyledXMLParserException(MessageFormatUtil.format("Invalid color stop value: {0}", argument));
            }
            UnitValue hint = CssDimensionParsingUtils.parseLengthValueToPt((String)elementsList.get(0), emValue, remValue);
            if (hint == null) {
                throw new StyledXMLParserException(MessageFormatUtil.format("Invalid color stop value: {0}", argument));
            }
            if (hint.getUnitType() == 2) {
                lastCreatedStopColor.setHint(hint.getValue() / 100.0f, GradientColorStop.HintOffsetType.RELATIVE_ON_GRADIENT);
                continue;
            }
            lastCreatedStopColor.setHint(hint.getValue(), GradientColorStop.HintOffsetType.ABSOLUTE_ON_GRADIENT);
        }
    }

    private static StrategyBasedLinearGradientBuilder.GradientStrategy parseDirection(String argument) {
        String[] elementsList = argument.split("\\s+");
        if (elementsList.length < 2) {
            throw new StyledXMLParserException(MessageFormatUtil.format("Invalid direction string: {0}", argument));
        }
        int topCount = 0;
        int bottomCount = 0;
        int leftCount = 0;
        int rightCount = 0;
        for (int i = 1; i < elementsList.length; ++i) {
            if ("top".equals(elementsList[i])) {
                ++topCount;
                continue;
            }
            if ("bottom".equals(elementsList[i])) {
                ++bottomCount;
                continue;
            }
            if ("left".equals(elementsList[i])) {
                ++leftCount;
                continue;
            }
            if ("right".equals(elementsList[i])) {
                ++rightCount;
                continue;
            }
            throw new StyledXMLParserException(MessageFormatUtil.format("Invalid direction string: {0}", argument));
        }
        if (topCount == 1 && bottomCount == 0) {
            if (leftCount == 1 && rightCount == 0) {
                return StrategyBasedLinearGradientBuilder.GradientStrategy.TO_TOP_LEFT;
            }
            if (leftCount == 0 && rightCount == 1) {
                return StrategyBasedLinearGradientBuilder.GradientStrategy.TO_TOP_RIGHT;
            }
            if (leftCount == 0 && rightCount == 0) {
                return StrategyBasedLinearGradientBuilder.GradientStrategy.TO_TOP;
            }
        } else if (topCount == 0 && bottomCount == 1) {
            if (leftCount == 1 && rightCount == 0) {
                return StrategyBasedLinearGradientBuilder.GradientStrategy.TO_BOTTOM_LEFT;
            }
            if (leftCount == 0 && rightCount == 1) {
                return StrategyBasedLinearGradientBuilder.GradientStrategy.TO_BOTTOM_RIGHT;
            }
            if (leftCount == 0 && rightCount == 0) {
                return StrategyBasedLinearGradientBuilder.GradientStrategy.TO_BOTTOM;
            }
        } else if (topCount == 0 && bottomCount == 0) {
            if (leftCount == 1 && rightCount == 0) {
                return StrategyBasedLinearGradientBuilder.GradientStrategy.TO_LEFT;
            }
            if (leftCount == 0 && rightCount == 1) {
                return StrategyBasedLinearGradientBuilder.GradientStrategy.TO_RIGHT;
            }
        }
        throw new StyledXMLParserException(MessageFormatUtil.format("Invalid direction string: {0}", argument));
    }

    private static GradientColorStop createStopColor(float[] rgba, UnitValue offset) {
        double offsetValue;
        GradientColorStop.OffsetType offsetType;
        if (offset == null) {
            offsetType = GradientColorStop.OffsetType.AUTO;
            offsetValue = 0.0;
        } else if (offset.getUnitType() == 1) {
            offsetType = GradientColorStop.OffsetType.ABSOLUTE;
            offsetValue = offset.getValue();
        } else {
            offsetType = GradientColorStop.OffsetType.RELATIVE;
            offsetValue = offset.getValue() / 100.0f;
        }
        return new GradientColorStop(rgba, offsetValue, offsetType);
    }
}

