/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.resolve.shorthand.impl;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.IShorthandResolver;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBoxShorthandResolver
implements IShorthandResolver {
    private static final String _0_LEFT_1 = "{0}-left{1}";
    private static final String _0_RIGHT_1 = "{0}-right{1}";
    private static final String _0_BOTTOM_1 = "{0}-bottom{1}";
    private static final String _0_TOP_1 = "{0}-top{1}";

    protected abstract String getPrefix();

    protected abstract String getPostfix();

    @Override
    public List<CssDeclaration> resolveShorthand(String shorthandExpression) {
        List<String> props = CssUtils.extractShorthandProperties(shorthandExpression).get(0);
        ArrayList<CssDeclaration> resolvedDecl = new ArrayList<CssDeclaration>();
        String topProperty = MessageFormatUtil.format(_0_TOP_1, this.getPrefix(), this.getPostfix());
        String rightProperty = MessageFormatUtil.format(_0_RIGHT_1, this.getPrefix(), this.getPostfix());
        String bottomProperty = MessageFormatUtil.format(_0_BOTTOM_1, this.getPrefix(), this.getPostfix());
        String leftProperty = MessageFormatUtil.format(_0_LEFT_1, this.getPrefix(), this.getPostfix());
        if (props.size() == 1) {
            resolvedDecl.add(new CssDeclaration(topProperty, props.get(0)));
            resolvedDecl.add(new CssDeclaration(rightProperty, props.get(0)));
            resolvedDecl.add(new CssDeclaration(bottomProperty, props.get(0)));
            resolvedDecl.add(new CssDeclaration(leftProperty, props.get(0)));
        } else {
            for (String prop : props) {
                if (!"inherit".equals(prop) && !"initial".equals(prop)) continue;
                Logger logger = LoggerFactory.getLogger(AbstractBoxShorthandResolver.class);
                logger.warn(MessageFormatUtil.format("Invalid css property declaration: {0}", shorthandExpression));
                return Collections.emptyList();
            }
            if (props.size() == 2) {
                resolvedDecl.add(new CssDeclaration(topProperty, props.get(0)));
                resolvedDecl.add(new CssDeclaration(rightProperty, props.get(1)));
                resolvedDecl.add(new CssDeclaration(bottomProperty, props.get(0)));
                resolvedDecl.add(new CssDeclaration(leftProperty, props.get(1)));
            } else if (props.size() == 3) {
                resolvedDecl.add(new CssDeclaration(topProperty, props.get(0)));
                resolvedDecl.add(new CssDeclaration(rightProperty, props.get(1)));
                resolvedDecl.add(new CssDeclaration(bottomProperty, props.get(2)));
                resolvedDecl.add(new CssDeclaration(leftProperty, props.get(1)));
            } else if (props.size() == 4) {
                resolvedDecl.add(new CssDeclaration(topProperty, props.get(0)));
                resolvedDecl.add(new CssDeclaration(rightProperty, props.get(1)));
                resolvedDecl.add(new CssDeclaration(bottomProperty, props.get(2)));
                resolvedDecl.add(new CssDeclaration(leftProperty, props.get(3)));
            }
        }
        return resolvedDecl;
    }
}

