/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.report.xml;

import com.itextpdf.commons.utils.Pair;
import com.itextpdf.signatures.validation.report.xml.CollectableObject;
import com.itextpdf.signatures.validation.report.xml.PadesValidationReport;
import com.itextpdf.signatures.validation.report.xml.SignatureValidationReport;
import com.itextpdf.signatures.validation.report.xml.XmlGeneratorCollectableObjectVisitor;
import com.itextpdf.signatures.validation.report.xml.XmlReportOptions;
import java.io.Writer;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlReportGenerator {
    public static final String DOC_NS = "http://uri.etsi.org/19102/v1.2.1#";
    public static final String DS_NS = "http://www.w3.org/2000/09/xmldsig#";
    public static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XS_NS = "http://www.w3.org/2001/XMLSchema";
    private final XmlReportOptions options;

    public XmlReportGenerator(XmlReportOptions options) {
        this.options = options;
    }

    public void generate(PadesValidationReport report, Writer writer) throws TransformerException, ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        docFactory.setExpandEntityReferences(false);
        docFactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element root = doc.createElement("ValidationReport");
        root.setAttribute("xmlns", DOC_NS);
        root.setAttribute("xmlns:ds", DS_NS);
        root.setAttribute("xmlns:xsi", XSI_NS);
        root.setAttribute("xmlns:xs", XS_NS);
        doc.appendChild(root);
        for (SignatureValidationReport signatureValidation : report.getSignatureValidationReports()) {
            XmlReportGenerator.addSignatureReport(doc, root, signatureValidation);
        }
        Node signatureValidationObjects = root.appendChild(doc.createElementNS(DOC_NS, "SignatureValidationObjects"));
        XmlGeneratorCollectableObjectVisitor visitor = new XmlGeneratorCollectableObjectVisitor(doc, signatureValidationObjects);
        for (CollectableObject object : report.getValidationObjects()) {
            object.accept(visitor);
        }
        TransformerFactory tf = TransformerFactory.newInstance();
        tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        tf.setAttribute("indent-number", 2);
        Transformer trans = tf.newTransformer();
        trans.setOutputProperty("indent", "yes");
        trans.transform(new DOMSource(doc), new StreamResult(writer));
    }

    private static void addSignatureReport(Document doc, Element root, SignatureValidationReport signatureValidation) {
        Collection<Pair<String, String>> messages;
        Node sigValNode = root.appendChild(doc.createElementNS(DOC_NS, "SignatureValidationReport"));
        Element signatureIdentifier = doc.createElementNS(DOC_NS, "SignatureIdentifier");
        signatureIdentifier.setAttribute("id", signatureValidation.getSignatureIdentifier().getIdentifier().getId());
        sigValNode.appendChild(signatureIdentifier);
        Node digestAlgAndValue = signatureIdentifier.appendChild(doc.createElementNS(DOC_NS, "DigestAlgAndValue"));
        ((Element)digestAlgAndValue.appendChild(doc.createElementNS(DS_NS, "ds:DigestMethod"))).setAttributeNS("", "Algorithm", signatureValidation.getSignatureIdentifier().getDigestMethodAlgorithm());
        digestAlgAndValue.appendChild(doc.createElementNS(DS_NS, "ds:DigestValue")).setTextContent(signatureValidation.getSignatureIdentifier().getDigestValue());
        signatureIdentifier.appendChild(doc.createElementNS(DS_NS, "ds:SignatureValue")).setTextContent(signatureValidation.getSignatureIdentifier().getBase64SignatureValue());
        signatureIdentifier.appendChild(doc.createElementNS(DOC_NS, "HashOnly")).setTextContent(String.valueOf(signatureValidation.getSignatureIdentifier().isHashOnly()));
        signatureIdentifier.appendChild(doc.createElementNS(DOC_NS, "DocHashOnly")).setTextContent(String.valueOf(signatureValidation.getSignatureIdentifier().isDocHashOnly()));
        Element status = doc.createElement("SignatureValidationStatus");
        Element mainIndication = doc.createElement("MainIndication");
        mainIndication.setTextContent(signatureValidation.getSignatureValidationStatus().getMainIndicationAsString());
        status.appendChild(mainIndication);
        sigValNode.appendChild(status);
        String subIndication = signatureValidation.getSignatureValidationStatus().getSubIndicationAsString();
        if (subIndication != null) {
            Element subIndicationNode = doc.createElement("SubIndication");
            subIndicationNode.setTextContent(subIndication);
            status.appendChild(subIndicationNode);
        }
        if (!(messages = signatureValidation.getSignatureValidationStatus().getMessages()).isEmpty()) {
            Element associatedValidationReportData = doc.createElement("AssociatedValidationReportData");
            status.appendChild(associatedValidationReportData);
            Element additionalValidationReportData = doc.createElement("AdditionalValidationReportData");
            associatedValidationReportData.appendChild(additionalValidationReportData);
            for (Pair<String, String> message : messages) {
                Element reportData = doc.createElement("ReportData");
                Element type = doc.createElement("Type");
                type.setTextContent(message.getValue());
                reportData.appendChild(type);
                Element value = doc.createElement("Value");
                value.setAttribute("xsi:type", "xs:string");
                value.setTextContent(message.getKey());
                reportData.appendChild(value);
                additionalValidationReportData.appendChild(reportData);
            }
        }
    }
}

