/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.asn1.IASN1ObjectIdentifier;
import com.itextpdf.commons.bouncycastle.asn1.esf.IOtherHashAlgAndValue;
import com.itextpdf.commons.bouncycastle.asn1.esf.ISigPolicyQualifierInfo;
import com.itextpdf.commons.bouncycastle.asn1.esf.ISignaturePolicyId;
import com.itextpdf.commons.bouncycastle.asn1.esf.ISignaturePolicyIdentifier;
import com.itextpdf.commons.utils.Base64;
import com.itextpdf.kernel.crypto.DigestAlgorithms;

public class SignaturePolicyInfo {
    private static final IBouncyCastleFactory FACTORY = BouncyCastleFactoryCreator.getFactory();
    private final String policyIdentifier;
    private final byte[] policyHash;
    private final String policyDigestAlgorithm;
    private final String policyUri;

    public SignaturePolicyInfo(String policyIdentifier, byte[] policyHash, String policyDigestAlgorithm, String policyUri) {
        if (policyIdentifier == null || policyIdentifier.isEmpty()) {
            throw new IllegalArgumentException("Policy identifier cannot be null");
        }
        if (policyHash == null) {
            throw new IllegalArgumentException("Policy hash cannot be null");
        }
        if (policyDigestAlgorithm == null || policyDigestAlgorithm.isEmpty()) {
            throw new IllegalArgumentException("Policy digest algorithm cannot be null");
        }
        this.policyIdentifier = policyIdentifier;
        this.policyHash = policyHash;
        this.policyDigestAlgorithm = policyDigestAlgorithm;
        this.policyUri = policyUri;
    }

    public SignaturePolicyInfo(String policyIdentifier, String policyHashBase64, String policyDigestAlgorithm, String policyUri) {
        this(policyIdentifier, policyHashBase64 != null ? Base64.decode(policyHashBase64) : null, policyDigestAlgorithm, policyUri);
    }

    public String getPolicyIdentifier() {
        return this.policyIdentifier;
    }

    public byte[] getPolicyHash() {
        return this.policyHash;
    }

    public String getPolicyDigestAlgorithm() {
        return this.policyDigestAlgorithm;
    }

    public String getPolicyUri() {
        return this.policyUri;
    }

    ISignaturePolicyIdentifier toSignaturePolicyIdentifier() {
        String algId = DigestAlgorithms.getAllowedDigest(this.policyDigestAlgorithm);
        if (algId == null || algId.isEmpty()) {
            throw new IllegalArgumentException("Invalid policy hash algorithm");
        }
        ISigPolicyQualifierInfo spqi = null;
        if (this.policyUri != null && !this.policyUri.isEmpty()) {
            spqi = FACTORY.createSigPolicyQualifierInfo(FACTORY.createPKCSObjectIdentifiers().getIdSpqEtsUri(), FACTORY.createDERIA5String(this.policyUri));
        }
        IASN1ObjectIdentifier identifier = FACTORY.createASN1ObjectIdentifierInstance(FACTORY.createASN1ObjectIdentifier(this.policyIdentifier.replace("urn:oid:", "")));
        IOtherHashAlgAndValue otherHashAlgAndValue = FACTORY.createOtherHashAlgAndValue(FACTORY.createAlgorithmIdentifier(FACTORY.createASN1ObjectIdentifier(algId)), FACTORY.createDEROctetString(this.policyHash));
        ISignaturePolicyId signaturePolicyId = FACTORY.createSignaturePolicyId(identifier, otherHashAlgAndValue, spqi);
        return FACTORY.createSignaturePolicyIdentifier(signaturePolicyId);
    }
}

