/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.commons.datastructures.Tuple2;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.util.NumberUtil;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.gradients.AbstractLinearGradientBuilder;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfVersion;
import com.itextpdf.kernel.pdf.action.PdfAction;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfLinkAnnotation;
import com.itextpdf.kernel.pdf.canvas.CanvasArtifact;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.extgstate.PdfExtGState;
import com.itextpdf.kernel.pdf.navigation.PdfStructureDestination;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.kernel.pdf.tagutils.TagStructureContext;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.font.FontCharacteristics;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.font.FontSelector;
import com.itextpdf.layout.font.FontSet;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.PositionedLayoutContext;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.minmaxwidth.MinMaxWidthUtils;
import com.itextpdf.layout.properties.Background;
import com.itextpdf.layout.properties.BackgroundBox;
import com.itextpdf.layout.properties.BackgroundImage;
import com.itextpdf.layout.properties.BaseDirection;
import com.itextpdf.layout.properties.BlendMode;
import com.itextpdf.layout.properties.BorderRadius;
import com.itextpdf.layout.properties.BoxSizingPropertyValue;
import com.itextpdf.layout.properties.HorizontalAlignment;
import com.itextpdf.layout.properties.OverflowPropertyValue;
import com.itextpdf.layout.properties.Property;
import com.itextpdf.layout.properties.Transform;
import com.itextpdf.layout.properties.TransparentColor;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.renderer.AreaBreakRenderer;
import com.itextpdf.layout.renderer.BlockRenderer;
import com.itextpdf.layout.renderer.CanvasRenderer;
import com.itextpdf.layout.renderer.DivRenderer;
import com.itextpdf.layout.renderer.DocumentRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.FloatingHelper;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.ImageRenderer;
import com.itextpdf.layout.renderer.RootRenderer;
import com.itextpdf.layout.renderer.TableRenderer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRenderer
implements IRenderer {
    public static final float OVERLAP_EPSILON = 1.0E-4f;
    protected static final float EPS = 1.0E-4f;
    protected static final float INF = 1000000.0f;
    static final int TOP_SIDE = 0;
    static final int RIGHT_SIDE = 1;
    static final int BOTTOM_SIDE = 2;
    static final int LEFT_SIDE = 3;
    private static final int ARC_RIGHT_DEGREE = 0;
    private static final int ARC_TOP_DEGREE = 90;
    private static final int ARC_LEFT_DEGREE = 180;
    private static final int ARC_BOTTOM_DEGREE = 270;
    private static final int ARC_QUARTER_CLOCKWISE_EXTENT = -90;
    private static final Tuple2<String, PdfDictionary> CHECK_TUPLE2_TYPE = new Tuple2<String, PdfDictionary>("", new PdfDictionary());
    protected List<IRenderer> childRenderers = new ArrayList<IRenderer>();
    protected List<IRenderer> positionedRenderers = new ArrayList<IRenderer>();
    protected IPropertyContainer modelElement;
    protected boolean flushed = false;
    protected LayoutArea occupiedArea;
    protected IRenderer parent;
    protected Map<Integer, Object> properties = new HashMap<Integer, Object>();
    protected boolean isLastRendererForModelElement = true;

    protected AbstractRenderer() {
    }

    protected AbstractRenderer(IElement modelElement) {
        this.modelElement = modelElement;
    }

    protected AbstractRenderer(AbstractRenderer other) {
        this.childRenderers = other.childRenderers;
        this.positionedRenderers = other.positionedRenderers;
        this.modelElement = other.modelElement;
        this.flushed = other.flushed;
        this.occupiedArea = other.occupiedArea != null ? other.occupiedArea.clone() : null;
        this.parent = other.parent;
        this.properties.putAll(other.properties);
        this.isLastRendererForModelElement = other.isLastRendererForModelElement;
    }

    @Override
    public void addChild(IRenderer renderer) {
        Integer positioning = (Integer)renderer.getProperty(52);
        if (positioning == null || positioning == 2 || positioning == 1) {
            this.childRenderers.add(renderer);
        } else if (positioning == 4) {
            AbstractRenderer root = this;
            while (root.parent instanceof AbstractRenderer) {
                root = (AbstractRenderer)root.parent;
            }
            if (root == this) {
                this.positionedRenderers.add(renderer);
            } else {
                root.addChild(renderer);
            }
        } else if (positioning == 3) {
            IRenderer parent;
            AbstractRenderer positionedParent = this;
            boolean noPositionInfo = AbstractRenderer.noAbsolutePositionInfo(renderer);
            while (!positionedParent.isPositioned() && !noPositionInfo && (parent = positionedParent.parent) instanceof AbstractRenderer) {
                positionedParent = (AbstractRenderer)parent;
            }
            if (positionedParent == this) {
                this.positionedRenderers.add(renderer);
            } else {
                positionedParent.addChild(renderer);
            }
        }
        if (renderer instanceof AbstractRenderer && !((AbstractRenderer)renderer).isPositioned() && ((AbstractRenderer)renderer).positionedRenderers.size() > 0) {
            int pos = 0;
            List<IRenderer> childPositionedRenderers = ((AbstractRenderer)renderer).positionedRenderers;
            while (pos < childPositionedRenderers.size()) {
                if (AbstractRenderer.noAbsolutePositionInfo(childPositionedRenderers.get(pos))) {
                    ++pos;
                    continue;
                }
                this.positionedRenderers.add(childPositionedRenderers.get(pos));
                childPositionedRenderers.remove(pos);
            }
        }
    }

    @Override
    public IPropertyContainer getModelElement() {
        return this.modelElement;
    }

    @Override
    public List<IRenderer> getChildRenderers() {
        return this.childRenderers;
    }

    @Override
    public boolean hasProperty(int property) {
        return this.hasOwnProperty(property) || this.modelElement != null && this.modelElement.hasProperty(property) || this.parent != null && Property.isPropertyInherited(property) && this.parent.hasProperty(property);
    }

    @Override
    public boolean hasOwnProperty(int property) {
        return this.properties.containsKey(property);
    }

    public boolean hasOwnOrModelProperty(int property) {
        return AbstractRenderer.hasOwnOrModelProperty(this, property);
    }

    @Override
    public void deleteOwnProperty(int property) {
        this.properties.remove(property);
    }

    public void deleteProperty(int property) {
        if (this.properties.containsKey(property)) {
            this.properties.remove(property);
        } else if (this.modelElement != null) {
            this.modelElement.deleteOwnProperty(property);
        }
    }

    @Override
    public <T1> T1 getProperty(int key) {
        Object property = this.properties.get(key);
        if (property != null || this.properties.containsKey(key)) {
            return (T1)property;
        }
        if (this.modelElement != null && ((property = this.modelElement.getProperty(key)) != null || this.modelElement.hasProperty(key))) {
            return (T1)property;
        }
        if (this.parent != null && Property.isPropertyInherited(key) && (property = this.parent.getProperty(key)) != null) {
            return (T1)property;
        }
        property = this.getDefaultProperty(key);
        if (property != null) {
            return (T1)property;
        }
        return this.modelElement != null ? (T1)this.modelElement.getDefaultProperty(key) : null;
    }

    @Override
    public <T1> T1 getOwnProperty(int property) {
        return (T1)this.properties.get(property);
    }

    @Override
    public <T1> T1 getProperty(int property, T1 defaultValue) {
        T1 result = this.getProperty(property);
        return result != null ? result : defaultValue;
    }

    @Override
    public void setProperty(int property, Object value) {
        this.properties.put(property, value);
    }

    @Override
    public <T1> T1 getDefaultProperty(int property) {
        return null;
    }

    public PdfFont getPropertyAsFont(int property) {
        return (PdfFont)this.getProperty(property);
    }

    public Color getPropertyAsColor(int property) {
        return (Color)this.getProperty(property);
    }

    public TransparentColor getPropertyAsTransparentColor(int property) {
        return (TransparentColor)this.getProperty(property);
    }

    public Float getPropertyAsFloat(int property) {
        return NumberUtil.asFloat(this.getProperty(property));
    }

    public Float getPropertyAsFloat(int property, Float defaultValue) {
        return NumberUtil.asFloat(this.getProperty(property, defaultValue));
    }

    public Boolean getPropertyAsBoolean(int property) {
        return (Boolean)this.getProperty(property);
    }

    public UnitValue getPropertyAsUnitValue(int property) {
        return (UnitValue)this.getProperty(property);
    }

    public Integer getPropertyAsInteger(int property) {
        return NumberUtil.asInteger(this.getProperty(property));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (IRenderer renderer : this.childRenderers) {
            sb.append(renderer.toString());
        }
        return sb.toString();
    }

    @Override
    public LayoutArea getOccupiedArea() {
        return this.occupiedArea;
    }

    @Override
    public void draw(DrawContext drawContext) {
        this.applyDestinationsAndAnnotation(drawContext);
        boolean relativePosition = this.isRelativePosition();
        if (relativePosition) {
            this.applyRelativePositioningTranslation(false);
        }
        this.beginElementOpacityApplying(drawContext);
        this.drawBackground(drawContext);
        this.drawBorder(drawContext);
        this.drawChildren(drawContext);
        this.drawPositionedChildren(drawContext);
        this.endElementOpacityApplying(drawContext);
        if (relativePosition) {
            this.applyRelativePositioningTranslation(true);
        }
        this.flushed = true;
    }

    protected void beginElementOpacityApplying(DrawContext drawContext) {
        Float opacity = this.getPropertyAsFloat(92);
        if (opacity != null && opacity.floatValue() < 1.0f) {
            PdfExtGState extGState = new PdfExtGState();
            extGState.setStrokeOpacity(opacity.floatValue()).setFillOpacity(opacity.floatValue());
            drawContext.getCanvas().saveState().setExtGState(extGState);
        }
    }

    protected void endElementOpacityApplying(DrawContext drawContext) {
        Float opacity = this.getPropertyAsFloat(92);
        if (opacity != null && opacity.floatValue() < 1.0f) {
            drawContext.getCanvas().restoreState();
        }
    }

    public void drawBackground(DrawContext drawContext) {
        Background background = (Background)this.getProperty(6);
        List backgroundImagesList = (List)this.getProperty(90);
        if (background != null || backgroundImagesList != null) {
            Rectangle backgroundArea;
            Rectangle bBox = this.getOccupiedAreaBBox();
            boolean isTagged = drawContext.isTaggingEnabled();
            if (isTagged) {
                drawContext.getCanvas().openTag(new CanvasArtifact());
            }
            if ((backgroundArea = this.getBackgroundArea(this.applyMargins(bBox, false))).getWidth() <= 0.0f || backgroundArea.getHeight() <= 0.0f) {
                Logger logger = LoggerFactory.getLogger(AbstractRenderer.class);
                logger.info(MessageFormatUtil.format("The {0} rectangle has negative or zero sizes. It will not be displayed.", "background"));
            } else {
                boolean backgroundAreaIsClipped = false;
                if (background != null) {
                    Rectangle clippedBackgroundArea = this.applyBackgroundBoxProperty(backgroundArea.clone(), background.getBackgroundClip());
                    backgroundAreaIsClipped = this.clipBackgroundArea(drawContext, clippedBackgroundArea);
                    this.drawColorBackground(background, drawContext, clippedBackgroundArea);
                }
                if (backgroundImagesList != null) {
                    backgroundAreaIsClipped = this.drawBackgroundImagesList(backgroundImagesList, backgroundAreaIsClipped, drawContext, backgroundArea);
                }
                if (backgroundAreaIsClipped) {
                    drawContext.getCanvas().restoreState();
                }
            }
            if (isTagged) {
                drawContext.getCanvas().closeTag();
            }
        }
    }

    private void drawColorBackground(Background background, DrawContext drawContext, Rectangle colorBackgroundArea) {
        TransparentColor backgroundColor = new TransparentColor(background.getColor(), background.getOpacity());
        drawContext.getCanvas().saveState().setFillColor(backgroundColor.getColor());
        backgroundColor.applyFillTransparency(drawContext.getCanvas());
        drawContext.getCanvas().rectangle((double)colorBackgroundArea.getX() - (double)background.getExtraLeft(), (double)colorBackgroundArea.getY() - (double)background.getExtraBottom(), (double)colorBackgroundArea.getWidth() + (double)background.getExtraLeft() + (double)background.getExtraRight(), (double)colorBackgroundArea.getHeight() + (double)background.getExtraTop() + (double)background.getExtraBottom()).fill().restoreState();
    }

    private Rectangle applyBackgroundBoxProperty(Rectangle rectangle, BackgroundBox clip) {
        if (BackgroundBox.PADDING_BOX == clip) {
            this.applyBorderBox(rectangle, false);
        } else if (BackgroundBox.CONTENT_BOX == clip) {
            this.applyBorderBox(rectangle, false);
            this.applyPaddings(rectangle, false);
        }
        return rectangle;
    }

    private boolean drawBackgroundImagesList(List<BackgroundImage> backgroundImagesList, boolean backgroundAreaIsClipped, DrawContext drawContext, Rectangle backgroundArea) {
        for (int i = backgroundImagesList.size() - 1; i >= 0; --i) {
            BackgroundImage backgroundImage = backgroundImagesList.get(i);
            if (backgroundImage == null || !backgroundImage.isBackgroundSpecified()) continue;
            if (!backgroundAreaIsClipped) {
                backgroundAreaIsClipped = this.clipBackgroundArea(drawContext, backgroundArea);
            }
            this.drawBackgroundImage(backgroundImage, drawContext, backgroundArea);
        }
        return backgroundAreaIsClipped;
    }

    private void drawBackgroundImage(BackgroundImage backgroundImage, DrawContext drawContext, Rectangle backgroundArea) {
        Rectangle imageRectangle;
        Rectangle originBackgroundArea = this.applyBackgroundBoxProperty(backgroundArea.clone(), backgroundImage.getBackgroundOrigin());
        float[] imageWidthAndHeight = backgroundImage.calculateBackgroundImageSize(originBackgroundArea.getWidth(), originBackgroundArea.getHeight());
        PdfXObject backgroundXObject = backgroundImage.getImage();
        if (backgroundXObject == null) {
            backgroundXObject = backgroundImage.getForm();
        }
        UnitValue xPosition = UnitValue.createPointValue(0.0f);
        UnitValue yPosition = UnitValue.createPointValue(0.0f);
        if (backgroundXObject == null) {
            AbstractLinearGradientBuilder gradientBuilder = backgroundImage.getLinearGradientBuilder();
            if (gradientBuilder == null) {
                return;
            }
            backgroundImage.getBackgroundPosition().calculatePositionValues(0.0f, 0.0f, xPosition, yPosition);
            backgroundXObject = AbstractRenderer.createXObject(gradientBuilder, originBackgroundArea, drawContext.getDocument());
            imageRectangle = new Rectangle(originBackgroundArea.getLeft() + xPosition.getValue(), originBackgroundArea.getTop() - imageWidthAndHeight[1] - yPosition.getValue(), imageWidthAndHeight[0], imageWidthAndHeight[1]);
        } else {
            backgroundImage.getBackgroundPosition().calculatePositionValues(originBackgroundArea.getWidth() - imageWidthAndHeight[0], originBackgroundArea.getHeight() - imageWidthAndHeight[1], xPosition, yPosition);
            imageRectangle = new Rectangle(originBackgroundArea.getLeft() + xPosition.getValue(), originBackgroundArea.getTop() - imageWidthAndHeight[1] - yPosition.getValue(), imageWidthAndHeight[0], imageWidthAndHeight[1]);
        }
        if (imageRectangle.getWidth() <= 0.0f || imageRectangle.getHeight() <= 0.0f) {
            Logger logger = LoggerFactory.getLogger(AbstractRenderer.class);
            logger.info(MessageFormatUtil.format("The {0} rectangle has negative or zero sizes. It will not be displayed.", "background-image"));
        } else {
            Rectangle clippedBackgroundArea = this.applyBackgroundBoxProperty(backgroundArea.clone(), backgroundImage.getBackgroundClip());
            drawContext.getCanvas().saveState().rectangle(clippedBackgroundArea).clip().endPath();
            AbstractRenderer.drawPdfXObject(imageRectangle, backgroundImage, drawContext, backgroundXObject, backgroundArea, originBackgroundArea);
            drawContext.getCanvas().restoreState();
        }
    }

    private static void drawPdfXObject(Rectangle imageRectangle, BackgroundImage backgroundImage, DrawContext drawContext, PdfXObject backgroundXObject, Rectangle backgroundArea, Rectangle originBackgroundArea) {
        boolean isNextOverlaps;
        boolean isCurrentOverlaps;
        BlendMode blendMode = backgroundImage.getBlendMode();
        if (blendMode != BlendMode.NORMAL) {
            drawContext.getCanvas().setExtGState(new PdfExtGState().setBlendMode(blendMode.getPdfRepresentation()));
        }
        Point whitespace = backgroundImage.getRepeat().prepareRectangleToDrawingAndGetWhitespace(imageRectangle, originBackgroundArea, backgroundImage.getBackgroundSize());
        float initialX = imageRectangle.getX();
        int counterY = 1;
        boolean firstDraw = true;
        do {
            AbstractRenderer.drawPdfXObjectHorizontally(imageRectangle, backgroundImage, drawContext, backgroundXObject, backgroundArea, firstDraw, (float)whitespace.getX());
            firstDraw = false;
            imageRectangle.setX(initialX);
            isCurrentOverlaps = imageRectangle.overlaps(backgroundArea, 1.0E-4f);
            isNextOverlaps = counterY % 2 == 1 ? imageRectangle.moveDown((imageRectangle.getHeight() + (float)whitespace.getY()) * (float)counterY).overlaps(backgroundArea, 1.0E-4f) : imageRectangle.moveUp((imageRectangle.getHeight() + (float)whitespace.getY()) * (float)counterY).overlaps(backgroundArea, 1.0E-4f);
            ++counterY;
        } while (!backgroundImage.getRepeat().isNoRepeatOnYAxis() && (isCurrentOverlaps || isNextOverlaps));
    }

    private static void drawPdfXObjectHorizontally(Rectangle imageRectangle, BackgroundImage backgroundImage, DrawContext drawContext, PdfXObject backgroundXObject, Rectangle backgroundArea, boolean firstDraw, float xWhitespace) {
        boolean isNextOverlaps;
        boolean isCurrentOverlaps;
        boolean isItFirstDraw = firstDraw;
        int counterX = 1;
        do {
            if (imageRectangle.overlaps(backgroundArea, 1.0E-4f) || isItFirstDraw) {
                drawContext.getCanvas().addXObjectFittedIntoRectangle(backgroundXObject, imageRectangle);
                isItFirstDraw = false;
            }
            isCurrentOverlaps = imageRectangle.overlaps(backgroundArea, 1.0E-4f);
            isNextOverlaps = counterX % 2 == 1 ? imageRectangle.moveRight((imageRectangle.getWidth() + xWhitespace) * (float)counterX).overlaps(backgroundArea, 1.0E-4f) : imageRectangle.moveLeft((imageRectangle.getWidth() + xWhitespace) * (float)counterX).overlaps(backgroundArea, 1.0E-4f);
            ++counterX;
        } while (!backgroundImage.getRepeat().isNoRepeatOnXAxis() && (isCurrentOverlaps || isNextOverlaps));
    }

    public static PdfFormXObject createXObject(AbstractLinearGradientBuilder linearGradientBuilder, Rectangle xObjectArea, PdfDocument document) {
        Color gradientColor;
        Rectangle formBBox = new Rectangle(0.0f, 0.0f, xObjectArea.getWidth(), xObjectArea.getHeight());
        PdfFormXObject xObject = new PdfFormXObject(formBBox);
        if (linearGradientBuilder != null && (gradientColor = linearGradientBuilder.buildColor(formBBox, null, document)) != null) {
            new PdfCanvas(xObject, document).setColor(gradientColor, true).rectangle(formBBox).fill();
        }
        return xObject;
    }

    protected Rectangle getBackgroundArea(Rectangle occupiedAreaWithMargins) {
        return occupiedAreaWithMargins;
    }

    protected boolean clipBorderArea(DrawContext drawContext, Rectangle outerBorderBox) {
        return this.clipArea(drawContext, outerBorderBox, true, true, false, true);
    }

    protected boolean clipBackgroundArea(DrawContext drawContext, Rectangle outerBorderBox) {
        return this.clipArea(drawContext, outerBorderBox, true, false, false, false);
    }

    protected boolean clipBackgroundArea(DrawContext drawContext, Rectangle outerBorderBox, boolean considerBordersBeforeClipping) {
        return this.clipArea(drawContext, outerBorderBox, true, false, considerBordersBeforeClipping, false);
    }

    private boolean clipArea(DrawContext drawContext, Rectangle outerBorderBox, boolean clipOuter, boolean clipInner, boolean considerBordersBeforeOuterClipping, boolean considerBordersBeforeInnerClipping) {
        assert (!considerBordersBeforeOuterClipping || !considerBordersBeforeInnerClipping);
        float[] borderWidths = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        float[] outerBox = new float[]{outerBorderBox.getTop(), outerBorderBox.getRight(), outerBorderBox.getBottom(), outerBorderBox.getLeft()};
        boolean hasNotNullRadius = false;
        BorderRadius[] borderRadii = this.getBorderRadii();
        float[] verticalRadii = this.calculateRadii(borderRadii, outerBorderBox, false);
        float[] horizontalRadii = this.calculateRadii(borderRadii, outerBorderBox, true);
        for (int i = 0; i < 4; ++i) {
            verticalRadii[i] = Math.min(verticalRadii[i], outerBorderBox.getHeight() / 2.0f);
            horizontalRadii[i] = Math.min(horizontalRadii[i], outerBorderBox.getWidth() / 2.0f);
            if (hasNotNullRadius || 0.0f == verticalRadii[i] && 0.0f == horizontalRadii[i]) continue;
            hasNotNullRadius = true;
        }
        if (hasNotNullRadius) {
            float[] cornersX = new float[]{outerBox[3] + horizontalRadii[0], outerBox[1] - horizontalRadii[1], outerBox[1] - horizontalRadii[2], outerBox[3] + horizontalRadii[3]};
            float[] cornersY = new float[]{outerBox[0] - verticalRadii[0], outerBox[0] - verticalRadii[1], outerBox[2] + verticalRadii[2], outerBox[2] + verticalRadii[3]};
            PdfCanvas canvas = drawContext.getCanvas();
            canvas.saveState();
            if (considerBordersBeforeOuterClipping) {
                borderWidths = this.decreaseBorderRadiiWithBorders(horizontalRadii, verticalRadii, outerBox, cornersX, cornersY);
            }
            if (clipOuter) {
                this.clipOuterArea(canvas, horizontalRadii, verticalRadii, outerBox, cornersX, cornersY);
            }
            if (considerBordersBeforeInnerClipping) {
                borderWidths = this.decreaseBorderRadiiWithBorders(horizontalRadii, verticalRadii, outerBox, cornersX, cornersY);
            }
            if (clipInner) {
                this.clipInnerArea(canvas, horizontalRadii, verticalRadii, outerBox, cornersX, cornersY, borderWidths);
            }
        }
        return hasNotNullRadius;
    }

    private void clipOuterArea(PdfCanvas canvas, float[] horizontalRadii, float[] verticalRadii, float[] outerBox, float[] cornersX, float[] cornersY) {
        double top = outerBox[0];
        double right = outerBox[1];
        double bottom = outerBox[2];
        double left = outerBox[3];
        if (0.0f != horizontalRadii[0] || 0.0f != verticalRadii[0]) {
            double arcBottom = (double)cornersY[0] - (double)verticalRadii[0];
            double arcRight = (double)cornersX[0] + (double)horizontalRadii[0];
            canvas.moveTo(left, bottom).arcContinuous(left, arcBottom, arcRight, top, 180.0, -90.0).lineTo(right, top).lineTo(right, bottom).lineTo(left, bottom);
            canvas.clip().endPath();
        }
        if (0.0f != horizontalRadii[1] || 0.0f != verticalRadii[1]) {
            double arcLeft = (double)cornersX[1] - (double)horizontalRadii[1];
            double arcBottom = (double)cornersY[1] - (double)verticalRadii[1];
            canvas.moveTo(left, top).arcContinuous(arcLeft, top, right, arcBottom, 90.0, -90.0).lineTo(right, bottom).lineTo(left, bottom).lineTo(left, top);
            canvas.clip().endPath();
        }
        if (0.0f != horizontalRadii[2] || 0.0f != verticalRadii[2]) {
            double arcTop = (double)cornersY[2] + (double)verticalRadii[2];
            double arcLeft = (double)cornersX[2] - (double)horizontalRadii[2];
            canvas.moveTo(right, top).arcContinuous(right, arcTop, arcLeft, bottom, 0.0, -90.0).lineTo(left, bottom).lineTo(left, top).lineTo(right, top);
            canvas.clip().endPath();
        }
        if (0.0f != horizontalRadii[3] || 0.0f != verticalRadii[3]) {
            double arcRight = (double)cornersX[3] + (double)horizontalRadii[3];
            double arcTop = (double)cornersY[3] + (double)verticalRadii[3];
            canvas.moveTo(right, bottom).arcContinuous(arcRight, bottom, left, arcTop, 270.0, -90.0).lineTo(left, top).lineTo(right, top).lineTo(right, bottom);
            canvas.clip().endPath();
        }
    }

    private void clipInnerArea(PdfCanvas canvas, float[] horizontalRadii, float[] verticalRadii, float[] outerBox, float[] cornersX, float[] cornersY, float[] borderWidths) {
        double top = outerBox[0];
        double right = outerBox[1];
        double bottom = outerBox[2];
        double left = outerBox[3];
        double x1 = cornersX[0];
        double y1 = cornersY[0];
        double x2 = cornersX[1];
        double y2 = cornersY[1];
        double x3 = cornersX[2];
        double y3 = cornersY[2];
        double x4 = cornersX[3];
        double y4 = cornersY[3];
        double topBorderWidth = borderWidths[0];
        double rightBorderWidth = borderWidths[1];
        double bottomBorderWidth = borderWidths[2];
        double leftBorderWidth = borderWidths[3];
        if (0.0f != horizontalRadii[0] || 0.0f != verticalRadii[0]) {
            canvas.arc(left, y1 - (double)verticalRadii[0], x1 + (double)horizontalRadii[0], top, 180.0, -90.0).lineTo(x2, top).lineTo(right, y2).lineTo(right, y3).lineTo(x3, bottom).lineTo(x4, bottom).lineTo(left, y4).lineTo(left, y1).lineTo(left - leftBorderWidth, y1).lineTo(left - leftBorderWidth, bottom - bottomBorderWidth).lineTo(right + rightBorderWidth, bottom - bottomBorderWidth).lineTo(right + rightBorderWidth, top + topBorderWidth).lineTo(left - leftBorderWidth, top + topBorderWidth).lineTo(left - leftBorderWidth, y1);
            canvas.clip().endPath();
        }
        if (0.0f != horizontalRadii[1] || 0.0f != verticalRadii[1]) {
            canvas.arc(x2 - (double)horizontalRadii[1], top, right, y2 - (double)verticalRadii[1], 90.0, -90.0).lineTo(right, y3).lineTo(x3, bottom).lineTo(x4, bottom).lineTo(left, y4).lineTo(left, y1).lineTo(x1, top).lineTo(x2, top).lineTo(x2, top + topBorderWidth).lineTo(left - leftBorderWidth, top + topBorderWidth).lineTo(left - leftBorderWidth, bottom - bottomBorderWidth).lineTo(right + rightBorderWidth, bottom - bottomBorderWidth).lineTo(right + rightBorderWidth, top + topBorderWidth).lineTo(x2, top + topBorderWidth);
            canvas.clip().endPath();
        }
        if (0.0f != horizontalRadii[2] || 0.0f != verticalRadii[2]) {
            canvas.arc(right, y3 + (double)verticalRadii[2], x3 - (double)horizontalRadii[2], bottom, 0.0, -90.0).lineTo(x4, bottom).lineTo(left, y4).lineTo(left, y1).lineTo(x1, top).lineTo(x2, top).lineTo(right, y2).lineTo(right, y3).lineTo(right + rightBorderWidth, y3).lineTo(right + rightBorderWidth, top + topBorderWidth).lineTo(left - leftBorderWidth, top + topBorderWidth).lineTo(left - leftBorderWidth, bottom - bottomBorderWidth).lineTo(right + rightBorderWidth, bottom - bottomBorderWidth).lineTo(right + rightBorderWidth, y3);
            canvas.clip().endPath();
        }
        if (0.0f != horizontalRadii[3] || 0.0f != verticalRadii[3]) {
            canvas.arc(x4 + (double)horizontalRadii[3], bottom, left, y4 + (double)verticalRadii[3], 270.0, -90.0).lineTo(left, y1).lineTo(x1, top).lineTo(x2, top).lineTo(right, y2).lineTo(right, y3).lineTo(x3, bottom).lineTo(x4, bottom).lineTo(x4, bottom - bottomBorderWidth).lineTo(right + rightBorderWidth, bottom - bottomBorderWidth).lineTo(right + rightBorderWidth, top + topBorderWidth).lineTo(left - leftBorderWidth, top + topBorderWidth).lineTo(left - leftBorderWidth, bottom - bottomBorderWidth).lineTo(x4, bottom - bottomBorderWidth);
            canvas.clip().endPath();
        }
    }

    private float[] decreaseBorderRadiiWithBorders(float[] horizontalRadii, float[] verticalRadii, float[] outerBox, float[] cornersX, float[] cornersY) {
        Border[] borders = this.getBorders();
        float[] borderWidths = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        if (borders[0] != null) {
            borderWidths[0] = borders[0].getWidth();
            outerBox[0] = outerBox[0] - borders[0].getWidth();
            if (cornersY[1] > outerBox[0]) {
                cornersY[1] = outerBox[0];
            }
            if (cornersY[0] > outerBox[0]) {
                cornersY[0] = outerBox[0];
            }
            verticalRadii[0] = Math.max(0.0f, verticalRadii[0] - borders[0].getWidth());
            verticalRadii[1] = Math.max(0.0f, verticalRadii[1] - borders[0].getWidth());
        }
        if (borders[1] != null) {
            borderWidths[1] = borders[1].getWidth();
            outerBox[1] = outerBox[1] - borders[1].getWidth();
            if (cornersX[1] > outerBox[1]) {
                cornersX[1] = outerBox[1];
            }
            if (cornersX[2] > outerBox[1]) {
                cornersX[2] = outerBox[1];
            }
            horizontalRadii[1] = Math.max(0.0f, horizontalRadii[1] - borders[1].getWidth());
            horizontalRadii[2] = Math.max(0.0f, horizontalRadii[2] - borders[1].getWidth());
        }
        if (borders[2] != null) {
            borderWidths[2] = borders[2].getWidth();
            outerBox[2] = outerBox[2] + borders[2].getWidth();
            if (cornersY[2] < outerBox[2]) {
                cornersY[2] = outerBox[2];
            }
            if (cornersY[3] < outerBox[2]) {
                cornersY[3] = outerBox[2];
            }
            verticalRadii[2] = Math.max(0.0f, verticalRadii[2] - borders[2].getWidth());
            verticalRadii[3] = Math.max(0.0f, verticalRadii[3] - borders[2].getWidth());
        }
        if (borders[3] != null) {
            borderWidths[3] = borders[3].getWidth();
            outerBox[3] = outerBox[3] + borders[3].getWidth();
            if (cornersX[3] < outerBox[3]) {
                cornersX[3] = outerBox[3];
            }
            if (cornersX[0] < outerBox[3]) {
                cornersX[0] = outerBox[3];
            }
            horizontalRadii[3] = Math.max(0.0f, horizontalRadii[3] - borders[3].getWidth());
            horizontalRadii[0] = Math.max(0.0f, horizontalRadii[0] - borders[3].getWidth());
        }
        return borderWidths;
    }

    public void drawChildren(DrawContext drawContext) {
        ArrayList<IRenderer> waitingRenderers = new ArrayList<IRenderer>();
        for (IRenderer child : this.childRenderers) {
            Transform transformProp = (Transform)child.getProperty(53);
            RootRenderer rootRenderer = this.getRootRenderer();
            ArrayList<IRenderer> waiting = rootRenderer != null && !rootRenderer.waitingDrawingElements.contains(child) ? rootRenderer.waitingDrawingElements : waitingRenderers;
            AbstractRenderer.processWaitingDrawing(child, transformProp, waiting);
            if (FloatingHelper.isRendererFloating(child) || transformProp != null) continue;
            child.draw(drawContext);
        }
        for (IRenderer waitingRenderer : waitingRenderers) {
            waitingRenderer.draw(drawContext);
        }
    }

    public void drawBorder(DrawContext drawContext) {
        Border[] borders = this.getBorders();
        boolean gotBorders = false;
        for (Border border : borders) {
            gotBorders = gotBorders || border != null;
        }
        if (gotBorders) {
            float topWidth = borders[0] != null ? borders[0].getWidth() : 0.0f;
            float rightWidth = borders[1] != null ? borders[1].getWidth() : 0.0f;
            float bottomWidth = borders[2] != null ? borders[2].getWidth() : 0.0f;
            float leftWidth = borders[3] != null ? borders[3].getWidth() : 0.0f;
            Rectangle bBox = this.getBorderAreaBBox();
            if (bBox.getWidth() < 0.0f || bBox.getHeight() < 0.0f) {
                Logger logger = LoggerFactory.getLogger(AbstractRenderer.class);
                logger.error(MessageFormatUtil.format("The {0} rectangle has negative size. It will not be displayed.", "border"));
                return;
            }
            float x1 = bBox.getX();
            float y1 = bBox.getY();
            float x2 = bBox.getX() + bBox.getWidth();
            float y2 = bBox.getY() + bBox.getHeight();
            boolean isTagged = drawContext.isTaggingEnabled();
            PdfCanvas canvas = drawContext.getCanvas();
            if (isTagged) {
                canvas.openTag(new CanvasArtifact());
            }
            Rectangle borderRect = this.applyMargins(this.occupiedArea.getBBox().clone(), this.getMargins(), false);
            boolean isAreaClipped = this.clipBorderArea(drawContext, borderRect);
            BorderRadius[] borderRadii = this.getBorderRadii();
            float[] verticalRadii = this.calculateRadii(borderRadii, borderRect, false);
            float[] horizontalRadii = this.calculateRadii(borderRadii, borderRect, true);
            for (int i = 0; i < 4; ++i) {
                verticalRadii[i] = Math.min(verticalRadii[i], borderRect.getHeight() / 2.0f);
                horizontalRadii[i] = Math.min(horizontalRadii[i], borderRect.getWidth() / 2.0f);
            }
            if (borders[0] != null) {
                if (0.0f != horizontalRadii[0] || 0.0f != verticalRadii[0] || 0.0f != horizontalRadii[1] || 0.0f != verticalRadii[1]) {
                    borders[0].draw(canvas, x1, y2, x2, y2, horizontalRadii[0], verticalRadii[0], horizontalRadii[1], verticalRadii[1], Border.Side.TOP, leftWidth, rightWidth);
                } else {
                    borders[0].draw(canvas, x1, y2, x2, y2, Border.Side.TOP, leftWidth, rightWidth);
                }
            }
            if (borders[1] != null) {
                if (0.0f != horizontalRadii[1] || 0.0f != verticalRadii[1] || 0.0f != horizontalRadii[2] || 0.0f != verticalRadii[2]) {
                    borders[1].draw(canvas, x2, y2, x2, y1, horizontalRadii[1], verticalRadii[1], horizontalRadii[2], verticalRadii[2], Border.Side.RIGHT, topWidth, bottomWidth);
                } else {
                    borders[1].draw(canvas, x2, y2, x2, y1, Border.Side.RIGHT, topWidth, bottomWidth);
                }
            }
            if (borders[2] != null) {
                if (0.0f != horizontalRadii[2] || 0.0f != verticalRadii[2] || 0.0f != horizontalRadii[3] || 0.0f != verticalRadii[3]) {
                    borders[2].draw(canvas, x2, y1, x1, y1, horizontalRadii[2], verticalRadii[2], horizontalRadii[3], verticalRadii[3], Border.Side.BOTTOM, rightWidth, leftWidth);
                } else {
                    borders[2].draw(canvas, x2, y1, x1, y1, Border.Side.BOTTOM, rightWidth, leftWidth);
                }
            }
            if (borders[3] != null) {
                if (0.0f != horizontalRadii[3] || 0.0f != verticalRadii[3] || 0.0f != horizontalRadii[0] || 0.0f != verticalRadii[0]) {
                    borders[3].draw(canvas, x1, y1, x1, y2, horizontalRadii[3], verticalRadii[3], horizontalRadii[0], verticalRadii[0], Border.Side.LEFT, bottomWidth, topWidth);
                } else {
                    borders[3].draw(canvas, x1, y1, x1, y2, Border.Side.LEFT, bottomWidth, topWidth);
                }
            }
            if (isAreaClipped) {
                drawContext.getCanvas().restoreState();
            }
            if (isTagged) {
                canvas.closeTag();
            }
        }
    }

    @Override
    public boolean isFlushed() {
        return this.flushed;
    }

    @Override
    public IRenderer setParent(IRenderer parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public IRenderer getParent() {
        return this.parent;
    }

    @Override
    public void move(float dxRight, float dyUp) {
        Logger logger = LoggerFactory.getLogger(AbstractRenderer.class);
        if (this.occupiedArea == null) {
            logger.error(MessageFormatUtil.format("Occupied area has not been initialized. {0}", "Moving won't be performed."));
            return;
        }
        this.occupiedArea.getBBox().moveRight(dxRight);
        this.occupiedArea.getBBox().moveUp(dyUp);
        for (IRenderer childRenderer : this.childRenderers) {
            childRenderer.move(dxRight, dyUp);
        }
        for (IRenderer childRenderer : this.positionedRenderers) {
            childRenderer.move(dxRight, dyUp);
        }
    }

    public List<Rectangle> initElementAreas(LayoutArea area) {
        return Collections.singletonList(area.getBBox());
    }

    public Rectangle getOccupiedAreaBBox() {
        return this.occupiedArea.getBBox().clone();
    }

    public Rectangle getBorderAreaBBox() {
        Rectangle rect = this.getOccupiedAreaBBox();
        this.applyMargins(rect, false);
        this.applyBorderBox(rect, false);
        return rect;
    }

    public Rectangle getInnerAreaBBox() {
        Rectangle rect = this.getOccupiedAreaBBox();
        this.applyMargins(rect, false);
        this.applyBorderBox(rect, false);
        this.applyPaddings(rect, false);
        return rect;
    }

    Rectangle applyMarginsBordersPaddings(Rectangle rect, boolean reverse) {
        this.applyMargins(rect, reverse);
        this.applyBorderBox(rect, reverse);
        this.applyPaddings(rect, reverse);
        return rect;
    }

    public Rectangle applyMargins(Rectangle rect, boolean reverse) {
        return this.applyMargins(rect, this.getMargins(), reverse);
    }

    public Rectangle applyBorderBox(Rectangle rect, boolean reverse) {
        Border[] borders = this.getBorders();
        return this.applyBorderBox(rect, borders, reverse);
    }

    public Rectangle applyPaddings(Rectangle rect, boolean reverse) {
        return this.applyPaddings(rect, this.getPaddings(), reverse);
    }

    public boolean isFirstOnRootArea() {
        return this.isFirstOnRootArea(false);
    }

    protected void applyDestinationsAndAnnotation(DrawContext drawContext) {
        this.applyDestination(drawContext.getDocument());
        this.applyAction(drawContext.getDocument());
        this.applyLinkAnnotation(drawContext.getDocument());
    }

    protected static boolean isBorderBoxSizing(IRenderer renderer) {
        BoxSizingPropertyValue boxSizing = (BoxSizingPropertyValue)((Object)renderer.getProperty(105));
        return boxSizing != null && boxSizing.equals((Object)BoxSizingPropertyValue.BORDER_BOX);
    }

    protected boolean isOverflowProperty(OverflowPropertyValue equalsTo, int overflowProperty) {
        return AbstractRenderer.isOverflowProperty(equalsTo, (OverflowPropertyValue)((Object)this.getProperty(overflowProperty)));
    }

    protected static boolean isOverflowProperty(OverflowPropertyValue equalsTo, IRenderer renderer, int overflowProperty) {
        return AbstractRenderer.isOverflowProperty(equalsTo, (OverflowPropertyValue)((Object)renderer.getProperty(overflowProperty)));
    }

    protected static boolean isOverflowProperty(OverflowPropertyValue equalsTo, OverflowPropertyValue rendererOverflowProperty) {
        return equalsTo.equals((Object)rendererOverflowProperty) || equalsTo.equals((Object)OverflowPropertyValue.FIT) && rendererOverflowProperty == null;
    }

    protected static boolean isOverflowFit(OverflowPropertyValue rendererOverflowProperty) {
        return rendererOverflowProperty == null || OverflowPropertyValue.FIT.equals((Object)rendererOverflowProperty);
    }

    <T> T replaceOwnProperty(int property, T replacementValue) {
        Object ownProperty = this.getOwnProperty(property);
        this.setProperty(property, replacementValue);
        return (T)ownProperty;
    }

    <T> void returnBackOwnProperty(int property, T prevValue) {
        if (prevValue == null) {
            this.deleteOwnProperty(property);
        } else {
            this.setProperty(property, prevValue);
        }
    }

    boolean hasAspectRatio() {
        return false;
    }

    Float getAspectRatio() {
        return null;
    }

    static void processWaitingDrawing(IRenderer child, Transform transformProp, List<IRenderer> waitingDrawing) {
        Border outlineProp;
        if (FloatingHelper.isRendererFloating(child) || transformProp != null) {
            waitingDrawing.add(child);
        }
        if ((outlineProp = (Border)child.getProperty(106)) != null && child instanceof AbstractRenderer) {
            AbstractRenderer abstractChild = (AbstractRenderer)child;
            if (abstractChild.isRelativePosition()) {
                abstractChild.applyRelativePositioningTranslation(false);
            }
            Div outlines = (Div)new Div().setNeutralRole();
            if (transformProp != null) {
                outlines.setProperty(53, transformProp);
            }
            outlines.setBorder(outlineProp);
            float offset = outlineProp.getWidth();
            if (abstractChild.getPropertyAsFloat(107) != null) {
                offset += abstractChild.getPropertyAsFloat(107).floatValue();
            }
            DivRenderer div = new DivRenderer(outlines);
            div.setParent(abstractChild.getParent());
            Rectangle divOccupiedArea = abstractChild.applyMargins(abstractChild.occupiedArea.clone().getBBox(), false).moveLeft(offset).moveDown(offset);
            divOccupiedArea.setWidth(divOccupiedArea.getWidth() + 2.0f * offset).setHeight(divOccupiedArea.getHeight() + 2.0f * offset);
            div.occupiedArea = new LayoutArea(abstractChild.getOccupiedArea().getPageNumber(), divOccupiedArea);
            float outlineWidthTop = ((Border)div.getProperty(13)).getWidth();
            float outlineWidthBottom = ((Border)div.getProperty(10)).getWidth();
            float outlineWidthLeft = ((Border)div.getProperty(11)).getWidth();
            float outlineWidthRight = ((Border)div.getProperty(12)).getWidth();
            if (divOccupiedArea.getWidth() >= outlineWidthLeft + outlineWidthRight && divOccupiedArea.getHeight() >= outlineWidthTop + outlineWidthBottom) {
                waitingDrawing.add(div);
            }
            if (abstractChild.isRelativePosition()) {
                abstractChild.applyRelativePositioningTranslation(true);
            }
        }
    }

    protected Float retrieveWidth(float parentBoxWidth) {
        Float width;
        Float minWidth = this.retrieveUnitValue(parentBoxWidth, 80);
        Float maxWidth = this.retrieveUnitValue(parentBoxWidth, 79);
        if (maxWidth != null && minWidth != null && minWidth.floatValue() > maxWidth.floatValue()) {
            maxWidth = minWidth;
        }
        if ((width = this.retrieveUnitValue(parentBoxWidth, 77)) != null) {
            if (maxWidth != null) {
                Float f = width = width.floatValue() > maxWidth.floatValue() ? maxWidth : width;
            }
            if (minWidth != null) {
                width = width.floatValue() < minWidth.floatValue() ? minWidth : width;
            }
        } else if (maxWidth != null) {
            Float f = width = maxWidth.floatValue() < parentBoxWidth ? maxWidth : null;
        }
        if (width != null && AbstractRenderer.isBorderBoxSizing(this)) {
            width = Float.valueOf(width.floatValue() - AbstractRenderer.calculatePaddingBorderWidth(this));
        }
        return width != null ? Float.valueOf(Math.max(0.0f, width.floatValue())) : null;
    }

    protected Float retrieveMaxWidth(float parentBoxWidth) {
        Float maxWidth = this.retrieveUnitValue(parentBoxWidth, 79);
        if (maxWidth != null) {
            Float minWidth = this.retrieveUnitValue(parentBoxWidth, 80);
            if (minWidth != null && minWidth.floatValue() > maxWidth.floatValue()) {
                maxWidth = minWidth;
            }
            if (AbstractRenderer.isBorderBoxSizing(this)) {
                maxWidth = Float.valueOf(maxWidth.floatValue() - AbstractRenderer.calculatePaddingBorderWidth(this));
            }
            return Float.valueOf(maxWidth.floatValue() > 0.0f ? maxWidth.floatValue() : 0.0f);
        }
        return null;
    }

    protected Float retrieveMinWidth(float parentBoxWidth) {
        Float minWidth = this.retrieveUnitValue(parentBoxWidth, 80);
        if (minWidth != null) {
            if (AbstractRenderer.isBorderBoxSizing(this)) {
                minWidth = Float.valueOf(minWidth.floatValue() - AbstractRenderer.calculatePaddingBorderWidth(this));
            }
            return Float.valueOf(minWidth.floatValue() > 0.0f ? minWidth.floatValue() : 0.0f);
        }
        return null;
    }

    protected void updateWidth(UnitValue updatedWidthValue) {
        if (updatedWidthValue.isPointValue() && AbstractRenderer.isBorderBoxSizing(this)) {
            updatedWidthValue.setValue(updatedWidthValue.getValue() + AbstractRenderer.calculatePaddingBorderWidth(this));
        }
        this.setProperty(77, updatedWidthValue);
    }

    protected Float retrieveHeight() {
        Float height = null;
        UnitValue heightUV = this.getPropertyAsUnitValue(27);
        Float parentResolvedHeight = this.retrieveResolvedParentDeclaredHeight();
        Float minHeight = null;
        Float maxHeight = null;
        if (heightUV != null) {
            if (parentResolvedHeight == null) {
                if (heightUV.isPercentValue()) {
                    height = null;
                } else {
                    UnitValue maxHeightUV;
                    UnitValue minHeightUV = this.getPropertyAsUnitValue(85);
                    if (minHeightUV != null && minHeightUV.isPointValue()) {
                        minHeight = Float.valueOf(minHeightUV.getValue());
                    }
                    if ((maxHeightUV = this.getPropertyAsUnitValue(84)) != null && maxHeightUV.isPointValue()) {
                        maxHeight = Float.valueOf(maxHeightUV.getValue());
                    }
                    height = Float.valueOf(heightUV.getValue());
                }
            } else {
                minHeight = this.retrieveUnitValue(parentResolvedHeight.floatValue(), 85);
                maxHeight = this.retrieveUnitValue(parentResolvedHeight.floatValue(), 84);
                height = this.retrieveUnitValue(parentResolvedHeight.floatValue(), 27);
            }
            if (maxHeight != null && minHeight != null && minHeight.floatValue() > maxHeight.floatValue()) {
                maxHeight = minHeight;
            }
            if (height != null) {
                if (maxHeight != null) {
                    Float f = height = height.floatValue() > maxHeight.floatValue() ? maxHeight : height;
                }
                if (minHeight != null) {
                    Float f = height = height.floatValue() < minHeight.floatValue() ? minHeight : height;
                }
            }
            if (height != null && AbstractRenderer.isBorderBoxSizing(this)) {
                height = Float.valueOf(height.floatValue() - AbstractRenderer.calculatePaddingBorderHeight(this));
            }
        }
        return height != null ? Float.valueOf(Math.max(0.0f, height.floatValue())) : null;
    }

    private float[] calculateRadii(BorderRadius[] radii, Rectangle area, boolean horizontal) {
        float[] results = new float[4];
        for (int i = 0; i < 4; ++i) {
            if (null != radii[i]) {
                UnitValue value;
                UnitValue unitValue = value = horizontal ? radii[i].getHorizontalRadius() : radii[i].getVerticalRadius();
                if (value != null) {
                    if (value.getUnitType() == 2) {
                        results[i] = value.getValue() * (horizontal ? area.getWidth() : area.getHeight()) / 100.0f;
                        continue;
                    }
                    assert (value.getUnitType() == 1);
                    results[i] = value.getValue();
                    continue;
                }
                results[i] = 0.0f;
                continue;
            }
            results[i] = 0.0f;
        }
        return results;
    }

    protected void updateHeight(UnitValue updatedHeight) {
        if (AbstractRenderer.isBorderBoxSizing(this) && updatedHeight.isPointValue()) {
            updatedHeight.setValue(updatedHeight.getValue() + AbstractRenderer.calculatePaddingBorderHeight(this));
        }
        this.setProperty(27, updatedHeight);
    }

    protected Float retrieveMaxHeight() {
        Float maxHeight = null;
        Float minHeight = null;
        Float directParentDeclaredHeight = this.retrieveDirectParentDeclaredHeight();
        UnitValue maxHeightAsUV = this.getPropertyAsUnitValue(84);
        if (maxHeightAsUV != null) {
            if (directParentDeclaredHeight == null) {
                if (maxHeightAsUV.isPercentValue()) {
                    maxHeight = null;
                } else {
                    minHeight = this.retrieveMinHeight();
                    UnitValue minHeightUV = this.getPropertyAsUnitValue(85);
                    if (minHeightUV != null && minHeightUV.isPointValue()) {
                        minHeight = Float.valueOf(minHeightUV.getValue());
                    }
                    maxHeight = Float.valueOf(maxHeightAsUV.getValue());
                }
            } else {
                maxHeight = this.retrieveUnitValue(directParentDeclaredHeight.floatValue(), 84);
            }
            if (maxHeight != null) {
                if (minHeight != null && minHeight.floatValue() > maxHeight.floatValue()) {
                    maxHeight = minHeight;
                }
                if (AbstractRenderer.isBorderBoxSizing(this)) {
                    maxHeight = Float.valueOf(maxHeight.floatValue() - AbstractRenderer.calculatePaddingBorderHeight(this));
                }
                return Float.valueOf(maxHeight.floatValue() > 0.0f ? maxHeight.floatValue() : 0.0f);
            }
        }
        return this.retrieveHeight();
    }

    protected void updateMaxHeight(UnitValue updatedMaxHeight) {
        if (AbstractRenderer.isBorderBoxSizing(this) && updatedMaxHeight.isPointValue()) {
            updatedMaxHeight.setValue(updatedMaxHeight.getValue() + AbstractRenderer.calculatePaddingBorderHeight(this));
        }
        this.setProperty(84, updatedMaxHeight);
    }

    protected Float retrieveMinHeight() {
        Float minHeight = null;
        Float directParentDeclaredHeight = this.retrieveDirectParentDeclaredHeight();
        UnitValue minHeightUV = AbstractRenderer.getPropertyAsUnitValue(this, 85);
        if (minHeightUV != null) {
            minHeight = directParentDeclaredHeight == null ? (minHeightUV.isPercentValue() ? null : Float.valueOf(minHeightUV.getValue())) : this.retrieveUnitValue(directParentDeclaredHeight.floatValue(), 85);
            if (minHeight != null) {
                if (AbstractRenderer.isBorderBoxSizing(this)) {
                    minHeight = Float.valueOf(minHeight.floatValue() - AbstractRenderer.calculatePaddingBorderHeight(this));
                }
                return Float.valueOf(minHeight.floatValue() > 0.0f ? minHeight.floatValue() : 0.0f);
            }
        }
        return this.retrieveHeight();
    }

    protected void updateMinHeight(UnitValue updatedMinHeight) {
        if (AbstractRenderer.isBorderBoxSizing(this) && updatedMinHeight.isPointValue()) {
            updatedMinHeight.setValue(updatedMinHeight.getValue() + AbstractRenderer.calculatePaddingBorderHeight(this));
        }
        this.setProperty(85, updatedMinHeight);
    }

    protected Float retrieveUnitValue(float baseValue, int property) {
        return this.retrieveUnitValue(baseValue, property, false);
    }

    protected Float retrieveUnitValue(float baseValue, int property, boolean pointOnly) {
        UnitValue value = (UnitValue)this.getProperty(property);
        if (pointOnly && value.getUnitType() == 1) {
            Logger logger = LoggerFactory.getLogger(AbstractRenderer.class);
            logger.error(MessageFormatUtil.format("Property {0} in percents is not supported", property));
        }
        if (value != null) {
            if (value.getUnitType() == 2) {
                return Float.valueOf(value.getValue() != 100.0f ? baseValue * value.getValue() / 100.0f : baseValue);
            }
            assert (value.getUnitType() == 1);
            return Float.valueOf(value.getValue());
        }
        return null;
    }

    protected Map<Integer, Object> getOwnProperties() {
        return this.properties;
    }

    protected void addAllProperties(Map<Integer, Object> properties) {
        this.properties.putAll(properties);
    }

    protected Float getFirstYLineRecursively() {
        if (this.childRenderers.size() == 0) {
            return null;
        }
        return ((AbstractRenderer)this.childRenderers.get(0)).getFirstYLineRecursively();
    }

    protected Float getLastYLineRecursively() {
        if (!this.allowLastYLineRecursiveExtraction()) {
            return null;
        }
        for (int i = this.childRenderers.size() - 1; i >= 0; --i) {
            Float lastYLine;
            IRenderer child = this.childRenderers.get(i);
            if (!(child instanceof AbstractRenderer) || (lastYLine = ((AbstractRenderer)child).getLastYLineRecursively()) == null) continue;
            return lastYLine;
        }
        return null;
    }

    protected boolean allowLastYLineRecursiveExtraction() {
        return !this.isOverflowProperty(OverflowPropertyValue.HIDDEN, 103) && !this.isOverflowProperty(OverflowPropertyValue.HIDDEN, 104);
    }

    protected Rectangle applyMargins(Rectangle rect, UnitValue[] margins, boolean reverse) {
        Logger logger;
        if (!margins[0].isPointValue()) {
            logger = LoggerFactory.getLogger(AbstractRenderer.class);
            logger.error(MessageFormatUtil.format("Property {0} in percents is not supported", 46));
        }
        if (!margins[1].isPointValue()) {
            logger = LoggerFactory.getLogger(AbstractRenderer.class);
            logger.error(MessageFormatUtil.format("Property {0} in percents is not supported", 45));
        }
        if (!margins[2].isPointValue()) {
            logger = LoggerFactory.getLogger(AbstractRenderer.class);
            logger.error(MessageFormatUtil.format("Property {0} in percents is not supported", 43));
        }
        if (!margins[3].isPointValue()) {
            logger = LoggerFactory.getLogger(AbstractRenderer.class);
            logger.error(MessageFormatUtil.format("Property {0} in percents is not supported", 44));
        }
        return rect.applyMargins(margins[0].getValue(), margins[1].getValue(), margins[2].getValue(), margins[3].getValue(), reverse);
    }

    protected UnitValue[] getMargins() {
        return AbstractRenderer.getMargins(this);
    }

    protected UnitValue[] getPaddings() {
        return AbstractRenderer.getPaddings(this);
    }

    protected Rectangle applyPaddings(Rectangle rect, UnitValue[] paddings, boolean reverse) {
        Logger logger;
        if (paddings[0] != null && !paddings[0].isPointValue()) {
            logger = LoggerFactory.getLogger(AbstractRenderer.class);
            logger.error(MessageFormatUtil.format("Property {0} in percents is not supported", 50));
        }
        if (paddings[1] != null && !paddings[1].isPointValue()) {
            logger = LoggerFactory.getLogger(AbstractRenderer.class);
            logger.error(MessageFormatUtil.format("Property {0} in percents is not supported", 49));
        }
        if (paddings[2] != null && !paddings[2].isPointValue()) {
            logger = LoggerFactory.getLogger(AbstractRenderer.class);
            logger.error(MessageFormatUtil.format("Property {0} in percents is not supported", 47));
        }
        if (paddings[3] != null && !paddings[3].isPointValue()) {
            logger = LoggerFactory.getLogger(AbstractRenderer.class);
            logger.error(MessageFormatUtil.format("Property {0} in percents is not supported", 48));
        }
        return rect.applyMargins(paddings[0] != null ? paddings[0].getValue() : 0.0f, paddings[1] != null ? paddings[1].getValue() : 0.0f, paddings[2] != null ? paddings[2].getValue() : 0.0f, paddings[3] != null ? paddings[3].getValue() : 0.0f, reverse);
    }

    protected Rectangle applyBorderBox(Rectangle rect, Border[] borders, boolean reverse) {
        float topWidth = borders[0] != null ? borders[0].getWidth() : 0.0f;
        float rightWidth = borders[1] != null ? borders[1].getWidth() : 0.0f;
        float bottomWidth = borders[2] != null ? borders[2].getWidth() : 0.0f;
        float leftWidth = borders[3] != null ? borders[3].getWidth() : 0.0f;
        return rect.applyMargins(topWidth, rightWidth, bottomWidth, leftWidth, reverse);
    }

    protected void applyAbsolutePosition(Rectangle parentRect) {
        Float top = this.getPropertyAsFloat(73);
        Float bottom = this.getPropertyAsFloat(14);
        Float left = this.getPropertyAsFloat(34);
        Float right = this.getPropertyAsFloat(54);
        if (left == null && right == null && BaseDirection.RIGHT_TO_LEFT.equals(this.getProperty(7))) {
            right = Float.valueOf(0.0f);
        }
        if (top == null && bottom == null) {
            top = Float.valueOf(0.0f);
        }
        try {
            if (right != null) {
                this.move(parentRect.getRight() - right.floatValue() - this.occupiedArea.getBBox().getRight(), 0.0f);
            }
            if (left != null) {
                this.move(parentRect.getLeft() + left.floatValue() - this.occupiedArea.getBBox().getLeft(), 0.0f);
            }
            if (top != null) {
                this.move(0.0f, parentRect.getTop() - top.floatValue() - this.occupiedArea.getBBox().getTop());
            }
            if (bottom != null) {
                this.move(0.0f, parentRect.getBottom() + bottom.floatValue() - this.occupiedArea.getBBox().getBottom());
            }
        }
        catch (Exception exc) {
            Logger logger = LoggerFactory.getLogger(AbstractRenderer.class);
            logger.error(MessageFormatUtil.format("Occupied area has not been initialized. {0}", "Absolute positioning might be applied incorrectly."));
        }
    }

    protected void applyRelativePositioningTranslation(boolean reverse) {
        float dyUp;
        float top = this.getPropertyAsFloat(73, Float.valueOf(0.0f)).floatValue();
        float bottom = this.getPropertyAsFloat(14, Float.valueOf(0.0f)).floatValue();
        float left = this.getPropertyAsFloat(34, Float.valueOf(0.0f)).floatValue();
        float right = this.getPropertyAsFloat(54, Float.valueOf(0.0f)).floatValue();
        int reverseMultiplier = reverse ? -1 : 1;
        float dxRight = left != 0.0f ? left * (float)reverseMultiplier : -right * (float)reverseMultiplier;
        float f = dyUp = top != 0.0f ? -top * (float)reverseMultiplier : bottom * (float)reverseMultiplier;
        if (dxRight != 0.0f || dyUp != 0.0f) {
            this.move(dxRight, dyUp);
        }
    }

    protected void applyDestination(PdfDocument document) {
        boolean isPdf20;
        Object destination = this.getProperty(17);
        if (destination == null) {
            return;
        }
        String destinationName = null;
        PdfDictionary linkActionDict = null;
        if (destination instanceof String) {
            destinationName = (String)destination;
        } else if (CHECK_TUPLE2_TYPE.getClass().equals(destination.getClass())) {
            Tuple2 destTuple = (Tuple2)destination;
            destinationName = (String)destTuple.getFirst();
            linkActionDict = (PdfDictionary)destTuple.getSecond();
        }
        if (destinationName != null) {
            int pageNumber = this.occupiedArea.getPageNumber();
            if (pageNumber < 1 || pageNumber > document.getNumberOfPages()) {
                Logger logger = LoggerFactory.getLogger(AbstractRenderer.class);
                String logMessageArg = "Property.DESTINATION, which specifies this element location as destination, see ElementPropertyContainer.setDestination.";
                logger.warn(MessageFormatUtil.format("Unable to apply page dependent property, because the page on which element is drawn is unknown. Usually this means that element was added to the Canvas instance that was created not with constructor taking PdfPage as argument. Not processed property: {0}", logMessageArg));
                return;
            }
            PdfArray array = new PdfArray();
            array.add((PdfObject)document.getPage(pageNumber).getPdfObject());
            array.add(PdfName.XYZ);
            array.add(new PdfNumber(this.occupiedArea.getBBox().getX()));
            array.add(new PdfNumber(this.occupiedArea.getBBox().getY() + this.occupiedArea.getBBox().getHeight()));
            array.add(new PdfNumber(0));
            document.addNamedDestination(destinationName, array.makeIndirect(document));
        }
        boolean bl = isPdf20 = document.getPdfVersion().compareTo(PdfVersion.PDF_2_0) >= 0;
        if (linkActionDict != null && isPdf20 && document.isTagged()) {
            PdfStructElem structElem = AbstractRenderer.getCurrentStructElem(document);
            PdfStructureDestination dest = PdfStructureDestination.createFit(structElem);
            linkActionDict.put(PdfName.SD, (PdfObject)dest.getPdfObject());
        }
        this.deleteProperty(17);
    }

    protected void applyAction(PdfDocument document) {
        PdfAction action = (PdfAction)this.getProperty(1);
        if (action != null) {
            PdfLinkAnnotation link = (PdfLinkAnnotation)this.getProperty(88);
            if (link == null) {
                link = (PdfLinkAnnotation)new PdfLinkAnnotation(new Rectangle(0.0f, 0.0f, 0.0f, 0.0f)).setFlags(4);
                Border border = (Border)this.getProperty(11);
                if (border != null) {
                    link.setBorder(new PdfArray(new float[]{0.0f, 0.0f, border.getWidth()}));
                } else {
                    link.setBorder(new PdfArray(new float[]{0.0f, 0.0f, 0.0f}));
                }
                this.setProperty(88, link);
            }
            link.setAction(action);
        }
    }

    protected void applyLinkAnnotation(PdfDocument document) {
        Logger logger = LoggerFactory.getLogger(AbstractRenderer.class);
        PdfLinkAnnotation linkAnnotation = (PdfLinkAnnotation)this.getProperty(88);
        if (linkAnnotation == null) {
            return;
        }
        int pageNumber = this.occupiedArea.getPageNumber();
        if (pageNumber < 1 || pageNumber > document.getNumberOfPages()) {
            String logMessageArg = "Property.LINK_ANNOTATION, which specifies a link associated with this element content area, see com.itextpdf.layout.element.Link.";
            logger.warn(MessageFormatUtil.format("Unable to apply page dependent property, because the page on which element is drawn is unknown. Usually this means that element was added to the Canvas instance that was created not with constructor taking PdfPage as argument. Not processed property: {0}", logMessageArg));
            return;
        }
        PdfDictionary newAnnotation = (PdfDictionary)((PdfDictionary)linkAnnotation.getPdfObject()).clone();
        linkAnnotation = (PdfLinkAnnotation)PdfAnnotation.makeAnnotation(newAnnotation);
        Rectangle pdfBBox = this.calculateAbsolutePdfBBox();
        linkAnnotation.setRectangle(new PdfArray(pdfBBox));
        PdfPage page = document.getPage(pageNumber);
        if (page.isFlushed()) {
            logger.error(MessageFormatUtil.format("Page was flushed. {0} will not be performed.", "link annotation applying"));
        } else {
            page.addAnnotation(linkAnnotation);
        }
    }

    private Float retrieveResolvedParentDeclaredHeight() {
        if (this.parent != null && this.parent.getProperty(27) != null) {
            UnitValue parentHeightUV = AbstractRenderer.getPropertyAsUnitValue(this.parent, 27);
            if (parentHeightUV.isPointValue()) {
                return Float.valueOf(parentHeightUV.getValue());
            }
            return ((AbstractRenderer)this.parent).retrieveHeight();
        }
        return null;
    }

    private Float retrieveDirectParentDeclaredHeight() {
        UnitValue parentHeightUV;
        if (this.parent != null && this.parent.getProperty(27) != null && (parentHeightUV = AbstractRenderer.getPropertyAsUnitValue(this.parent, 27)).isPointValue()) {
            return Float.valueOf(parentHeightUV.getValue());
        }
        return null;
    }

    protected void updateHeightsOnSplit(boolean wasHeightClipped, AbstractRenderer splitRenderer, AbstractRenderer overflowRenderer) {
        this.updateHeightsOnSplit(this.occupiedArea.getBBox().getHeight(), wasHeightClipped, splitRenderer, overflowRenderer, true);
    }

    void updateHeightsOnSplit(float usedHeight, boolean wasHeightClipped, AbstractRenderer splitRenderer, AbstractRenderer overflowRenderer, boolean enlargeOccupiedAreaOnHeightWasClipped) {
        UnitValue heightUV;
        UnitValue minHeightUV;
        if (wasHeightClipped) {
            Logger logger = LoggerFactory.getLogger(AbstractRenderer.class);
            logger.warn("Element content was clipped because some height properties are set.");
            if (enlargeOccupiedAreaOnHeightWasClipped) {
                Float maxHeight = this.retrieveMaxHeight();
                splitRenderer.occupiedArea.getBBox().moveDown(maxHeight.floatValue() - usedHeight).setHeight(maxHeight.floatValue());
                usedHeight = maxHeight.floatValue();
            }
        }
        if (overflowRenderer == null || this.isKeepTogether()) {
            return;
        }
        Float parentResolvedHeightPropertyValue = this.retrieveResolvedParentDeclaredHeight();
        UnitValue maxHeightUV = AbstractRenderer.getPropertyAsUnitValue(this, 84);
        if (maxHeightUV != null) {
            if (maxHeightUV.isPointValue()) {
                Float maxHeight = this.retrieveMaxHeight();
                UnitValue updateMaxHeight = UnitValue.createPointValue(maxHeight.floatValue() - usedHeight);
                overflowRenderer.updateMaxHeight(updateMaxHeight);
            } else if (parentResolvedHeightPropertyValue != null) {
                float currentOccupiedFraction = usedHeight / parentResolvedHeightPropertyValue.floatValue() * 100.0f;
                float newFraction = maxHeightUV.getValue() - currentOccupiedFraction;
                overflowRenderer.updateMinHeight(UnitValue.createPercentValue(newFraction));
            }
        }
        if ((minHeightUV = AbstractRenderer.getPropertyAsUnitValue(this, 85)) != null) {
            if (minHeightUV.isPointValue()) {
                Float minHeight = this.retrieveMinHeight();
                UnitValue updateminHeight = UnitValue.createPointValue(minHeight.floatValue() - usedHeight);
                overflowRenderer.updateMinHeight(updateminHeight);
            } else if (parentResolvedHeightPropertyValue != null) {
                float currentOccupiedFraction = usedHeight / parentResolvedHeightPropertyValue.floatValue() * 100.0f;
                float newFraction = minHeightUV.getValue() - currentOccupiedFraction;
                overflowRenderer.updateMinHeight(UnitValue.createPercentValue(newFraction));
            }
        }
        if ((heightUV = AbstractRenderer.getPropertyAsUnitValue(this, 27)) != null) {
            if (heightUV.isPointValue()) {
                Float height = this.retrieveHeight();
                UnitValue updateHeight = UnitValue.createPointValue(height.floatValue() - usedHeight);
                overflowRenderer.updateHeight(updateHeight);
            } else if (parentResolvedHeightPropertyValue != null) {
                float currentOccupiedFraction = usedHeight / parentResolvedHeightPropertyValue.floatValue() * 100.0f;
                float newFraction = heightUV.getValue() - currentOccupiedFraction;
                overflowRenderer.updateMinHeight(UnitValue.createPercentValue(newFraction));
            }
        }
    }

    public MinMaxWidth getMinMaxWidth() {
        return MinMaxWidthUtils.countDefaultMinMaxWidth(this);
    }

    protected boolean setMinMaxWidthBasedOnFixedWidth(MinMaxWidth minMaxWidth) {
        Float width;
        if (this.hasAbsoluteUnitValue(77) && (width = this.retrieveWidth(0.0f)) != null) {
            minMaxWidth.setChildrenMaxWidth(width.floatValue());
            minMaxWidth.setChildrenMinWidth(width.floatValue());
            return true;
        }
        return false;
    }

    protected boolean isNotFittingHeight(LayoutArea layoutArea) {
        return !this.isPositioned() && this.occupiedArea.getBBox().getHeight() > layoutArea.getBBox().getHeight();
    }

    protected boolean isNotFittingWidth(LayoutArea layoutArea) {
        return !this.isPositioned() && this.occupiedArea.getBBox().getWidth() > layoutArea.getBBox().getWidth();
    }

    protected boolean isNotFittingLayoutArea(LayoutArea layoutArea) {
        return this.isNotFittingHeight(layoutArea) || this.isNotFittingWidth(layoutArea);
    }

    protected boolean isPositioned() {
        return !this.isStaticLayout();
    }

    protected boolean isFixedLayout() {
        Object positioning = this.getProperty(52);
        return Integer.valueOf(4).equals(positioning);
    }

    protected boolean isStaticLayout() {
        Object positioning = this.getProperty(52);
        return positioning == null || Integer.valueOf(1).equals(positioning);
    }

    protected boolean isRelativePosition() {
        Integer positioning = this.getPropertyAsInteger(52);
        return Integer.valueOf(2).equals(positioning);
    }

    protected boolean isAbsolutePosition() {
        Integer positioning = this.getPropertyAsInteger(52);
        return Integer.valueOf(3).equals(positioning);
    }

    protected boolean isKeepTogether() {
        return this.isKeepTogether(null);
    }

    boolean isKeepTogether(IRenderer causeOfNothing) {
        return Boolean.TRUE.equals(this.getPropertyAsBoolean(32)) && !(causeOfNothing instanceof AreaBreakRenderer);
    }

    protected void alignChildHorizontally(IRenderer childRenderer, Rectangle currentArea) {
        float freeSpace;
        float availableWidth = currentArea.getWidth();
        HorizontalAlignment horizontalAlignment = (HorizontalAlignment)((Object)childRenderer.getProperty(28));
        if (horizontalAlignment != null && horizontalAlignment != HorizontalAlignment.LEFT && (freeSpace = availableWidth - childRenderer.getOccupiedArea().getBBox().getWidth()) > 0.0f) {
            try {
                switch (horizontalAlignment) {
                    case RIGHT: {
                        childRenderer.move(freeSpace, 0.0f);
                        break;
                    }
                    case CENTER: {
                        childRenderer.move(freeSpace / 2.0f, 0.0f);
                    }
                }
            }
            catch (NullPointerException e) {
                Logger logger = LoggerFactory.getLogger(AbstractRenderer.class);
                logger.error(MessageFormatUtil.format("Occupied area has not been initialized. {0}", "Some of the children might not end up aligned horizontally."));
            }
        }
    }

    protected Border[] getBorders() {
        return AbstractRenderer.getBorders(this);
    }

    protected BorderRadius[] getBorderRadii() {
        return AbstractRenderer.getBorderRadii(this);
    }

    protected AbstractRenderer setBorders(Border border, int borderNumber) {
        switch (borderNumber) {
            case 0: {
                this.setProperty(13, border);
                break;
            }
            case 1: {
                this.setProperty(12, border);
                break;
            }
            case 2: {
                this.setProperty(10, border);
                break;
            }
            case 3: {
                this.setProperty(11, border);
            }
        }
        return this;
    }

    protected Rectangle calculateAbsolutePdfBBox() {
        Rectangle contentBox = this.getOccupiedAreaBBox();
        List<Point> contentBoxPoints = this.rectangleToPointsList(contentBox);
        AbstractRenderer renderer = this;
        while (renderer.parent != null) {
            Float angle;
            if (renderer instanceof BlockRenderer && (angle = (Float)renderer.getProperty(55)) != null) {
                BlockRenderer blockRenderer = (BlockRenderer)renderer;
                AffineTransform rotationTransform = blockRenderer.createRotationTransformInsideOccupiedArea();
                this.transformPoints(contentBoxPoints, rotationTransform);
            }
            if (renderer.getProperty(53) != null && (renderer instanceof BlockRenderer || renderer instanceof ImageRenderer || renderer instanceof TableRenderer)) {
                AffineTransform rotationTransform = renderer.createTransformationInsideOccupiedArea();
                this.transformPoints(contentBoxPoints, rotationTransform);
            }
            renderer = (AbstractRenderer)renderer.parent;
        }
        return this.calculateBBox(contentBoxPoints);
    }

    protected Rectangle calculateBBox(List<Point> points) {
        return Rectangle.calculateBBox(points);
    }

    protected List<Point> rectangleToPointsList(Rectangle rect) {
        return Arrays.asList(rect.toPointsArray());
    }

    protected List<Point> transformPoints(List<Point> points, AffineTransform transform) {
        for (Point point : points) {
            transform.transform(point, point);
        }
        return points;
    }

    protected float[] calculateShiftToPositionBBoxOfPointsAt(float left, float top, List<Point> points) {
        double minX = Double.MAX_VALUE;
        double maxY = -1.7976931348623157E308;
        for (Point point : points) {
            minX = Math.min(point.getX(), minX);
            maxY = Math.max(point.getY(), maxY);
        }
        float dx = (float)((double)left - minX);
        float dy = (float)((double)top - maxY);
        return new float[]{dx, dy};
    }

    protected boolean hasAbsoluteUnitValue(int property) {
        UnitValue value = (UnitValue)this.getProperty(property);
        return value != null && value.isPointValue();
    }

    protected boolean hasRelativeUnitValue(int property) {
        UnitValue value = (UnitValue)this.getProperty(property);
        return value != null && value.isPercentValue();
    }

    boolean isFirstOnRootArea(boolean checkRootAreaOnly) {
        boolean isFirstOnRootArea = true;
        IRenderer ancestor = this;
        while (isFirstOnRootArea && ancestor.getParent() != null) {
            IRenderer parent = ancestor.getParent();
            if (parent instanceof RootRenderer) {
                isFirstOnRootArea = ((RootRenderer)parent).currentArea.isEmptyArea();
            } else {
                if (parent.getOccupiedArea() == null) break;
                if (!checkRootAreaOnly) {
                    isFirstOnRootArea = parent.getOccupiedArea().getBBox().getHeight() < 1.0E-4f;
                }
            }
            ancestor = parent;
        }
        return isFirstOnRootArea;
    }

    PdfDocument getPdfDocument() {
        RootRenderer renderer = this.getRootRenderer();
        if (renderer instanceof DocumentRenderer) {
            Document document = ((DocumentRenderer)renderer).document;
            return document.getPdfDocument();
        }
        if (renderer instanceof CanvasRenderer) {
            return ((CanvasRenderer)renderer).canvas.getPdfDocument();
        }
        return null;
    }

    RootRenderer getRootRenderer() {
        IRenderer currentRenderer = this;
        while (currentRenderer instanceof AbstractRenderer) {
            if (currentRenderer instanceof RootRenderer) {
                return (RootRenderer)currentRenderer;
            }
            currentRenderer = currentRenderer.getParent();
        }
        return null;
    }

    static float calculateAdditionalWidth(AbstractRenderer renderer) {
        Rectangle dummy = new Rectangle(0.0f, 0.0f);
        renderer.applyMargins(dummy, true);
        renderer.applyBorderBox(dummy, true);
        renderer.applyPaddings(dummy, true);
        return dummy.getWidth();
    }

    static boolean noAbsolutePositionInfo(IRenderer renderer) {
        return !renderer.hasProperty(73) && !renderer.hasProperty(14) && !renderer.hasProperty(34) && !renderer.hasProperty(54);
    }

    static Float getPropertyAsFloat(IRenderer renderer, int property) {
        return NumberUtil.asFloat(renderer.getProperty(property));
    }

    static UnitValue getPropertyAsUnitValue(IRenderer renderer, int property) {
        UnitValue result = (UnitValue)renderer.getProperty(property);
        return result;
    }

    void shrinkOccupiedAreaForAbsolutePosition() {
        if (this.isAbsolutePosition()) {
            Float left = this.getPropertyAsFloat(34);
            Float right = this.getPropertyAsFloat(54);
            UnitValue width = (UnitValue)this.getProperty(77);
            if (left == null && right == null && width == null) {
                this.occupiedArea.getBBox().setWidth(0.0f);
            }
        }
    }

    void drawPositionedChildren(DrawContext drawContext) {
        for (IRenderer positionedChild : this.positionedRenderers) {
            positionedChild.draw(drawContext);
        }
    }

    FontCharacteristics createFontCharacteristics() {
        FontCharacteristics fc = new FontCharacteristics();
        if (this.hasProperty(95)) {
            fc.setFontWeight((String)this.getProperty(95));
        }
        if (this.hasProperty(94)) {
            fc.setFontStyle((String)this.getProperty(94));
        }
        return fc;
    }

    PdfFont resolveFirstPdfFont() {
        Object font = this.getProperty(20);
        if (font instanceof PdfFont) {
            return (PdfFont)font;
        }
        if (font instanceof String[]) {
            FontProvider provider = (FontProvider)this.getProperty(91);
            if (provider == null) {
                throw new IllegalStateException("FontProvider and FontSet are empty. Cannot resolve font family name (see ElementPropertyContainer#setFontFamily) without initialized FontProvider (see RootElement#setFontProvider).");
            }
            FontSet fontSet = (FontSet)this.getProperty(98);
            if (provider.getFontSet().isEmpty() && (fontSet == null || fontSet.isEmpty())) {
                throw new IllegalStateException("FontProvider and FontSet are empty. Cannot resolve font family name (see ElementPropertyContainer#setFontFamily) without initialized FontProvider (see RootElement#setFontProvider).");
            }
            FontCharacteristics fc = this.createFontCharacteristics();
            return this.resolveFirstPdfFont((String[])font, provider, fc, fontSet);
        }
        throw new IllegalStateException("String[] or PdfFont expected as value of FONT property");
    }

    PdfFont resolveFirstPdfFont(String[] font, FontProvider provider, FontCharacteristics fc, FontSet additionalFonts) {
        FontSelector fontSelector = provider.getFontSelector(Arrays.asList(font), fc, additionalFonts);
        return provider.getPdfFont(fontSelector.bestMatch(), additionalFonts);
    }

    static Border[] getBorders(IRenderer renderer) {
        Border topBorder = (Border)renderer.getProperty(13);
        Border rightBorder = (Border)renderer.getProperty(12);
        Border bottomBorder = (Border)renderer.getProperty(10);
        Border leftBorder = (Border)renderer.getProperty(11);
        return new Border[]{topBorder, rightBorder, bottomBorder, leftBorder};
    }

    void applyAbsolutePositionIfNeeded(LayoutContext layoutContext) {
        if (this.isAbsolutePosition()) {
            this.applyAbsolutePosition(layoutContext instanceof PositionedLayoutContext ? ((PositionedLayoutContext)layoutContext).getParentOccupiedArea().getBBox() : layoutContext.getArea().getBBox());
        }
    }

    void preparePositionedRendererAndAreaForLayout(IRenderer childPositionedRenderer, Rectangle fullBbox, Rectangle parentBbox) {
        Float left = AbstractRenderer.getPropertyAsFloat(childPositionedRenderer, 34);
        Float right = AbstractRenderer.getPropertyAsFloat(childPositionedRenderer, 54);
        Float top = AbstractRenderer.getPropertyAsFloat(childPositionedRenderer, 73);
        Float bottom = AbstractRenderer.getPropertyAsFloat(childPositionedRenderer, 14);
        childPositionedRenderer.setParent(this);
        this.adjustPositionedRendererLayoutBoxWidth(childPositionedRenderer, fullBbox, left, right);
        if (Integer.valueOf(3).equals(childPositionedRenderer.getProperty(52))) {
            this.updateMinHeightForAbsolutelyPositionedRenderer(childPositionedRenderer, parentBbox, top, bottom);
        }
    }

    private void updateMinHeightForAbsolutelyPositionedRenderer(IRenderer renderer, Rectangle parentRendererBox, Float top, Float bottom) {
        if (top != null && bottom != null && !renderer.hasProperty(27)) {
            UnitValue currentMaxHeight = AbstractRenderer.getPropertyAsUnitValue(renderer, 84);
            UnitValue currentMinHeight = AbstractRenderer.getPropertyAsUnitValue(renderer, 85);
            float resolvedMinHeight = Math.max(0.0f, parentRendererBox.getTop() - top.floatValue() - parentRendererBox.getBottom() - bottom.floatValue());
            Rectangle dummy = new Rectangle(0.0f, 0.0f);
            if (!AbstractRenderer.isBorderBoxSizing(renderer)) {
                this.applyPaddings(dummy, AbstractRenderer.getPaddings(renderer), true);
                this.applyBorderBox(dummy, AbstractRenderer.getBorders(renderer), true);
            }
            this.applyMargins(dummy, AbstractRenderer.getMargins(renderer), true);
            resolvedMinHeight -= dummy.getHeight();
            if (currentMinHeight != null) {
                resolvedMinHeight = Math.max(resolvedMinHeight, currentMinHeight.getValue());
            }
            if (currentMaxHeight != null) {
                resolvedMinHeight = Math.min(resolvedMinHeight, currentMaxHeight.getValue());
            }
            renderer.setProperty(85, UnitValue.createPointValue(resolvedMinHeight));
            renderer.setProperty(27, UnitValue.createPointValue(resolvedMinHeight));
        }
    }

    private void adjustPositionedRendererLayoutBoxWidth(IRenderer renderer, Rectangle fullBbox, Float left, Float right) {
        if (left != null) {
            fullBbox.setWidth(fullBbox.getWidth() - left.floatValue()).setX(fullBbox.getX() + left.floatValue());
        }
        if (right != null) {
            fullBbox.setWidth(fullBbox.getWidth() - right.floatValue());
        }
        if (left == null && right == null && !renderer.hasProperty(77)) {
            MinMaxWidth minMaxWidth;
            MinMaxWidth minMaxWidth2 = minMaxWidth = renderer instanceof BlockRenderer ? ((BlockRenderer)renderer).getMinMaxWidth() : null;
            if (minMaxWidth != null && minMaxWidth.getMaxWidth() < fullBbox.getWidth()) {
                fullBbox.setWidth(minMaxWidth.getMaxWidth() + 1.0E-4f);
            }
        }
    }

    static float calculatePaddingBorderWidth(AbstractRenderer renderer) {
        Rectangle dummy = new Rectangle(0.0f, 0.0f);
        renderer.applyBorderBox(dummy, true);
        renderer.applyPaddings(dummy, true);
        return dummy.getWidth();
    }

    static float calculatePaddingBorderHeight(AbstractRenderer renderer) {
        Rectangle dummy = new Rectangle(0.0f, 0.0f);
        renderer.applyBorderBox(dummy, true);
        renderer.applyPaddings(dummy, true);
        return dummy.getHeight();
    }

    private AffineTransform createTransformationInsideOccupiedArea() {
        Rectangle backgroundArea = this.applyMargins(this.occupiedArea.clone().getBBox(), false);
        float x = backgroundArea.getX();
        float y = backgroundArea.getY();
        float height = backgroundArea.getHeight();
        float width = backgroundArea.getWidth();
        AffineTransform transform = AffineTransform.getTranslateInstance(-1.0f * (x + width / 2.0f), -1.0f * (y + height / 2.0f));
        transform.preConcatenate(Transform.getAffineTransform((Transform)this.getProperty(53), width, height));
        transform.preConcatenate(AffineTransform.getTranslateInstance(x + width / 2.0f, y + height / 2.0f));
        return transform;
    }

    protected void beginTransformationIfApplied(PdfCanvas canvas) {
        if (this.getProperty(53) != null) {
            AffineTransform transform = this.createTransformationInsideOccupiedArea();
            canvas.saveState().concatMatrix(transform);
        }
    }

    protected void endTransformationIfApplied(PdfCanvas canvas) {
        if (this.getProperty(53) != null) {
            canvas.restoreState();
        }
    }

    void addChildRenderer(IRenderer child) {
        child.setParent(this);
        this.childRenderers.add(child);
    }

    void addAllChildRenderers(List<IRenderer> children) {
        if (children == null) {
            return;
        }
        this.setThisAsParent(children);
        this.childRenderers.addAll(children);
    }

    void addAllChildRenderers(int index, List<IRenderer> children) {
        this.setThisAsParent(children);
        this.childRenderers.addAll(index, children);
    }

    void setChildRenderers(List<IRenderer> children) {
        this.removeThisFromParents(this.childRenderers);
        this.childRenderers.clear();
        this.addAllChildRenderers(children);
    }

    IRenderer removeChildRenderer(int index) {
        IRenderer removed = this.childRenderers.remove(index);
        this.removeThisFromParent(removed);
        return removed;
    }

    boolean removeAllChildRenderers(Collection<IRenderer> children) {
        this.removeThisFromParents(children);
        return this.childRenderers.removeAll(children);
    }

    IRenderer setChildRenderer(int index, IRenderer child) {
        if (child != null) {
            child.setParent(this);
        }
        IRenderer removedElement = this.childRenderers.set(index, child);
        this.removeThisFromParent(removedElement);
        return removedElement;
    }

    void setThisAsParent(Collection<IRenderer> children) {
        for (IRenderer child : children) {
            child.setParent(this);
        }
    }

    boolean logWarningIfGetNextRendererNotOverridden(Class<?> baseClass, Class<?> rendererClass) {
        if (baseClass != rendererClass) {
            Logger logger = LoggerFactory.getLogger(baseClass);
            logger.warn(MessageFormatUtil.format("If a renderer overflows, iText uses this method to create another renderer for the overflow part. So if one wants to extend the renderer, one should override this method: otherwise the default method will be used and thus the default rather than the custom renderer will be created.", new Object[0]));
            return false;
        }
        return true;
    }

    private void removeThisFromParent(IRenderer toRemove) {
        if (toRemove != null && this == toRemove.getParent() && !this.childRenderers.contains(toRemove)) {
            toRemove.setParent(null);
        }
    }

    private void removeThisFromParents(Collection<IRenderer> children) {
        for (IRenderer child : children) {
            if (child == null || this != child.getParent()) continue;
            child.setParent(null);
        }
    }

    private static UnitValue[] getMargins(IRenderer renderer) {
        return new UnitValue[]{(UnitValue)renderer.getProperty(46), (UnitValue)renderer.getProperty(45), (UnitValue)renderer.getProperty(43), (UnitValue)renderer.getProperty(44)};
    }

    private static BorderRadius[] getBorderRadii(IRenderer renderer) {
        BorderRadius topLeftRadius = (BorderRadius)renderer.getProperty(110);
        BorderRadius topRightRadius = (BorderRadius)renderer.getProperty(111);
        BorderRadius bottomRightRadius = (BorderRadius)renderer.getProperty(112);
        BorderRadius bottomLeftRadius = (BorderRadius)renderer.getProperty(113);
        return new BorderRadius[]{topLeftRadius, topRightRadius, bottomRightRadius, bottomLeftRadius};
    }

    private static UnitValue[] getPaddings(IRenderer renderer) {
        return new UnitValue[]{(UnitValue)renderer.getProperty(50), (UnitValue)renderer.getProperty(49), (UnitValue)renderer.getProperty(47), (UnitValue)renderer.getProperty(48)};
    }

    private static boolean hasOwnOrModelProperty(IRenderer renderer, int property) {
        return renderer.hasOwnProperty(property) || null != renderer.getModelElement() && renderer.getModelElement().hasProperty(property);
    }

    private static PdfStructElem getCurrentStructElem(PdfDocument document) {
        TagStructureContext context = document.getTagStructureContext();
        TagTreePointer tagPointer = context.getAutoTaggingPointer();
        return context.getPointerStructElem(tagPointer);
    }
}

