/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.properties;

import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.properties.BackgroundSize;

public class BackgroundRepeat {
    private final BackgroundRepeatValue xAxisRepeat;
    private final BackgroundRepeatValue yAxisRepeat;

    public BackgroundRepeat() {
        this(BackgroundRepeatValue.REPEAT);
    }

    public BackgroundRepeat(BackgroundRepeatValue repeat) {
        this(repeat, repeat);
    }

    public BackgroundRepeat(BackgroundRepeatValue xAxisRepeat, BackgroundRepeatValue yAxisRepeat) {
        this.xAxisRepeat = xAxisRepeat;
        this.yAxisRepeat = yAxisRepeat;
    }

    public BackgroundRepeatValue getXAxisRepeat() {
        return this.xAxisRepeat;
    }

    public BackgroundRepeatValue getYAxisRepeat() {
        return this.yAxisRepeat;
    }

    public boolean isNoRepeatOnXAxis() {
        return this.xAxisRepeat == BackgroundRepeatValue.NO_REPEAT;
    }

    public boolean isNoRepeatOnYAxis() {
        return this.yAxisRepeat == BackgroundRepeatValue.NO_REPEAT;
    }

    public Point prepareRectangleToDrawingAndGetWhitespace(Rectangle imageRectangle, Rectangle backgroundArea, BackgroundSize backgroundSize) {
        float initialImageRatio;
        int ratio;
        if (BackgroundRepeatValue.ROUND == this.xAxisRepeat) {
            ratio = BackgroundRepeat.calculateRatio(backgroundArea.getWidth(), imageRectangle.getWidth());
            initialImageRatio = imageRectangle.getHeight() / imageRectangle.getWidth();
            imageRectangle.setWidth(backgroundArea.getWidth() / (float)ratio);
            if (BackgroundRepeatValue.ROUND != this.yAxisRepeat && backgroundSize.getBackgroundHeightSize() == null) {
                imageRectangle.moveUp(imageRectangle.getHeight() - imageRectangle.getWidth() * initialImageRatio);
                imageRectangle.setHeight(imageRectangle.getWidth() * initialImageRatio);
            }
        }
        if (BackgroundRepeatValue.ROUND == this.yAxisRepeat) {
            ratio = BackgroundRepeat.calculateRatio(backgroundArea.getHeight(), imageRectangle.getHeight());
            initialImageRatio = imageRectangle.getWidth() / imageRectangle.getHeight();
            imageRectangle.moveUp(imageRectangle.getHeight() - backgroundArea.getHeight() / (float)ratio);
            imageRectangle.setHeight(backgroundArea.getHeight() / (float)ratio);
            if (BackgroundRepeatValue.ROUND != this.xAxisRepeat && backgroundSize.getBackgroundWidthSize() == null) {
                imageRectangle.setWidth(imageRectangle.getHeight() * initialImageRatio);
            }
        }
        return this.processSpaceValueAndCalculateWhitespace(imageRectangle, backgroundArea);
    }

    private Point processSpaceValueAndCalculateWhitespace(Rectangle imageRectangle, Rectangle backgroundArea) {
        Point whitespace = new Point();
        if (BackgroundRepeatValue.SPACE == this.xAxisRepeat) {
            if (imageRectangle.getWidth() * 2.0f <= backgroundArea.getWidth()) {
                imageRectangle.setX(backgroundArea.getX());
                whitespace.setLocation(BackgroundRepeat.calculateWhitespace(backgroundArea.getWidth(), imageRectangle.getWidth()), 0.0);
            } else {
                float leftSpace;
                float rightSpace = backgroundArea.getRight() - imageRectangle.getRight();
                float xWhitespace = Math.max(rightSpace, leftSpace = imageRectangle.getLeft() - backgroundArea.getLeft());
                xWhitespace = xWhitespace > 0.0f ? xWhitespace : 0.0f;
                whitespace.setLocation(xWhitespace, 0.0);
            }
        }
        if (BackgroundRepeatValue.SPACE == this.yAxisRepeat) {
            if (imageRectangle.getHeight() * 2.0f <= backgroundArea.getHeight()) {
                imageRectangle.setY(backgroundArea.getY() + backgroundArea.getHeight() - imageRectangle.getHeight());
                whitespace.setLocation(whitespace.getX(), BackgroundRepeat.calculateWhitespace(backgroundArea.getHeight(), imageRectangle.getHeight()));
            } else {
                float bottomSpace;
                float topSpace = backgroundArea.getTop() - imageRectangle.getTop();
                float yWhitespace = Math.max(topSpace, bottomSpace = imageRectangle.getBottom() - backgroundArea.getBottom());
                yWhitespace = yWhitespace > 0.0f ? yWhitespace : 0.0f;
                whitespace.setLocation(whitespace.getX(), yWhitespace);
            }
        }
        return whitespace;
    }

    private static int calculateRatio(float areaSize, float backgroundSize) {
        int ratio = (int)Math.floor(areaSize / backgroundSize);
        float remainSpace = areaSize - (float)ratio * backgroundSize;
        if (remainSpace >= backgroundSize / 2.0f) {
            ++ratio;
        }
        return ratio == 0 ? 1 : ratio;
    }

    private static float calculateWhitespace(float areaSize, float backgroundSize) {
        float whitespace = 0.0f;
        int ratio = (int)Math.floor(areaSize / backgroundSize);
        if (ratio > 0) {
            whitespace = areaSize - (float)ratio * backgroundSize;
            if (ratio > 1) {
                whitespace /= (float)(ratio - 1);
            }
        }
        return whitespace;
    }

    public static enum BackgroundRepeatValue {
        NO_REPEAT,
        REPEAT,
        ROUND,
        SPACE;

    }
}

