/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.font;

import com.itextpdf.io.font.FontEncoding;
import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.FontProgramFactory;
import com.itextpdf.io.font.Type1Font;
import com.itextpdf.io.font.cmap.CMapToUnicode;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.kernel.font.FontUtil;
import com.itextpdf.kernel.font.IDocFontProgram;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DocType1Font
extends Type1Font
implements IDocFontProgram {
    private PdfStream fontFile;
    private PdfName fontFileName;
    private PdfName subtype;
    private int missingWidth = 0;

    private DocType1Font(String fontName) {
        super(fontName);
    }

    static Type1Font createFontProgram(PdfDictionary fontDictionary, FontEncoding fontEncoding, CMapToUnicode toUnicode) {
        Type1Font type1StdFont;
        String baseFont = DocType1Font.getBaseFont(fontDictionary);
        if (!fontDictionary.containsKey(PdfName.FontDescriptor) && (type1StdFont = DocType1Font.getType1Font(baseFont)) != null) {
            type1StdFont.initializeGlyphs(fontEncoding);
            return type1StdFont;
        }
        DocType1Font fontProgram = new DocType1Font(baseFont);
        PdfDictionary fontDesc = fontDictionary.getAsDictionary(PdfName.FontDescriptor);
        fontProgram.subtype = fontDesc != null ? fontDesc.getAsName(PdfName.Subtype) : null;
        DocType1Font.fillFontDescriptor(fontProgram, fontDesc);
        DocType1Font.initializeGlyphs(fontDictionary, fontEncoding, toUnicode, fontProgram);
        return fontProgram;
    }

    static void initializeGlyphs(PdfDictionary fontDictionary, FontEncoding fontEncoding, CMapToUnicode toUnicode, DocType1Font fontProgram) {
        PdfNumber firstCharNumber = fontDictionary.getAsNumber(PdfName.FirstChar);
        int firstChar = firstCharNumber != null ? Math.max(firstCharNumber.intValue(), 0) : 0;
        int[] widths = FontUtil.convertSimpleWidthsArray(fontDictionary.getAsArray(PdfName.Widths), firstChar, fontProgram.getMissingWidth());
        fontProgram.avgWidth = 0;
        int glyphsWithWidths = 0;
        for (int i = 0; i < 256; ++i) {
            Glyph glyph = new Glyph(i, widths[i], fontEncoding.getUnicode(i));
            fontProgram.codeToGlyph.put(i, glyph);
            if (glyph.hasValidUnicode()) {
                if (fontEncoding.convertToByte(glyph.getUnicode()) == i) {
                    fontProgram.unicodeToGlyph.put(glyph.getUnicode(), glyph);
                }
            } else if (toUnicode != null) {
                glyph.setChars(toUnicode.lookup(i));
            }
            if (widths[i] <= 0) continue;
            ++glyphsWithWidths;
            fontProgram.avgWidth += widths[i];
        }
        if (glyphsWithWidths != 0) {
            fontProgram.avgWidth /= glyphsWithWidths;
        }
    }

    static String getBaseFont(PdfDictionary fontDictionary) {
        PdfName baseFontName = fontDictionary.getAsName(PdfName.BaseFont);
        if (baseFontName == null) {
            return FontUtil.createRandomFontName();
        }
        return baseFontName.getValue();
    }

    static Type1Font getType1Font(String baseFont) {
        try {
            return (Type1Font)FontProgramFactory.createFont(baseFont, false);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public PdfStream getFontFile() {
        return this.fontFile;
    }

    @Override
    public PdfName getFontFileName() {
        return this.fontFileName;
    }

    @Override
    public PdfName getSubtype() {
        return this.subtype;
    }

    @Override
    public boolean isBuiltWith(String fontName) {
        return false;
    }

    public int getMissingWidth() {
        return this.missingWidth;
    }

    static void fillFontDescriptor(DocType1Font font, PdfDictionary fontDesc) {
        PdfName[] fontFileNames;
        PdfNumber flagsValue;
        PdfString fontFamily;
        PdfArray bboxValue;
        PdfName fontStretch;
        if (fontDesc == null) {
            Logger logger = LoggerFactory.getLogger(FontUtil.class);
            logger.warn("Font dictionary does not contain required /FontDescriptor entry.");
            return;
        }
        PdfNumber v = fontDesc.getAsNumber(PdfName.Ascent);
        if (v != null) {
            font.setTypoAscender(v.intValue());
        }
        if ((v = fontDesc.getAsNumber(PdfName.Descent)) != null) {
            font.setTypoDescender(v.intValue());
        }
        if ((v = fontDesc.getAsNumber(PdfName.CapHeight)) != null) {
            font.setCapHeight(v.intValue());
        }
        if ((v = fontDesc.getAsNumber(PdfName.XHeight)) != null) {
            font.setXHeight(v.intValue());
        }
        if ((v = fontDesc.getAsNumber(PdfName.ItalicAngle)) != null) {
            font.setItalicAngle(v.intValue());
        }
        if ((v = fontDesc.getAsNumber(PdfName.StemV)) != null) {
            font.setStemV(v.intValue());
        }
        if ((v = fontDesc.getAsNumber(PdfName.StemH)) != null) {
            font.setStemH(v.intValue());
        }
        if ((v = fontDesc.getAsNumber(PdfName.FontWeight)) != null) {
            font.setFontWeight(v.intValue());
        }
        if ((v = fontDesc.getAsNumber(PdfName.MissingWidth)) != null) {
            font.missingWidth = v.intValue();
        }
        if ((fontStretch = fontDesc.getAsName(PdfName.FontStretch)) != null) {
            font.setFontStretch(fontStretch.getValue());
        }
        if ((bboxValue = fontDesc.getAsArray(PdfName.FontBBox)) != null) {
            int t;
            int[] bbox = new int[]{bboxValue.getAsNumber(0).intValue(), bboxValue.getAsNumber(1).intValue(), bboxValue.getAsNumber(2).intValue(), bboxValue.getAsNumber(3).intValue()};
            if (bbox[0] > bbox[2]) {
                t = bbox[0];
                bbox[0] = bbox[2];
                bbox[2] = t;
            }
            if (bbox[1] > bbox[3]) {
                t = bbox[1];
                bbox[1] = bbox[3];
                bbox[3] = t;
            }
            font.setBbox(bbox);
            if (font.getFontMetrics().getTypoAscender() == 0 && font.getFontMetrics().getTypoDescender() == 0) {
                float maxAscent = Math.max(bbox[3], font.getFontMetrics().getTypoAscender());
                float minDescent = Math.min(bbox[1], font.getFontMetrics().getTypoDescender());
                font.setTypoAscender((int)(FontProgram.convertGlyphSpaceToTextSpace(maxAscent) / (maxAscent - minDescent)));
                font.setTypoDescender((int)(FontProgram.convertGlyphSpaceToTextSpace(minDescent) / (maxAscent - minDescent)));
            }
        }
        if ((fontFamily = fontDesc.getAsString(PdfName.FontFamily)) != null) {
            font.setFontFamily(fontFamily.getValue());
        }
        if ((flagsValue = fontDesc.getAsNumber(PdfName.Flags)) != null) {
            int flags = flagsValue.intValue();
            if ((flags & 1) != 0) {
                font.setFixedPitch(true);
            }
            if ((flags & 0x40000) != 0) {
                font.setBold(true);
            }
        }
        for (PdfName fontFile : fontFileNames = new PdfName[]{PdfName.FontFile, PdfName.FontFile2, PdfName.FontFile3}) {
            if (!fontDesc.containsKey(fontFile)) continue;
            font.fontFileName = fontFile;
            font.fontFile = fontDesc.getAsStream(fontFile);
            break;
        }
    }
}

