/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.tags.DivTagWorker;
import com.itextpdf.styledxmlparser.jsoup.nodes.TextNode;
import com.itextpdf.styledxmlparser.node.IElementNode;
import com.itextpdf.styledxmlparser.node.impl.jsoup.node.JsoupTextNode;

public class OptionTagWorker
extends DivTagWorker {
    private StringBuilder actualOptionTextContent;
    private String labelAttrVal;
    private boolean labelReplacedContent;
    private boolean fakedContent;

    public OptionTagWorker(IElementNode element, ProcessorContext context) {
        super(element, context);
        boolean selectedAttr = element.getAttribute("selected") != null;
        this.getElementResult().setProperty(0x200009, selectedAttr);
        this.actualOptionTextContent = new StringBuilder();
        this.labelAttrVal = element.getAttribute("label");
        if (this.labelAttrVal != null && element.childNodes().isEmpty()) {
            element.addChild(new JsoupTextNode(new TextNode("")));
            this.fakedContent = true;
        }
    }

    @Override
    public void processEnd(IElementNode element, ProcessorContext context) {
        super.processEnd(element, context);
        String valueAttr = element.getAttribute("value");
        String labelAttr = element.getAttribute("label");
        String content = this.actualOptionTextContent.toString();
        if (labelAttr == null) {
            labelAttr = content;
        }
        if (valueAttr == null) {
            valueAttr = content;
        }
        this.getElementResult().setProperty(0x200003, valueAttr);
        this.getElementResult().setProperty(0x20000A, labelAttr);
    }

    @Override
    public boolean processContent(String content, ProcessorContext context) {
        content = content.trim();
        if (this.labelAttrVal != null) {
            if (!this.labelReplacedContent) {
                this.labelReplacedContent = true;
                super.processContent(this.labelAttrVal, context);
            }
        } else {
            super.processContent(content, context);
        }
        if (!this.fakedContent) {
            this.actualOptionTextContent.append(content);
        }
        return true;
    }

    @Override
    public boolean processTagChild(ITagWorker childTagWorker, ProcessorContext context) {
        return super.processTagChild(childTagWorker, context);
    }
}

