/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j;

import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.shredzone.acme4j.toolbox.JSON;

public class Metadata {
    private final JSON meta;

    public Metadata(JSON meta) {
        this.meta = meta;
    }

    public Optional<URI> getTermsOfService() {
        return this.meta.get("termsOfService").map(JSON.Value::asURI);
    }

    public Optional<URL> getWebsite() {
        return this.meta.get("website").map(JSON.Value::asURL);
    }

    public Collection<String> getCaaIdentities() {
        return this.meta.get("caaIdentities").asArray().stream().map(JSON.Value::asString).collect(Collectors.toList());
    }

    public boolean isExternalAccountRequired() {
        return this.meta.get("externalAccountRequired").map(JSON.Value::asBoolean).orElse(false);
    }

    public boolean isAutoRenewalEnabled() {
        return this.meta.get("auto-renewal").isPresent();
    }

    public Duration getAutoRenewalMinLifetime() {
        return this.meta.getFeature("auto-renewal").map(JSON.Value::asObject).orElseGet(JSON::empty).get("min-lifetime").asDuration();
    }

    public Duration getAutoRenewalMaxDuration() {
        return this.meta.getFeature("auto-renewal").map(JSON.Value::asObject).orElseGet(JSON::empty).get("max-duration").asDuration();
    }

    public boolean isAutoRenewalGetAllowed() {
        return this.meta.getFeature("auto-renewal").optional().map(JSON.Value::asObject).orElseGet(JSON::empty).get("allow-certificate-get").optional().map(JSON.Value::asBoolean).orElse(false);
    }

    public boolean isProfileAllowed() {
        return this.meta.get("profiles").isPresent();
    }

    public boolean isProfileAllowed(String profile) {
        return this.getProfiles().contains(profile);
    }

    public Set<String> getProfiles() {
        return this.meta.get("profiles").optional().map(JSON.Value::asObject).orElseGet(JSON::empty).keySet();
    }

    public Optional<String> getProfileDescription(String profile) {
        return this.meta.get("profiles").optional().map(JSON.Value::asObject).orElseGet(JSON::empty).get(profile).optional().map(JSON.Value::asString);
    }

    public boolean isSubdomainAuthAllowed() {
        return this.meta.get("subdomainAuthAllowed").map(JSON.Value::asBoolean).orElse(false);
    }

    public JSON getJSON() {
        return this.meta;
    }
}

