/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.crypt.impl.office;

import com.healthmarketscience.jackcess.crypt.InvalidCryptoConfigurationException;
import com.healthmarketscience.jackcess.crypt.model.CTDataIntegrity;
import com.healthmarketscience.jackcess.crypt.model.CTEncryption;
import com.healthmarketscience.jackcess.crypt.model.CTKeyData;
import com.healthmarketscience.jackcess.crypt.model.CTKeyEncryptor;
import com.healthmarketscience.jackcess.crypt.model.CTKeyEncryptors;
import com.healthmarketscience.jackcess.crypt.model.cert.CTCertificateKeyEncryptor;
import com.healthmarketscience.jackcess.crypt.model.cert.STCertificateKeyEncryptorUri;
import com.healthmarketscience.jackcess.crypt.model.password.CTPasswordKeyEncryptor;
import com.healthmarketscience.jackcess.crypt.model.password.STPasswordKeyEncryptorUri;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlEncryptionParser {
    private static final Log LOG = LogFactory.getLog(XmlEncryptionParser.class);
    private static final String ENC_NS = "http://schemas.microsoft.com/office/2006/encryption";
    private static final String PWD_NS = "http://schemas.microsoft.com/office/2006/keyEncryptor/password";
    private static final String CERT_NS = "http://schemas.microsoft.com/office/2006/keyEncryptor/certificate";
    private static final Base64.Decoder B64_DEC = Base64.getDecoder();
    private static final EntityResolver IGNORING_ENTITY_RESOLVER = new EntityResolver(){

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource(new StringReader(""));
        }
    };

    private XmlEncryptionParser() {
    }

    public static final CTEncryption parseEncryptionDescriptor(byte[] xmlBytes) {
        try {
            Document doc = XmlEncryptionParser.newBuilder().parse(new ByteArrayInputStream(xmlBytes));
            Element encryptionEl = doc.getDocumentElement();
            if (!"encryption".equals(encryptionEl.getLocalName()) || !ENC_NS.equals(encryptionEl.getNamespaceURI())) {
                throw new InvalidCryptoConfigurationException("Unexpected xml config " + encryptionEl.getTagName());
            }
            return XmlEncryptionParser.parseEncryption(encryptionEl);
        }
        catch (InvalidCryptoConfigurationException ie) {
            throw ie;
        }
        catch (Exception e) {
            throw new InvalidCryptoConfigurationException("Failed parsing encryption descriptor", e);
        }
    }

    private static CTEncryption parseEncryption(Element encryptionEl) {
        CTEncryption encryption = new CTEncryption();
        encryption.setKeyData(XmlEncryptionParser.parseKeyData(XmlEncryptionParser.getElement(encryptionEl, "keyData", ENC_NS, true)));
        encryption.setDataIntegrity(XmlEncryptionParser.parseDataIntegrity(XmlEncryptionParser.getElement(encryptionEl, "dataIntegrity", ENC_NS, false)));
        encryption.setKeyEncryptors(XmlEncryptionParser.parseKeyEncryptors(XmlEncryptionParser.getElement(encryptionEl, "keyEncryptors", ENC_NS, true)));
        return encryption;
    }

    private static CTKeyData parseKeyData(Element keyDataEl) {
        CTKeyData keyData = new CTKeyData();
        keyData.setSaltSize(XmlEncryptionParser.getLongAttribute(keyDataEl, "saltSize"));
        keyData.setBlockSize(XmlEncryptionParser.getLongAttribute(keyDataEl, "blockSize"));
        keyData.setKeyBits(XmlEncryptionParser.getLongAttribute(keyDataEl, "keyBits"));
        keyData.setHashSize(XmlEncryptionParser.getLongAttribute(keyDataEl, "hashSize"));
        keyData.setCipherAlgorithm(XmlEncryptionParser.getStringAttribute(keyDataEl, "cipherAlgorithm"));
        keyData.setCipherChaining(XmlEncryptionParser.getStringAttribute(keyDataEl, "cipherChaining"));
        keyData.setHashAlgorithm(XmlEncryptionParser.getStringAttribute(keyDataEl, "hashAlgorithm"));
        keyData.setSaltValue(XmlEncryptionParser.getBase64Attribute(keyDataEl, "saltValue"));
        return keyData;
    }

    private static CTDataIntegrity parseDataIntegrity(Element dataIntegrityEl) {
        if (dataIntegrityEl == null) {
            return null;
        }
        CTDataIntegrity dataIntegrity = new CTDataIntegrity();
        dataIntegrity.setEncryptedHmacKey(XmlEncryptionParser.getBase64Attribute(dataIntegrityEl, "encryptedHmacKey"));
        dataIntegrity.setEncryptedHmacValue(XmlEncryptionParser.getBase64Attribute(dataIntegrityEl, "encryptedHmacValue"));
        return dataIntegrity;
    }

    private static CTKeyEncryptors parseKeyEncryptors(Element keyEncryptorsEl) {
        CTKeyEncryptors keyEncryptors = new CTKeyEncryptors();
        for (Element encryptor : XmlEncryptionParser.getElements(keyEncryptorsEl, "keyEncryptor", ENC_NS)) {
            keyEncryptors.getKeyEncryptor().add(XmlEncryptionParser.parseKeyEncryptor(encryptor));
        }
        return keyEncryptors;
    }

    private static CTKeyEncryptor parseKeyEncryptor(Element keyEncryptorEl) {
        CTKeyEncryptor keyEncryptor = new CTKeyEncryptor();
        String typeUri = XmlEncryptionParser.getStringAttribute(keyEncryptorEl, "uri");
        keyEncryptor.setUri(typeUri);
        Object encryptor = null;
        if (STPasswordKeyEncryptorUri.HTTP_SCHEMAS_MICROSOFT_COM_OFFICE_2006_KEY_ENCRYPTOR_PASSWORD.value().equals(typeUri)) {
            encryptor = XmlEncryptionParser.parsePasswordKeyEncryptor(keyEncryptorEl);
        } else if (STCertificateKeyEncryptorUri.HTTP_SCHEMAS_MICROSOFT_COM_OFFICE_2006_KEY_ENCRYPTOR_CERTIFICATE.value().equals(typeUri)) {
            encryptor = XmlEncryptionParser.parseCertificateKeyEncryptor(keyEncryptorEl);
        } else {
            throw XmlEncryptionParser.createException("Unexpected xml config ", typeUri, keyEncryptorEl);
        }
        keyEncryptor.setAny(encryptor);
        return keyEncryptor;
    }

    private static CTPasswordKeyEncryptor parsePasswordKeyEncryptor(Element parentEl) {
        Element pwdEncryptorEl = XmlEncryptionParser.getElement(parentEl, "encryptedKey", PWD_NS, true);
        CTPasswordKeyEncryptor pwdEncryptor = new CTPasswordKeyEncryptor();
        pwdEncryptor.setSaltSize(XmlEncryptionParser.getLongAttribute(pwdEncryptorEl, "saltSize"));
        pwdEncryptor.setBlockSize(XmlEncryptionParser.getLongAttribute(pwdEncryptorEl, "blockSize"));
        pwdEncryptor.setKeyBits(XmlEncryptionParser.getLongAttribute(pwdEncryptorEl, "keyBits"));
        pwdEncryptor.setHashSize(XmlEncryptionParser.getLongAttribute(pwdEncryptorEl, "hashSize"));
        pwdEncryptor.setCipherAlgorithm(XmlEncryptionParser.getStringAttribute(pwdEncryptorEl, "cipherAlgorithm"));
        pwdEncryptor.setCipherChaining(XmlEncryptionParser.getStringAttribute(pwdEncryptorEl, "cipherChaining"));
        pwdEncryptor.setHashAlgorithm(XmlEncryptionParser.getStringAttribute(pwdEncryptorEl, "hashAlgorithm"));
        pwdEncryptor.setSaltValue(XmlEncryptionParser.getBase64Attribute(pwdEncryptorEl, "saltValue"));
        pwdEncryptor.setSpinCount(XmlEncryptionParser.getLongAttribute(pwdEncryptorEl, "spinCount"));
        pwdEncryptor.setEncryptedVerifierHashInput(XmlEncryptionParser.getBase64Attribute(pwdEncryptorEl, "encryptedVerifierHashInput"));
        pwdEncryptor.setEncryptedVerifierHashValue(XmlEncryptionParser.getBase64Attribute(pwdEncryptorEl, "encryptedVerifierHashValue"));
        pwdEncryptor.setEncryptedKeyValue(XmlEncryptionParser.getBase64Attribute(pwdEncryptorEl, "encryptedKeyValue"));
        return pwdEncryptor;
    }

    private static CTCertificateKeyEncryptor parseCertificateKeyEncryptor(Element parentEl) {
        Element certEncryptorEl = XmlEncryptionParser.getElement(parentEl, "encryptedKey", CERT_NS, true);
        CTCertificateKeyEncryptor certEncryptor = new CTCertificateKeyEncryptor();
        certEncryptor.setEncryptedKeyValue(XmlEncryptionParser.getBase64Attribute(certEncryptorEl, "encryptedKeyValue"));
        certEncryptor.setX509Certificate(XmlEncryptionParser.getBase64Attribute(certEncryptorEl, "x509Certificate"));
        certEncryptor.setCertVerifier(XmlEncryptionParser.getBase64Attribute(certEncryptorEl, "certVerifier"));
        return certEncryptor;
    }

    private static Element getElement(Element parentEl, String localName, String ns, boolean required) {
        NodeList list = parentEl.getElementsByTagNameNS(ns, localName);
        if (list != null && list.getLength() > 0) {
            return (Element)list.item(0);
        }
        if (!required) {
            return null;
        }
        throw XmlEncryptionParser.createException(localName, parentEl);
    }

    private static List<Element> getElements(Element parentEl, String localName, String ns) {
        NodeList list = parentEl.getElementsByTagNameNS(ns, localName);
        if (list == null || list.getLength() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Element> els = new ArrayList<Element>();
        for (int i = 0; i < list.getLength(); ++i) {
            els.add((Element)list.item(i));
        }
        return els;
    }

    private static long getLongAttribute(Element el, String localName) {
        String attrValue = StringUtils.trimToNull(el.getAttribute(localName));
        if (attrValue == null) {
            throw XmlEncryptionParser.createException(localName, el);
        }
        return Long.parseLong(attrValue);
    }

    private static String getStringAttribute(Element el, String localName) {
        String attrValue = StringUtils.trimToNull(el.getAttribute(localName));
        if (attrValue == null) {
            throw XmlEncryptionParser.createException(localName, el);
        }
        return attrValue;
    }

    private static byte[] getBase64Attribute(Element el, String localName) {
        String attrValue = StringUtils.trimToNull(el.getAttribute(localName));
        if (attrValue == null) {
            throw XmlEncryptionParser.createException(localName, el);
        }
        return B64_DEC.decode(attrValue);
    }

    private static DocumentBuilder newBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        XmlEncryptionParser.maybeSetAttribute(factory, "http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        XmlEncryptionParser.maybeSetAttribute(factory, "http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        factory.setXIncludeAware(false);
        factory.setExpandEntityReferences(false);
        factory.setIgnoringComments(true);
        factory.setCoalescing(true);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(IGNORING_ENTITY_RESOLVER);
        return builder;
    }

    private static void maybeSetAttribute(DocumentBuilderFactory factory, String propName, String propValue) {
        try {
            factory.setAttribute(propName, propValue);
        }
        catch (IllegalArgumentException ie) {
            LOG.warn((Object)("Xml parser does not support property " + propName));
        }
    }

    private static InvalidCryptoConfigurationException createException(String localName, Element el) {
        return XmlEncryptionParser.createException("Could not find xml config ", localName, el);
    }

    private static InvalidCryptoConfigurationException createException(String context, String localName, Element el) {
        return new InvalidCryptoConfigurationException(context + localName + " under " + el.getTagName());
    }
}

