/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.List;
import java.util.Objects;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.query.PositionBound;
import org.apache.kafka.streams.query.Query;
import org.apache.kafka.streams.query.QueryConfig;
import org.apache.kafka.streams.query.QueryResult;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.VersionedBytesStore;
import org.apache.kafka.streams.state.VersionedKeyValueStore;
import org.apache.kafka.streams.state.VersionedRecord;
import org.apache.kafka.streams.state.internals.ValueAndTimestampSerde;

public class VersionedKeyValueToBytesStoreAdapter
implements VersionedBytesStore {
    private static final Serde<ValueAndTimestamp<byte[]>> VALUE_AND_TIMESTAMP_SERDE = new ValueAndTimestampSerde<byte[]>(new Serdes.ByteArraySerde());
    private static final Serializer<ValueAndTimestamp<byte[]>> VALUE_AND_TIMESTAMP_SERIALIZER = VALUE_AND_TIMESTAMP_SERDE.serializer();
    final VersionedKeyValueStore<Bytes, byte[]> inner;

    public VersionedKeyValueToBytesStoreAdapter(VersionedKeyValueStore<Bytes, byte[]> inner) {
        this.inner = Objects.requireNonNull(inner);
    }

    @Override
    public long put(Bytes key, byte[] value, long timestamp) {
        return this.inner.put(key, value, timestamp);
    }

    @Override
    public byte[] get(Bytes key) {
        VersionedRecord<byte[]> versionedRecord = this.inner.get(key);
        return VersionedKeyValueToBytesStoreAdapter.serializeAsBytes(versionedRecord);
    }

    @Override
    public byte[] get(Bytes key, long asOfTimestamp) {
        VersionedRecord<byte[]> versionedRecord = this.inner.get(key, asOfTimestamp);
        return VersionedKeyValueToBytesStoreAdapter.serializeAsBytes(versionedRecord);
    }

    @Override
    public byte[] delete(Bytes key, long timestamp) {
        VersionedRecord<byte[]> versionedRecord = this.inner.delete(key, timestamp);
        return VersionedKeyValueToBytesStoreAdapter.serializeAsBytes(versionedRecord);
    }

    @Override
    public String name() {
        return this.inner.name();
    }

    @Override
    @Deprecated
    public void init(ProcessorContext context, StateStore root) {
        this.inner.init(context, root);
    }

    @Override
    public void init(StateStoreContext context, StateStore root) {
        this.inner.init(context, root);
    }

    @Override
    public void flush() {
        this.inner.flush();
    }

    @Override
    public void close() {
        this.inner.close();
    }

    @Override
    public boolean persistent() {
        return this.inner.persistent();
    }

    @Override
    public boolean isOpen() {
        return this.inner.isOpen();
    }

    @Override
    public <R> QueryResult<R> query(Query<R> query, PositionBound positionBound, QueryConfig config) {
        return this.inner.query(query, positionBound, config);
    }

    @Override
    public Position getPosition() {
        return this.inner.getPosition();
    }

    @Override
    public void put(Bytes key, byte[] rawValueAndTimestamp) {
        throw new UnsupportedOperationException("Versioned key-value stores should use put(key, value, timestamp) instead");
    }

    @Override
    public byte[] putIfAbsent(Bytes key, byte[] value) {
        throw new UnsupportedOperationException("Versioned key-value stores do not support putIfAbsent(key, value)");
    }

    @Override
    public void putAll(List<KeyValue<Bytes, byte[]>> entries) {
        throw new UnsupportedOperationException("Versioned key-value stores do not support putAll(entries)");
    }

    @Override
    public byte[] delete(Bytes key) {
        throw new UnsupportedOperationException("Versioned key-value stores do not support delete(key). Use delete(key, timestamp) instead.");
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> range(Bytes from, Bytes to) {
        throw new UnsupportedOperationException("Versioned key-value stores do not support range(from, to)");
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> reverseRange(Bytes from, Bytes to) {
        throw new UnsupportedOperationException("Versioned key-value stores do not support reverseRange(from, to)");
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> all() {
        throw new UnsupportedOperationException("Versioned key-value stores do not support all()");
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> reverseAll() {
        throw new UnsupportedOperationException("Versioned key-value stores do not support reverseAll()");
    }

    @Override
    public <PS extends Serializer<P>, P> KeyValueIterator<Bytes, byte[]> prefixScan(P prefix, PS prefixKeySerializer) {
        throw new UnsupportedOperationException("Versioned key-value stores do not support prefixScan(prefix, prefixKeySerializer)");
    }

    @Override
    public long approximateNumEntries() {
        throw new UnsupportedOperationException("Versioned key-value stores do not support approximateNumEntries()");
    }

    private static byte[] serializeAsBytes(VersionedRecord<byte[]> versionedRecord) {
        if (versionedRecord == null) {
            return null;
        }
        return VALUE_AND_TIMESTAMP_SERIALIZER.serialize(null, ValueAndTimestamp.make(versionedRecord.value(), versionedRecord.timestamp()));
    }
}

