/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.internals.ChangelogRecordDeserializationHelper;
import org.apache.kafka.streams.processor.internals.ProcessorContextUtils;
import org.apache.kafka.streams.processor.internals.StoreToProcessorContextAdapter;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.TaskMetrics;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.query.PositionBound;
import org.apache.kafka.streams.query.Query;
import org.apache.kafka.streams.query.QueryConfig;
import org.apache.kafka.streams.query.QueryResult;
import org.apache.kafka.streams.query.ResultOrder;
import org.apache.kafka.streams.state.VersionedKeyValueStore;
import org.apache.kafka.streams.state.VersionedRecord;
import org.apache.kafka.streams.state.VersionedRecordIterator;
import org.apache.kafka.streams.state.internals.LogicalKeyValueSegment;
import org.apache.kafka.streams.state.internals.LogicalKeyValueSegments;
import org.apache.kafka.streams.state.internals.LogicalSegmentIterator;
import org.apache.kafka.streams.state.internals.OffsetCheckpoint;
import org.apache.kafka.streams.state.internals.RocksDBVersionedStoreRestoreWriteBuffer;
import org.apache.kafka.streams.state.internals.RocksDBVersionedStoreSegmentValueFormatter;
import org.apache.kafka.streams.state.internals.StoreQueryUtils;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetricsRecorder;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBVersionedStore
implements VersionedKeyValueStore<Bytes, byte[]> {
    private static final Logger LOG = LoggerFactory.getLogger(RocksDBVersionedStore.class);
    private static final long SENTINEL_TIMESTAMP = Long.MIN_VALUE;
    private final String name;
    private final long historyRetention;
    private final long gracePeriod;
    private final RocksDBMetricsRecorder metricsRecorder;
    private final LogicalKeyValueSegment latestValueStore;
    private final LogicalKeyValueSegments segmentStores;
    private final RocksDBVersionedStoreClient versionedStoreClient;
    private final RocksDBVersionedStoreRestoreWriteBuffer restoreWriteBuffer;
    private ProcessorContext context;
    private StateStoreContext stateStoreContext;
    private Sensor expiredRecordSensor;
    private long observedStreamTime = -1L;
    private boolean consistencyEnabled = false;
    private Position position;
    private OffsetCheckpoint positionCheckpoint;
    private volatile boolean open;

    RocksDBVersionedStore(String name, String metricsScope, long historyRetention, long segmentInterval) {
        this.name = name;
        this.historyRetention = historyRetention;
        this.gracePeriod = historyRetention;
        this.metricsRecorder = new RocksDBMetricsRecorder(metricsScope, name);
        this.segmentStores = new LogicalKeyValueSegments(name, "rocksdb", historyRetention, segmentInterval, this.metricsRecorder);
        this.latestValueStore = this.segmentStores.createReservedSegment(-1L, RocksDBVersionedStore.latestValueStoreName(name));
        this.versionedStoreClient = new RocksDBVersionedStoreClient();
        this.restoreWriteBuffer = new RocksDBVersionedStoreRestoreWriteBuffer(this.versionedStoreClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long put(Bytes key, byte[] value, long timestamp) {
        Objects.requireNonNull(key, "key cannot be null");
        this.validateStoreOpen();
        Position position = this.position;
        synchronized (position) {
            if (timestamp < this.observedStreamTime - this.gracePeriod) {
                this.expiredRecordSensor.record(1.0, this.context.currentSystemTimeMs());
                LOG.warn("Skipping record for expired put.");
                StoreQueryUtils.updatePosition(this.position, this.stateStoreContext);
                return Long.MIN_VALUE;
            }
            this.observedStreamTime = Math.max(this.observedStreamTime, timestamp);
            long foundTs = this.doPut(this.versionedStoreClient, this.observedStreamTime, key, value, timestamp);
            StoreQueryUtils.updatePosition(this.position, this.stateStoreContext);
            return foundTs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VersionedRecord<byte[]> delete(Bytes key, long timestamp) {
        Objects.requireNonNull(key, "key cannot be null");
        this.validateStoreOpen();
        Position position = this.position;
        synchronized (position) {
            if (timestamp < this.observedStreamTime - this.gracePeriod) {
                this.expiredRecordSensor.record(1.0, this.context.currentSystemTimeMs());
                LOG.warn("Skipping record for expired delete.");
                return null;
            }
            VersionedRecord<byte[]> existingRecord = this.get(key, timestamp);
            this.observedStreamTime = Math.max(this.observedStreamTime, timestamp);
            this.doPut(this.versionedStoreClient, this.observedStreamTime, key, null, timestamp);
            StoreQueryUtils.updatePosition(this.position, this.stateStoreContext);
            return existingRecord;
        }
    }

    @Override
    public VersionedRecord<byte[]> get(Bytes key) {
        Objects.requireNonNull(key, "key cannot be null");
        this.validateStoreOpen();
        byte[] rawLatestValueAndTimestamp = this.latestValueStore.get(key);
        if (rawLatestValueAndTimestamp != null) {
            return new VersionedRecord<byte[]>(LatestValueFormatter.getValue(rawLatestValueAndTimestamp), LatestValueFormatter.getTimestamp(rawLatestValueAndTimestamp));
        }
        return null;
    }

    @Override
    public VersionedRecord<byte[]> get(Bytes key, long asOfTimestamp) {
        long latestTimestamp;
        Objects.requireNonNull(key, "key cannot be null");
        this.validateStoreOpen();
        if (asOfTimestamp < this.observedStreamTime - this.historyRetention) {
            long latestTimestamp2;
            byte[] rawLatestValueAndTimestamp = this.latestValueStore.get(key);
            if (rawLatestValueAndTimestamp != null && (latestTimestamp2 = LatestValueFormatter.getTimestamp(rawLatestValueAndTimestamp)) <= asOfTimestamp) {
                return new VersionedRecord<byte[]>(LatestValueFormatter.getValue(rawLatestValueAndTimestamp), latestTimestamp2);
            }
            LOG.warn("Returning null for expired get.");
            return null;
        }
        byte[] rawLatestValueAndTimestamp = this.latestValueStore.get(key);
        if (rawLatestValueAndTimestamp != null && (latestTimestamp = LatestValueFormatter.getTimestamp(rawLatestValueAndTimestamp)) <= asOfTimestamp) {
            return new VersionedRecord<byte[]>(LatestValueFormatter.getValue(rawLatestValueAndTimestamp), latestTimestamp);
        }
        List segments = this.segmentStores.segments(asOfTimestamp, Long.MAX_VALUE, false);
        for (LogicalKeyValueSegment segment : segments) {
            byte[] rawSegmentValue = segment.get(key);
            if (rawSegmentValue == null) continue;
            long nextTs = RocksDBVersionedStoreSegmentValueFormatter.getNextTimestamp(rawSegmentValue);
            if (nextTs <= asOfTimestamp) {
                return null;
            }
            if (RocksDBVersionedStoreSegmentValueFormatter.getMinTimestamp(rawSegmentValue) > asOfTimestamp) continue;
            RocksDBVersionedStoreSegmentValueFormatter.SegmentValue.SegmentSearchResult searchResult = RocksDBVersionedStoreSegmentValueFormatter.deserialize(rawSegmentValue).find(asOfTimestamp, true);
            if (searchResult.value() != null) {
                return new VersionedRecord<byte[]>(searchResult.value(), searchResult.validFrom(), searchResult.validTo());
            }
            return null;
        }
        return null;
    }

    VersionedRecordIterator<byte[]> get(Bytes key, long fromTimestamp, long toTimestamp, ResultOrder order) {
        this.validateStoreOpen();
        if (toTimestamp < this.observedStreamTime - this.historyRetention) {
            return new LogicalSegmentIterator(Collections.singletonList(this.latestValueStore).listIterator(), key, fromTimestamp, toTimestamp, order);
        }
        ArrayList<LogicalKeyValueSegment> segments = new ArrayList<LogicalKeyValueSegment>();
        if (order.equals((Object)ResultOrder.ASCENDING)) {
            segments.addAll(this.segmentStores.segments(Long.MIN_VALUE, toTimestamp, true));
            segments.add(this.latestValueStore);
        } else {
            segments.add(this.latestValueStore);
            segments.addAll(this.segmentStores.segments(Long.MIN_VALUE, toTimestamp, false));
        }
        return new LogicalSegmentIterator(segments.listIterator(), key, fromTimestamp, toTimestamp, order);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void flush() {
        this.segmentStores.flush();
    }

    @Override
    public void close() {
        this.open = false;
        this.segmentStores.close();
    }

    @Override
    public <R> QueryResult<R> query(Query<R> query, PositionBound positionBound, QueryConfig config) {
        return StoreQueryUtils.handleBasicQueries(query, positionBound, config, this, this.position, this.stateStoreContext);
    }

    @Override
    public boolean persistent() {
        return true;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    @Deprecated
    public void init(ProcessorContext context, StateStore root) {
        this.context = context;
        StreamsMetricsImpl metrics = ProcessorContextUtils.getMetricsImpl(context);
        String threadId = Thread.currentThread().getName();
        String taskName = context.taskId().toString();
        this.expiredRecordSensor = TaskMetrics.droppedRecordsSensor(threadId, taskName, metrics);
        this.metricsRecorder.init(ProcessorContextUtils.getMetricsImpl(context), context.taskId());
        File positionCheckpointFile = new File(context.stateDir(), this.name() + ".position");
        this.positionCheckpoint = new OffsetCheckpoint(positionCheckpointFile);
        this.position = StoreQueryUtils.readPositionFromCheckpoint(this.positionCheckpoint);
        this.segmentStores.setPosition(this.position);
        this.segmentStores.openExisting(context, this.observedStreamTime);
        this.stateStoreContext.register(root, this::restoreBatch, () -> StoreQueryUtils.checkpointPosition(this.positionCheckpoint, this.position));
        this.open = true;
        this.consistencyEnabled = StreamsConfig.InternalConfig.getBoolean(context.appConfigs(), "__iq.consistency.offset.vector.enabled__", false);
    }

    @Override
    public void init(StateStoreContext context, StateStore root) {
        this.stateStoreContext = context;
        this.init(StoreToProcessorContextAdapter.adapt(context), root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreBatch(Collection<ConsumerRecord<byte[], byte[]>> records) {
        long endOfBatchStreamTime = this.observedStreamTime;
        for (ConsumerRecord<byte[], byte[]> record : records) {
            endOfBatchStreamTime = Math.max(endOfBatchStreamTime, record.timestamp());
        }
        VersionedStoreClient<?> restoreClient = this.restoreWriteBuffer.getClient();
        Position position = this.position;
        synchronized (position) {
            for (ConsumerRecord<byte[], byte[]> record : records) {
                if (record.timestamp() < this.observedStreamTime - this.gracePeriod) continue;
                this.observedStreamTime = Math.max(this.observedStreamTime, record.timestamp());
                ChangelogRecordDeserializationHelper.applyChecksAndUpdatePosition(record, this.consistencyEnabled, this.position);
                this.doPut(restoreClient, endOfBatchStreamTime, new Bytes(record.key()), record.value(), record.timestamp());
            }
            try {
                this.restoreWriteBuffer.flush();
            }
            catch (RocksDBException e) {
                throw new ProcessorStateException("Error restoring batch to store " + this.name, e);
            }
        }
    }

    private void validateStoreOpen() {
        if (!this.open) {
            throw new InvalidStateStoreException("Store " + this.name + " is currently closed");
        }
    }

    private <T extends VersionedStoreSegment> long doPut(VersionedStoreClient<T> versionedStoreClient, long observedStreamTime, Bytes key, byte[] value, long timestamp) {
        this.segmentStores.cleanupExpiredSegments(observedStreamTime);
        PutStatus status = this.maybePutToLatestValueStore(versionedStoreClient, observedStreamTime, key, value, timestamp);
        if (status.isComplete) {
            return status.foundTs == Long.MIN_VALUE ? -1L : status.foundTs;
        }
        long foundTs = status.foundTs;
        status = this.maybePutToSegments(versionedStoreClient, observedStreamTime, key, value, timestamp, foundTs);
        if (status.isComplete) {
            return status.foundTs == Long.MIN_VALUE ? -1L : status.foundTs;
        }
        foundTs = status.foundTs;
        return (foundTs = this.finishPut(versionedStoreClient, observedStreamTime, key, value, timestamp, foundTs)) == Long.MIN_VALUE ? -1L : foundTs;
    }

    private <T extends VersionedStoreSegment> PutStatus maybePutToLatestValueStore(VersionedStoreClient<T> versionedStoreClient, long observedStreamTime, Bytes key, byte[] value, long timestamp) {
        long foundTs = Long.MIN_VALUE;
        byte[] rawLatestValueAndTimestamp = versionedStoreClient.getLatestValue(key);
        if (rawLatestValueAndTimestamp != null) {
            long latestValueStoreTimestamp = LatestValueFormatter.getTimestamp(rawLatestValueAndTimestamp);
            if (timestamp >= latestValueStoreTimestamp) {
                long segmentId;
                T segment;
                if (timestamp > latestValueStoreTimestamp && (segment = versionedStoreClient.getOrCreateSegmentIfLive(segmentId = versionedStoreClient.segmentIdForTimestamp(timestamp), this.context, observedStreamTime)) != null) {
                    byte[] rawValueToMove = LatestValueFormatter.getValue(rawLatestValueAndTimestamp);
                    byte[] rawSegmentValue = segment.get(key);
                    if (rawSegmentValue == null) {
                        segment.put(key, RocksDBVersionedStoreSegmentValueFormatter.newSegmentValueWithRecord(rawValueToMove, latestValueStoreTimestamp, timestamp).serialize());
                    } else {
                        RocksDBVersionedStoreSegmentValueFormatter.SegmentValue segmentValue = RocksDBVersionedStoreSegmentValueFormatter.deserialize(rawSegmentValue);
                        segmentValue.insertAsLatest(latestValueStoreTimestamp, timestamp, rawValueToMove);
                        segment.put(key, segmentValue.serialize());
                    }
                }
                if (value != null) {
                    versionedStoreClient.putLatestValue(key, LatestValueFormatter.from(value, timestamp));
                } else {
                    versionedStoreClient.deleteLatestValue(key);
                }
                return new PutStatus(true, foundTs);
            }
            foundTs = latestValueStoreTimestamp;
        }
        return new PutStatus(false, foundTs);
    }

    private <T extends VersionedStoreSegment> PutStatus maybePutToSegments(VersionedStoreClient<T> versionedStoreClient, long observedStreamTime, Bytes key, byte[] value, long timestamp, long prevFoundTs) {
        long foundTs = prevFoundTs;
        List<T> segments = versionedStoreClient.getReverseSegments(timestamp);
        for (VersionedStoreSegment segment : segments) {
            byte[] rawSegmentValue = segment.get(key);
            if (rawSegmentValue == null) continue;
            long foundNextTs = RocksDBVersionedStoreSegmentValueFormatter.getNextTimestamp(rawSegmentValue);
            if (foundNextTs <= timestamp) {
                return new PutStatus(false, foundTs);
            }
            long foundMinTs = RocksDBVersionedStoreSegmentValueFormatter.getMinTimestamp(rawSegmentValue);
            if (foundMinTs <= timestamp) {
                foundTs = this.putToSegment(versionedStoreClient, observedStreamTime, segment, rawSegmentValue, key, value, timestamp);
                return new PutStatus(true, foundTs);
            }
            if (foundMinTs < observedStreamTime - this.historyRetention) {
                return new PutStatus(true, Long.MIN_VALUE);
            }
            foundTs = foundMinTs;
        }
        return new PutStatus(false, foundTs);
    }

    private <T extends VersionedStoreSegment> long putToSegment(VersionedStoreClient<T> versionedStoreClient, long observedStreamTime, T segment, byte[] rawSegmentValue, Bytes key, byte[] value, long timestamp) {
        long segmentIdForTimestamp = versionedStoreClient.segmentIdForTimestamp(timestamp);
        boolean writeToOlderSegmentMaybeNeeded = segmentIdForTimestamp != segment.id();
        RocksDBVersionedStoreSegmentValueFormatter.SegmentValue segmentValue = RocksDBVersionedStoreSegmentValueFormatter.deserialize(rawSegmentValue);
        RocksDBVersionedStoreSegmentValueFormatter.SegmentValue.SegmentSearchResult searchResult = segmentValue.find(timestamp, writeToOlderSegmentMaybeNeeded);
        if (searchResult.validFrom() == timestamp) {
            segmentValue.updateRecord(timestamp, value, searchResult.index());
            segment.put(key, segmentValue.serialize());
            return searchResult.validTo();
        }
        if (writeToOlderSegmentMaybeNeeded) {
            T olderSegment = versionedStoreClient.getOrCreateSegmentIfLive(segmentIdForTimestamp, this.context, observedStreamTime);
            if (olderSegment != null) {
                byte[] rawOlderSegmentValue = olderSegment.get(key);
                if (rawOlderSegmentValue == null) {
                    olderSegment.put(key, RocksDBVersionedStoreSegmentValueFormatter.newSegmentValueWithRecord(searchResult.value(), searchResult.validFrom(), timestamp).serialize());
                } else {
                    RocksDBVersionedStoreSegmentValueFormatter.SegmentValue olderSegmentValue = RocksDBVersionedStoreSegmentValueFormatter.deserialize(rawOlderSegmentValue);
                    olderSegmentValue.insertAsLatest(searchResult.validFrom(), timestamp, searchResult.value());
                    olderSegment.put(key, olderSegmentValue.serialize());
                }
            }
            segmentValue.updateRecord(timestamp, value, searchResult.index());
            segment.put(key, segmentValue.serialize());
            return searchResult.validTo();
        }
        segmentValue.insert(timestamp, value, searchResult.index());
        segment.put(key, segmentValue.serialize());
        return searchResult.validTo();
    }

    private <T extends VersionedStoreSegment> long finishPut(VersionedStoreClient<T> versionedStoreClient, long observedStreamTime, Bytes key, byte[] value, long timestamp, long foundTs) {
        if (foundTs == Long.MIN_VALUE) {
            if (value != null) {
                versionedStoreClient.putLatestValue(key, LatestValueFormatter.from(value, timestamp));
            } else {
                T segment = versionedStoreClient.getOrCreateSegmentIfLive(versionedStoreClient.segmentIdForTimestamp(timestamp), this.context, observedStreamTime);
                if (segment == null) {
                    return Long.MIN_VALUE;
                }
                byte[] rawSegmentValue = segment.get(key);
                if (rawSegmentValue == null) {
                    segment.put(key, RocksDBVersionedStoreSegmentValueFormatter.newSegmentValueWithRecord(null, timestamp, timestamp).serialize());
                } else {
                    if (RocksDBVersionedStoreSegmentValueFormatter.getNextTimestamp(rawSegmentValue) == timestamp) {
                        return foundTs;
                    }
                    RocksDBVersionedStoreSegmentValueFormatter.SegmentValue segmentValue = RocksDBVersionedStoreSegmentValueFormatter.deserialize(rawSegmentValue);
                    segmentValue.insertAsLatest(RocksDBVersionedStoreSegmentValueFormatter.getNextTimestamp(rawSegmentValue), timestamp, null);
                    segment.put(key, segmentValue.serialize());
                }
            }
        } else {
            T segment = versionedStoreClient.getOrCreateSegmentIfLive(versionedStoreClient.segmentIdForTimestamp(foundTs), this.context, observedStreamTime);
            if (segment == null) {
                return Long.MIN_VALUE;
            }
            byte[] rawSegmentValue = segment.get(key);
            if (rawSegmentValue == null) {
                segment.put(key, RocksDBVersionedStoreSegmentValueFormatter.newSegmentValueWithRecord(value, timestamp, foundTs).serialize());
            } else {
                long foundNextTs = RocksDBVersionedStoreSegmentValueFormatter.getNextTimestamp(rawSegmentValue);
                if (foundNextTs <= timestamp) {
                    RocksDBVersionedStoreSegmentValueFormatter.SegmentValue segmentValue = RocksDBVersionedStoreSegmentValueFormatter.deserialize(rawSegmentValue);
                    segmentValue.insertAsLatest(timestamp, foundTs, value);
                    segment.put(key, segmentValue.serialize());
                } else {
                    RocksDBVersionedStoreSegmentValueFormatter.SegmentValue segmentValue = RocksDBVersionedStoreSegmentValueFormatter.deserialize(rawSegmentValue);
                    segmentValue.insertAsEarliest(timestamp, value);
                    segment.put(key, segmentValue.serialize());
                }
            }
        }
        return foundTs;
    }

    private static String latestValueStoreName(String storeName) {
        return storeName + ".latestValues";
    }

    static final class LatestValueFormatter {
        private static final int TIMESTAMP_SIZE = 8;

        LatestValueFormatter() {
        }

        static long getTimestamp(byte[] rawLatestValueAndTimestamp) {
            return ByteBuffer.wrap(rawLatestValueAndTimestamp).getLong();
        }

        static byte[] getValue(byte[] rawLatestValueAndTimestamp) {
            byte[] rawValue = new byte[rawLatestValueAndTimestamp.length - 8];
            System.arraycopy(rawLatestValueAndTimestamp, 8, rawValue, 0, rawValue.length);
            return rawValue;
        }

        static byte[] from(byte[] rawValue, long timestamp) {
            if (rawValue == null) {
                throw new IllegalStateException("Cannot store tombstone in latest value");
            }
            return ByteBuffer.allocate(8 + rawValue.length).putLong(timestamp).put(rawValue).array();
        }
    }

    private static class PutStatus {
        final boolean isComplete;
        final long foundTs;

        PutStatus(boolean isComplete, long foundTs) {
            this.isComplete = isComplete;
            this.foundTs = foundTs;
        }
    }

    class RocksDBVersionedStoreClient
    implements VersionedStoreClient<LogicalKeyValueSegment> {
        RocksDBVersionedStoreClient() {
        }

        @Override
        public byte[] getLatestValue(Bytes key) {
            return RocksDBVersionedStore.this.latestValueStore.get(key);
        }

        @Override
        public void putLatestValue(Bytes key, byte[] value) {
            RocksDBVersionedStore.this.latestValueStore.put(key, value);
        }

        @Override
        public void deleteLatestValue(Bytes key) {
            RocksDBVersionedStore.this.latestValueStore.delete(key);
        }

        @Override
        public LogicalKeyValueSegment getOrCreateSegmentIfLive(long segmentId, ProcessorContext context, long streamTime) {
            return (LogicalKeyValueSegment)RocksDBVersionedStore.this.segmentStores.getOrCreateSegmentIfLive(segmentId, context, streamTime);
        }

        @Override
        public List<LogicalKeyValueSegment> getReverseSegments(long timestampFrom) {
            return RocksDBVersionedStore.this.segmentStores.segments(timestampFrom, Long.MAX_VALUE, false);
        }

        @Override
        public long segmentIdForTimestamp(long timestamp) {
            return RocksDBVersionedStore.this.segmentStores.segmentId(timestamp);
        }

        public void addToLatestValueBatch(KeyValue<byte[], byte[]> record, WriteBatch batch) throws RocksDBException {
            RocksDBVersionedStore.this.latestValueStore.addToBatch(record, batch);
        }

        public void writeLatestValues(WriteBatch batch) throws RocksDBException {
            RocksDBVersionedStore.this.latestValueStore.write(batch);
        }
    }

    static interface VersionedStoreClient<T extends VersionedStoreSegment> {
        public byte[] getLatestValue(Bytes var1);

        public void putLatestValue(Bytes var1, byte[] var2);

        public void deleteLatestValue(Bytes var1);

        public T getOrCreateSegmentIfLive(long var1, ProcessorContext var3, long var4);

        public List<T> getReverseSegments(long var1);

        public long segmentIdForTimestamp(long var1);
    }

    static interface VersionedStoreSegment {
        public long id();

        public void put(Bytes var1, byte[] var2);

        public byte[] get(Bytes var1);
    }
}

