/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.internals.MeteredIterator;

class MeteredWindowedKeyValueIterator<K, V>
implements KeyValueIterator<Windowed<K>, V>,
MeteredIterator {
    private final KeyValueIterator<Windowed<Bytes>, byte[]> iter;
    private final Sensor operationSensor;
    private final Sensor iteratorSensor;
    private final StreamsMetrics metrics;
    private final Function<byte[], K> deserializeKey;
    private final Function<byte[], V> deserializeValue;
    private final long startNs;
    private final long startTimestampMs;
    private final Time time;
    private final LongAdder numOpenIterators;
    private final Set<MeteredIterator> openIterators;

    MeteredWindowedKeyValueIterator(KeyValueIterator<Windowed<Bytes>, byte[]> iter, Sensor operationSensor, Sensor iteratorSensor, StreamsMetrics metrics, Function<byte[], K> deserializeKey, Function<byte[], V> deserializeValue, Time time, LongAdder numOpenIterators, Set<MeteredIterator> openIterators) {
        this.iter = iter;
        this.operationSensor = operationSensor;
        this.iteratorSensor = iteratorSensor;
        this.metrics = metrics;
        this.deserializeKey = deserializeKey;
        this.deserializeValue = deserializeValue;
        this.startNs = time.nanoseconds();
        this.startTimestampMs = time.milliseconds();
        this.time = time;
        this.numOpenIterators = numOpenIterators;
        this.openIterators = openIterators;
        numOpenIterators.increment();
        openIterators.add(this);
    }

    @Override
    public long startTimestamp() {
        return this.startTimestampMs;
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public KeyValue<Windowed<K>, V> next() {
        KeyValue next = (KeyValue)this.iter.next();
        return KeyValue.pair(this.windowedKey((Windowed)next.key), this.deserializeValue.apply((byte[])next.value));
    }

    private Windowed<K> windowedKey(Windowed<Bytes> bytesKey) {
        K key = this.deserializeKey.apply(bytesKey.key().get());
        return new Windowed<K>(key, bytesKey.window());
    }

    @Override
    public void close() {
        try {
            this.iter.close();
        }
        finally {
            long duration = this.time.nanoseconds() - this.startNs;
            this.operationSensor.record(duration);
            this.iteratorSensor.record(duration);
            this.numOpenIterators.decrement();
            this.openIterators.remove(this);
        }
    }

    @Override
    public Windowed<K> peekNextKey() {
        return this.windowedKey(this.iter.peekNextKey());
    }
}

