/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Comparator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.LongAdder;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.WrappingNullableUtils;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorContextUtils;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.query.FailureReason;
import org.apache.kafka.streams.query.PositionBound;
import org.apache.kafka.streams.query.Query;
import org.apache.kafka.streams.query.QueryConfig;
import org.apache.kafka.streams.query.QueryResult;
import org.apache.kafka.streams.query.WindowRangeQuery;
import org.apache.kafka.streams.query.internals.InternalQueryResultUtil;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.CacheFlushListener;
import org.apache.kafka.streams.state.internals.CachedStateStore;
import org.apache.kafka.streams.state.internals.MeteredIterator;
import org.apache.kafka.streams.state.internals.MeteredWindowedKeyValueIterator;
import org.apache.kafka.streams.state.internals.SessionKeySchema;
import org.apache.kafka.streams.state.internals.StoreQueryUtils;
import org.apache.kafka.streams.state.internals.StoreSerdeInitializer;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.apache.kafka.streams.state.internals.metrics.StateStoreMetrics;

public class MeteredSessionStore<K, V>
extends WrappedStateStore<SessionStore<Bytes, byte[]>, Windowed<K>, V>
implements SessionStore<K, V> {
    private final String metricsScope;
    private final Serde<K> keySerde;
    private final Serde<V> valueSerde;
    private final Time time;
    private StateSerdes<K, V> serdes;
    private StreamsMetricsImpl streamsMetrics;
    private Sensor putSensor;
    private Sensor fetchSensor;
    private Sensor flushSensor;
    private Sensor removeSensor;
    private Sensor e2eLatencySensor;
    private Sensor iteratorDurationSensor;
    private InternalProcessorContext<?, ?> context;
    private TaskId taskId;
    private LongAdder numOpenIterators = new LongAdder();
    private final NavigableSet<MeteredIterator> openIterators = new ConcurrentSkipListSet<MeteredIterator>(Comparator.comparingLong(MeteredIterator::startTimestamp));
    private final Map<Class, StoreQueryUtils.QueryHandler> queryHandlers = Utils.mkMap(Utils.mkEntry(WindowRangeQuery.class, (query, positionBound, config, store) -> this.runRangeQuery(query, positionBound, config)));

    MeteredSessionStore(SessionStore<Bytes, byte[]> inner, String metricsScope, Serde<K> keySerde, Serde<V> valueSerde, Time time) {
        super(inner);
        this.metricsScope = metricsScope;
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
        this.time = time;
    }

    @Override
    @Deprecated
    public void init(ProcessorContext context, StateStore root) {
        this.context = context instanceof InternalProcessorContext ? (InternalProcessorContext)context : null;
        this.taskId = context.taskId();
        this.initStoreSerde(context);
        this.streamsMetrics = (StreamsMetricsImpl)context.metrics();
        this.registerMetrics();
        Sensor restoreSensor = StateStoreMetrics.restoreSensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        StreamsMetricsImpl.maybeMeasureLatency(() -> super.init(context, root), this.time, restoreSensor);
    }

    @Override
    public void init(StateStoreContext context, StateStore root) {
        this.context = context instanceof InternalProcessorContext ? (InternalProcessorContext)context : null;
        this.taskId = context.taskId();
        this.initStoreSerde(context);
        this.streamsMetrics = (StreamsMetricsImpl)context.metrics();
        this.registerMetrics();
        Sensor restoreSensor = StateStoreMetrics.restoreSensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        StreamsMetricsImpl.maybeMeasureLatency(() -> super.init(context, root), this.time, restoreSensor);
    }

    private void registerMetrics() {
        this.putSensor = StateStoreMetrics.putSensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        this.fetchSensor = StateStoreMetrics.fetchSensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        this.flushSensor = StateStoreMetrics.flushSensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        this.removeSensor = StateStoreMetrics.removeSensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        this.e2eLatencySensor = StateStoreMetrics.e2ELatencySensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        this.iteratorDurationSensor = StateStoreMetrics.iteratorDurationSensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        StateStoreMetrics.addNumOpenIteratorsGauge(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics, (config, now) -> this.numOpenIterators.sum());
        StateStoreMetrics.addOldestOpenIteratorGauge(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics, (config, now) -> this.openIterators.isEmpty() ? null : Long.valueOf(((MeteredIterator)this.openIterators.first()).startTimestamp()));
    }

    private void initStoreSerde(ProcessorContext context) {
        String storeName = this.name();
        String changelogTopic = ProcessorContextUtils.changelogFor(context, storeName, Boolean.FALSE);
        this.serdes = StoreSerdeInitializer.prepareStoreSerde(context, storeName, changelogTopic, this.keySerde, this.valueSerde, WrappingNullableUtils::prepareValueSerde);
    }

    private void initStoreSerde(StateStoreContext context) {
        String storeName = this.name();
        String changelogTopic = ProcessorContextUtils.changelogFor(context, storeName, Boolean.FALSE);
        this.serdes = StoreSerdeInitializer.prepareStoreSerde(context, storeName, changelogTopic, this.keySerde, this.valueSerde, WrappingNullableUtils::prepareValueSerde);
    }

    @Override
    public boolean setFlushListener(CacheFlushListener<Windowed<K>, V> listener, boolean sendOldValues) {
        SessionStore wrapped = (SessionStore)this.wrapped();
        if (wrapped instanceof CachedStateStore) {
            return ((CachedStateStore)((Object)wrapped)).setFlushListener((Record<K, Change<V>> record) -> listener.apply(record.withKey(SessionKeySchema.from((byte[])record.key(), this.serdes.keyDeserializer(), this.serdes.topic())).withValue(new Change<Object>((((Change)record.value()).newValue != null ? (Object)this.serdes.valueFrom((byte[])((Change)record.value()).newValue) : null), (((Change)record.value()).oldValue != null ? (Object)this.serdes.valueFrom((byte[])((Change)record.value()).oldValue) : null), ((Change)record.value()).isLatest))), sendOldValues);
        }
        return false;
    }

    @Override
    public void put(Windowed<K> sessionKey, V aggregate) {
        Objects.requireNonNull(sessionKey, "sessionKey can't be null");
        Objects.requireNonNull(sessionKey.key(), "sessionKey.key() can't be null");
        Objects.requireNonNull(sessionKey.window(), "sessionKey.window() can't be null");
        try {
            StreamsMetricsImpl.maybeMeasureLatency(() -> {
                Bytes key = this.keyBytes(sessionKey.key());
                ((SessionStore)this.wrapped()).put(new Windowed<Bytes>(key, sessionKey.window()), this.serdes.rawValue(aggregate));
            }, this.time, this.putSensor);
            this.maybeRecordE2ELatency();
        }
        catch (ProcessorStateException e) {
            String message = String.format(e.getMessage(), sessionKey.key(), aggregate);
            throw new ProcessorStateException(message, e);
        }
    }

    @Override
    public void remove(Windowed<K> sessionKey) {
        Objects.requireNonNull(sessionKey, "sessionKey can't be null");
        Objects.requireNonNull(sessionKey.key(), "sessionKey.key() can't be null");
        Objects.requireNonNull(sessionKey.window(), "sessionKey.window() can't be null");
        try {
            StreamsMetricsImpl.maybeMeasureLatency(() -> {
                Bytes key = this.keyBytes(sessionKey.key());
                ((SessionStore)this.wrapped()).remove(new Windowed<Bytes>(key, sessionKey.window()));
            }, this.time, this.removeSensor);
        }
        catch (ProcessorStateException e) {
            String message = String.format(e.getMessage(), sessionKey.key());
            throw new ProcessorStateException(message, e);
        }
    }

    @Override
    public V fetchSession(K key, long earliestSessionEndTime, long latestSessionStartTime) {
        Objects.requireNonNull(key, "key cannot be null");
        return (V)StreamsMetricsImpl.maybeMeasureLatency(() -> {
            Bytes bytesKey = this.keyBytes(key);
            byte[] result = (byte[])((SessionStore)this.wrapped()).fetchSession(bytesKey, earliestSessionEndTime, latestSessionStartTime);
            if (result == null) {
                return null;
            }
            return this.serdes.valueFrom(result);
        }, this.time, this.fetchSensor);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetch(K key) {
        Objects.requireNonNull(key, "key cannot be null");
        return new MeteredWindowedKeyValueIterator<Object, Object>(((SessionStore)this.wrapped()).fetch(this.keyBytes(key)), this.fetchSensor, this.iteratorDurationSensor, this.streamsMetrics, this.serdes::keyFrom, this.serdes::valueFrom, this.time, this.numOpenIterators, this.openIterators);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> backwardFetch(K key) {
        Objects.requireNonNull(key, "key cannot be null");
        return new MeteredWindowedKeyValueIterator<Object, Object>(((SessionStore)this.wrapped()).backwardFetch(this.keyBytes(key)), this.fetchSensor, this.iteratorDurationSensor, this.streamsMetrics, this.serdes::keyFrom, this.serdes::valueFrom, this.time, this.numOpenIterators, this.openIterators);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetch(K keyFrom, K keyTo) {
        return new MeteredWindowedKeyValueIterator<Object, Object>(((SessionStore)this.wrapped()).fetch(this.keyBytes(keyFrom), this.keyBytes(keyTo)), this.fetchSensor, this.iteratorDurationSensor, this.streamsMetrics, this.serdes::keyFrom, this.serdes::valueFrom, this.time, this.numOpenIterators, this.openIterators);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> backwardFetch(K keyFrom, K keyTo) {
        return new MeteredWindowedKeyValueIterator<Object, Object>(((SessionStore)this.wrapped()).backwardFetch(this.keyBytes(keyFrom), this.keyBytes(keyTo)), this.fetchSensor, this.iteratorDurationSensor, this.streamsMetrics, this.serdes::keyFrom, this.serdes::valueFrom, this.time, this.numOpenIterators, this.openIterators);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> findSessions(K key, long earliestSessionEndTime, long latestSessionStartTime) {
        Objects.requireNonNull(key, "key cannot be null");
        Bytes bytesKey = this.keyBytes(key);
        return new MeteredWindowedKeyValueIterator<Object, Object>(((SessionStore)this.wrapped()).findSessions(bytesKey, earliestSessionEndTime, latestSessionStartTime), this.fetchSensor, this.iteratorDurationSensor, this.streamsMetrics, this.serdes::keyFrom, this.serdes::valueFrom, this.time, this.numOpenIterators, this.openIterators);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> backwardFindSessions(K key, long earliestSessionEndTime, long latestSessionStartTime) {
        Objects.requireNonNull(key, "key cannot be null");
        Bytes bytesKey = this.keyBytes(key);
        return new MeteredWindowedKeyValueIterator<Object, Object>(((SessionStore)this.wrapped()).backwardFindSessions(bytesKey, earliestSessionEndTime, latestSessionStartTime), this.fetchSensor, this.iteratorDurationSensor, this.streamsMetrics, this.serdes::keyFrom, this.serdes::valueFrom, this.time, this.numOpenIterators, this.openIterators);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> findSessions(K keyFrom, K keyTo, long earliestSessionEndTime, long latestSessionStartTime) {
        Bytes bytesKeyFrom = this.keyBytes(keyFrom);
        Bytes bytesKeyTo = this.keyBytes(keyTo);
        return new MeteredWindowedKeyValueIterator<Object, Object>(((SessionStore)this.wrapped()).findSessions(bytesKeyFrom, bytesKeyTo, earliestSessionEndTime, latestSessionStartTime), this.fetchSensor, this.iteratorDurationSensor, this.streamsMetrics, this.serdes::keyFrom, this.serdes::valueFrom, this.time, this.numOpenIterators, this.openIterators);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> findSessions(long earliestSessionEndTime, long latestSessionEndTime) {
        return new MeteredWindowedKeyValueIterator<Object, Object>(((SessionStore)this.wrapped()).findSessions(earliestSessionEndTime, latestSessionEndTime), this.fetchSensor, this.iteratorDurationSensor, this.streamsMetrics, this.serdes::keyFrom, this.serdes::valueFrom, this.time, this.numOpenIterators, this.openIterators);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> backwardFindSessions(K keyFrom, K keyTo, long earliestSessionEndTime, long latestSessionStartTime) {
        Bytes bytesKeyFrom = this.keyBytes(keyFrom);
        Bytes bytesKeyTo = this.keyBytes(keyTo);
        return new MeteredWindowedKeyValueIterator<Object, Object>(((SessionStore)this.wrapped()).backwardFindSessions(bytesKeyFrom, bytesKeyTo, earliestSessionEndTime, latestSessionStartTime), this.fetchSensor, this.iteratorDurationSensor, this.streamsMetrics, this.serdes::keyFrom, this.serdes::valueFrom, this.time, this.numOpenIterators, this.openIterators);
    }

    @Override
    public void flush() {
        StreamsMetricsImpl.maybeMeasureLatency(() -> super.flush(), this.time, this.flushSensor);
    }

    @Override
    public void close() {
        try {
            ((SessionStore)this.wrapped()).close();
        }
        finally {
            this.streamsMetrics.removeAllStoreLevelSensorsAndMetrics(this.taskId.toString(), this.name());
        }
    }

    @Override
    public <R> QueryResult<R> query(Query<R> query, PositionBound positionBound, QueryConfig config) {
        QueryResult<Object> result;
        long start = this.time.nanoseconds();
        StoreQueryUtils.QueryHandler handler = this.queryHandlers.get(query.getClass());
        if (handler == null) {
            result = ((SessionStore)this.wrapped()).query(query, positionBound, config);
            if (config.isCollectExecutionInfo()) {
                result.addExecutionInfo("Handled in " + this.getClass() + " in " + (this.time.nanoseconds() - start) + "ns");
            }
        } else {
            result = handler.apply(query, positionBound, config, this);
            if (config.isCollectExecutionInfo()) {
                result.addExecutionInfo("Handled in " + this.getClass() + " with serdes " + this.serdes + " in " + (this.time.nanoseconds() - start) + "ns");
            }
        }
        return result;
    }

    private <R> QueryResult<R> runRangeQuery(Query<R> query, PositionBound positionBound, QueryConfig config) {
        QueryResult<Object> result;
        WindowRangeQuery typedQuery = (WindowRangeQuery)query;
        if (typedQuery.getKey().isPresent()) {
            WindowRangeQuery rawKeyQuery = WindowRangeQuery.withKey(Bytes.wrap(this.serdes.rawKey(typedQuery.getKey().get())));
            QueryResult rawResult = ((SessionStore)this.wrapped()).query(rawKeyQuery, positionBound, config);
            if (rawResult.isSuccess()) {
                MeteredWindowedKeyValueIterator<Object, V> typedResult = new MeteredWindowedKeyValueIterator<Object, V>((KeyValueIterator)rawResult.getResult(), this.fetchSensor, this.iteratorDurationSensor, this.streamsMetrics, this.serdes::keyFrom, StoreQueryUtils.getDeserializeValue(this.serdes, this.wrapped()), this.time, this.numOpenIterators, this.openIterators);
                QueryResult<MeteredWindowedKeyValueIterator<Object, V>> typedQueryResult = InternalQueryResultUtil.copyAndSubstituteDeserializedResult(rawResult, typedResult);
                result = typedQueryResult;
            } else {
                result = rawResult;
            }
        } else {
            result = QueryResult.forFailure(FailureReason.UNKNOWN_QUERY_TYPE, "This store (" + this.getClass() + ") doesn't know how to execute the given query (" + query + ") because SessionStores only support WindowRangeQuery.withKey. Contact the store maintainer if you need support for a new query type.");
        }
        return result;
    }

    private Bytes keyBytes(K key) {
        return key == null ? null : Bytes.wrap(this.serdes.rawKey(key));
    }

    private void maybeRecordE2ELatency() {
        if (this.e2eLatencySensor.shouldRecord() && this.context != null) {
            long currentTime = this.time.milliseconds();
            long e2eLatency = currentTime - this.context.timestamp();
            this.e2eLatencySensor.record(e2eLatency, currentTime);
        }
    }
}

