/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.TopologyConfig;
import org.apache.kafka.streams.errors.DeserializationExceptionHandler;
import org.apache.kafka.streams.errors.ProcessingExceptionHandler;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.errors.TaskCorruptedException;
import org.apache.kafka.streams.errors.TaskMigratedException;
import org.apache.kafka.streams.errors.TopologyException;
import org.apache.kafka.streams.errors.internals.DefaultErrorHandlerContext;
import org.apache.kafka.streams.errors.internals.FailedProcessingException;
import org.apache.kafka.streams.processor.Cancellable;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.Punctuator;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.AbstractPartitionGroup;
import org.apache.kafka.streams.processor.internals.AbstractTask;
import org.apache.kafka.streams.processor.internals.CorruptedRecord;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.PartitionGroup;
import org.apache.kafka.streams.processor.internals.ProcessorMetadata;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.ProcessorNodePunctuator;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.PunctuationQueue;
import org.apache.kafka.streams.processor.internals.PunctuationSchedule;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.RecordQueue;
import org.apache.kafka.streams.processor.internals.SourceNode;
import org.apache.kafka.streams.processor.internals.StampedRecord;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.apache.kafka.streams.processor.internals.StateManagerUtil;
import org.apache.kafka.streams.processor.internals.SynchronizedPartitionGroup;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.streams.processor.internals.TaskManager;
import org.apache.kafka.streams.processor.internals.TopicPartitionMetadata;
import org.apache.kafka.streams.processor.internals.metrics.ProcessorNodeMetrics;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.TaskMetrics;
import org.apache.kafka.streams.processor.internals.metrics.ThreadMetrics;
import org.apache.kafka.streams.state.internals.ThreadCache;

public class StreamTask
extends AbstractTask
implements ProcessorNodePunctuator,
Task {
    private final Time time;
    private final Consumer<byte[], byte[]> mainConsumer;
    private final boolean eosEnabled;
    private final int maxBufferedSize;
    private final AbstractPartitionGroup partitionGroup;
    private final RecordCollector recordCollector;
    private final AbstractPartitionGroup.RecordInfo recordInfo;
    private final Map<TopicPartition, Long> consumedOffsets;
    private final Map<TopicPartition, Long> committedOffsets;
    private final Map<TopicPartition, Long> highWatermark;
    private final Set<TopicPartition> resetOffsetsForPartitions;
    private final Set<TopicPartition> partitionsToResume;
    private final PunctuationQueue streamTimePunctuationQueue;
    private final PunctuationQueue systemTimePunctuationQueue;
    private final StreamsMetricsImpl streamsMetrics;
    private long processTimeMs = 0L;
    private final Sensor closeTaskSensor;
    private final Sensor processRatioSensor;
    private final Sensor processLatencySensor;
    private final Sensor restoreSensor;
    private final Sensor restoreRemainingSensor;
    private final Sensor punctuateLatencySensor;
    private final Sensor bufferedRecordsSensor;
    private final Sensor droppedRecordsSensor;
    private final Map<String, Sensor> e2eLatencySensors = new HashMap<String, Sensor>();
    private final RecordQueueCreator recordQueueCreator;
    protected final InternalProcessorContext processorContext;
    private final ProcessingExceptionHandler processingExceptionHandler;
    private StampedRecord record;
    private boolean commitNeeded = false;
    private boolean commitRequested = false;
    private boolean hasPendingTxCommit = false;
    private Optional<Long> timeCurrentIdlingStarted;

    public StreamTask(TaskId id, Set<TopicPartition> inputPartitions, ProcessorTopology topology, Consumer<byte[], byte[]> mainConsumer, TopologyConfig.TaskConfig config, StreamsMetricsImpl streamsMetrics, StateDirectory stateDirectory, ThreadCache cache, Time time, ProcessorStateManager stateMgr, RecordCollector recordCollector, InternalProcessorContext processorContext, LogContext logContext, boolean processingThreadsEnabled) {
        super(id, topology, stateDirectory, stateMgr, inputPartitions, config, "task", StreamTask.class);
        this.mainConsumer = mainConsumer;
        this.processorContext = processorContext;
        processorContext.transitionToActive(this, recordCollector, cache);
        this.time = time;
        this.recordCollector = recordCollector;
        this.eosEnabled = config.eosEnabled;
        String threadId = Thread.currentThread().getName();
        this.streamsMetrics = streamsMetrics;
        this.closeTaskSensor = ThreadMetrics.closeTaskSensor(threadId, streamsMetrics);
        String taskId = id.toString();
        this.restoreSensor = TaskMetrics.restoreSensor(threadId, taskId, streamsMetrics, new Sensor[0]);
        this.restoreRemainingSensor = TaskMetrics.restoreRemainingRecordsSensor(threadId, taskId, streamsMetrics);
        this.processRatioSensor = TaskMetrics.activeProcessRatioSensor(threadId, taskId, streamsMetrics);
        this.processLatencySensor = TaskMetrics.processLatencySensor(threadId, taskId, streamsMetrics);
        this.punctuateLatencySensor = TaskMetrics.punctuateSensor(threadId, taskId, streamsMetrics);
        this.bufferedRecordsSensor = TaskMetrics.activeBufferedRecordsSensor(threadId, taskId, streamsMetrics);
        this.droppedRecordsSensor = TaskMetrics.droppedRecordsSensor(threadId, taskId, streamsMetrics);
        for (String string : topology.terminalNodes()) {
            this.e2eLatencySensors.put(string, ProcessorNodeMetrics.e2ELatencySensor(threadId, taskId, string, streamsMetrics));
        }
        for (ProcessorNode processorNode : topology.sources()) {
            String sourceNodeName = processorNode.name();
            this.e2eLatencySensors.put(sourceNodeName, ProcessorNodeMetrics.e2ELatencySensor(threadId, taskId, sourceNodeName, streamsMetrics));
        }
        this.streamTimePunctuationQueue = new PunctuationQueue();
        this.systemTimePunctuationQueue = new PunctuationQueue();
        this.maxBufferedSize = config.maxBufferedSize;
        this.consumedOffsets = new HashMap<TopicPartition, Long>();
        this.resetOffsetsForPartitions = new HashSet<TopicPartition>();
        this.partitionsToResume = new HashSet<TopicPartition>();
        this.recordQueueCreator = new RecordQueueCreator(this.logContext, config.timestampExtractor, config.deserializationExceptionHandler);
        this.recordInfo = new AbstractPartitionGroup.RecordInfo();
        Sensor enforcedProcessingSensor = TaskMetrics.enforcedProcessingSensor(threadId, taskId, streamsMetrics, new Sensor[0]);
        long l = config.maxTaskIdleMs;
        this.partitionGroup = processingThreadsEnabled ? new SynchronizedPartitionGroup(new PartitionGroup(logContext, this.createPartitionQueues(), mainConsumer::currentLag, TaskMetrics.recordLatenessSensor(threadId, taskId, streamsMetrics), enforcedProcessingSensor, l)) : new PartitionGroup(logContext, this.createPartitionQueues(), mainConsumer::currentLag, TaskMetrics.recordLatenessSensor(threadId, taskId, streamsMetrics), enforcedProcessingSensor, l);
        stateMgr.registerGlobalStateStores(topology.globalStateStores());
        this.committedOffsets = new HashMap<TopicPartition, Long>();
        this.highWatermark = new HashMap<TopicPartition, Long>();
        for (TopicPartition topicPartition : inputPartitions) {
            this.committedOffsets.put(topicPartition, -1L);
            this.highWatermark.put(topicPartition, -1L);
        }
        this.timeCurrentIdlingStarted = Optional.empty();
        this.processingExceptionHandler = config.processingExceptionHandler;
    }

    private Map<TopicPartition, RecordQueue> createPartitionQueues() {
        HashMap<TopicPartition, RecordQueue> partitionQueues = new HashMap<TopicPartition, RecordQueue>();
        for (TopicPartition partition : this.inputPartitions()) {
            partitionQueues.put(partition, this.recordQueueCreator.createQueue(partition));
        }
        return partitionQueues;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void recordRestoration(Time time, long numRecords, boolean initRemaining) {
        if (initRemaining) {
            StreamsMetricsImpl.maybeRecordSensor(numRecords, time, this.restoreRemainingSensor);
        } else {
            StreamsMetricsImpl.maybeRecordSensor(numRecords, time, this.restoreSensor);
            StreamsMetricsImpl.maybeRecordSensor(-1L * numRecords, time, this.restoreRemainingSensor);
        }
    }

    @Override
    public void initializeIfNeeded() {
        if (this.state() == Task.State.CREATED) {
            this.recordCollector.initialize();
            StateManagerUtil.registerStateStores(this.log, this.logPrefix, this.topology, this.stateMgr, this.stateDirectory, this.processorContext);
            this.offsetSnapshotSinceLastFlush = Collections.emptyMap();
            this.transitionTo(Task.State.RESTORING);
            this.log.info("Initialized");
        }
    }

    @Override
    public void addPartitionsForOffsetReset(Set<TopicPartition> partitionsForOffsetReset) {
        this.mainConsumer.pause(partitionsForOffsetReset);
        this.resetOffsetsForPartitions.addAll(partitionsForOffsetReset);
    }

    @Override
    public void completeRestoration(java.util.function.Consumer<Set<TopicPartition>> offsetResetter) {
        switch (this.state()) {
            case RUNNING: {
                return;
            }
            case RESTORING: {
                this.resetOffsetsIfNeededAndInitializeMetadata(offsetResetter);
                this.initializeTopology();
                this.processorContext.initialize();
                if (!this.eosEnabled) {
                    this.maybeCheckpoint(true);
                }
                this.transitionTo(Task.State.RUNNING);
                this.log.info("Restored and ready to run");
                break;
            }
            case CREATED: 
            case SUSPENDED: 
            case CLOSED: {
                throw new IllegalStateException("Illegal state " + (Object)((Object)this.state()) + " while completing restoration for active task " + this.id);
            }
            default: {
                throw new IllegalStateException("Unknown state " + (Object)((Object)this.state()) + " while completing restoration for active task " + this.id);
            }
        }
    }

    @Override
    public void suspend() {
        switch (this.state()) {
            case CREATED: {
                this.transitToSuspend();
                break;
            }
            case RESTORING: {
                this.transitToSuspend();
                break;
            }
            case RUNNING: {
                try {
                    this.closeTopology();
                    this.partitionGroup.clear();
                    break;
                }
                finally {
                    this.transitToSuspend();
                }
            }
            case SUSPENDED: {
                this.log.info("Skip suspending since state is {}", (Object)this.state());
                break;
            }
            case CLOSED: {
                throw new IllegalStateException("Illegal state " + (Object)((Object)this.state()) + " while suspending active task " + this.id);
            }
            default: {
                throw new IllegalStateException("Unknown state " + (Object)((Object)this.state()) + " while suspending active task " + this.id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeTopology() {
        this.log.trace("Closing processor topology");
        RuntimeException exception = null;
        for (ProcessorNode<?, ?, ?, ?> node : this.topology.processors()) {
            this.processorContext.setCurrentNode(node);
            try {
                node.close();
            }
            catch (RuntimeException e) {
                exception = e;
            }
            finally {
                this.processorContext.setCurrentNode(null);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public void resume() {
        switch (this.state()) {
            case RUNNING: 
            case RESTORING: 
            case CREATED: {
                this.log.trace("Skip resuming since state is {}", (Object)this.state());
                break;
            }
            case SUSPENDED: {
                try {
                    this.stateMgr.deleteCheckPointFileIfEOSEnabled();
                    this.log.debug("Deleted check point file upon resuming with EOS enabled");
                }
                catch (IOException ioe) {
                    this.log.error("Encountered error while deleting the checkpoint file due to this exception", (Throwable)ioe);
                }
                this.transitionTo(Task.State.RESTORING);
                this.log.info("Resumed to restoring state");
                break;
            }
            case CLOSED: {
                throw new IllegalStateException("Illegal state " + (Object)((Object)this.state()) + " while resuming active task " + this.id);
            }
            default: {
                throw new IllegalStateException("Unknown state " + (Object)((Object)this.state()) + " while resuming active task " + this.id);
            }
        }
        this.timeCurrentIdlingStarted = Optional.empty();
    }

    public void flush() {
        this.stateMgr.flushCache();
        this.recordCollector.flush();
    }

    @Override
    public Map<TopicPartition, OffsetAndMetadata> prepareCommit() {
        switch (this.state()) {
            case RUNNING: 
            case RESTORING: 
            case CREATED: 
            case SUSPENDED: {
                if (this.commitNeeded) {
                    this.flush();
                    this.hasPendingTxCommit = this.eosEnabled;
                    this.log.debug("Prepared {} task for committing", (Object)this.state());
                    return this.committableOffsetsAndMetadata();
                }
                this.log.debug("Skipped preparing {} task for commit since there is nothing to commit", (Object)this.state());
                return Collections.emptyMap();
            }
            case CLOSED: {
                throw new IllegalStateException("Illegal state " + (Object)((Object)this.state()) + " while preparing active task " + this.id + " for committing");
            }
        }
        throw new IllegalStateException("Unknown state " + (Object)((Object)this.state()) + " while preparing active task " + this.id + " for committing");
    }

    private Long findOffset(TopicPartition partition) {
        Long offset = this.partitionGroup.headRecordOffset(partition);
        if (offset == null) {
            try {
                offset = this.mainConsumer.position(partition);
            }
            catch (TimeoutException error) {
                throw new IllegalStateException(error);
            }
            catch (KafkaException fatal) {
                throw new StreamsException(fatal);
            }
        }
        return offset;
    }

    private Map<TopicPartition, OffsetAndMetadata> committableOffsetsAndMetadata() {
        Map<TopicPartition, OffsetAndMetadata> committableOffsets;
        switch (this.state()) {
            case RESTORING: 
            case CREATED: {
                committableOffsets = Collections.emptyMap();
                break;
            }
            case RUNNING: 
            case SUSPENDED: {
                Map<TopicPartition, Long> partitionTimes = this.extractPartitionTimes();
                Set<TopicPartition> partitionsNeedCommit = this.processorContext.getProcessorMetadata().needsCommit() ? this.inputPartitions() : this.consumedOffsets.keySet();
                committableOffsets = new HashMap<TopicPartition, OffsetAndMetadata>(partitionsNeedCommit.size());
                for (TopicPartition partition : partitionsNeedCommit) {
                    Long offset = this.findOffset(partition);
                    long partitionTime = partitionTimes.get(partition);
                    committableOffsets.put(partition, new OffsetAndMetadata(offset, new TopicPartitionMetadata(partitionTime, this.processorContext.getProcessorMetadata()).encode()));
                }
                break;
            }
            case CLOSED: {
                throw new IllegalStateException("Illegal state " + (Object)((Object)this.state()) + " while getting committable offsets for active task " + this.id);
            }
            default: {
                throw new IllegalStateException("Unknown state " + (Object)((Object)this.state()) + " while post committing active task " + this.id);
            }
        }
        return committableOffsets;
    }

    @Override
    public void postCommit(boolean enforceCheckpoint) {
        switch (this.state()) {
            case CREATED: {
                this.log.debug("Skipped writing checkpoint for {} task", (Object)this.state());
                break;
            }
            case RESTORING: 
            case SUSPENDED: {
                this.maybeCheckpoint(enforceCheckpoint);
                this.log.debug("Finalized commit for {} task with enforce checkpoint {}", (Object)this.state(), (Object)enforceCheckpoint);
                break;
            }
            case RUNNING: {
                if (enforceCheckpoint || !this.eosEnabled) {
                    this.maybeCheckpoint(enforceCheckpoint);
                }
                this.log.debug("Finalized commit for {} task with eos {} enforce checkpoint {}", new Object[]{this.state(), this.eosEnabled, enforceCheckpoint});
                break;
            }
            case CLOSED: {
                throw new IllegalStateException("Illegal state " + (Object)((Object)this.state()) + " while post committing active task " + this.id);
            }
            default: {
                throw new IllegalStateException("Unknown state " + (Object)((Object)this.state()) + " while post committing active task " + this.id);
            }
        }
        this.clearCommitStatuses();
    }

    private void clearCommitStatuses() {
        this.commitNeeded = false;
        this.commitRequested = false;
        this.hasPendingTxCommit = false;
        this.processorContext.getProcessorMetadata().setNeedsCommit(false);
    }

    private Map<TopicPartition, Long> extractPartitionTimes() {
        HashMap<TopicPartition, Long> partitionTimes = new HashMap<TopicPartition, Long>();
        for (TopicPartition partition : this.partitionGroup.partitions()) {
            partitionTimes.put(partition, this.partitionGroup.partitionTimestamp(partition));
        }
        return partitionTimes;
    }

    @Override
    public void closeClean() {
        this.validateClean();
        this.removeAllSensors();
        this.clearCommitStatuses();
        this.close(true);
        this.log.info("Closed clean");
    }

    @Override
    public void closeDirty() {
        this.removeAllSensors();
        this.clearCommitStatuses();
        this.close(false);
        this.log.info("Closed dirty");
    }

    @Override
    public void updateInputPartitions(Set<TopicPartition> topicPartitions, Map<String, List<String>> allTopologyNodesToSourceTopics) {
        super.updateInputPartitions(topicPartitions, allTopologyNodesToSourceTopics);
        this.partitionGroup.updatePartitions(topicPartitions, this.recordQueueCreator::createQueue);
        this.processorContext.getProcessorMetadata().setNeedsCommit(true);
    }

    @Override
    public void prepareRecycle() {
        this.validateClean();
        this.removeAllSensors();
        this.clearCommitStatuses();
        switch (this.state()) {
            case SUSPENDED: {
                this.stateMgr.recycle();
                this.partitionGroup.close();
                this.recordCollector.closeClean();
                break;
            }
            case RUNNING: 
            case RESTORING: 
            case CREATED: 
            case CLOSED: {
                throw new IllegalStateException("Illegal state " + (Object)((Object)this.state()) + " while recycling active task " + this.id);
            }
            default: {
                throw new IllegalStateException("Unknown state " + (Object)((Object)this.state()) + " while recycling active task " + this.id);
            }
        }
        this.closeTaskSensor.record();
        this.transitionTo(Task.State.CLOSED);
        this.log.info("Closed and recycled state");
    }

    @Override
    public void resumePollingForPartitionsWithAvailableSpace() {
        if (!this.partitionsToResume.isEmpty()) {
            this.mainConsumer.resume(this.partitionsToResume);
            this.partitionsToResume.clear();
        }
    }

    @Override
    public void updateLags() {
        if (this.state() == Task.State.RUNNING) {
            this.partitionGroup.updateLags();
        }
    }

    @Override
    public void maybeCheckpoint(boolean enforceCheckpoint) {
        if (this.commitNeeded || enforceCheckpoint) {
            this.stateMgr.updateChangelogOffsets(this.checkpointableOffsets());
        }
        super.maybeCheckpoint(enforceCheckpoint);
    }

    private void validateClean() {
        if (this.commitNeeded) {
            this.log.debug("Tried to close clean but there was pending uncommitted data, this means we failed to commit and should close as dirty instead");
            throw new TaskMigratedException("Tried to close dirty task as clean");
        }
    }

    private void removeAllSensors() {
        this.streamsMetrics.removeAllTaskLevelSensors(Thread.currentThread().getName(), this.id.toString());
        for (String nodeName : this.e2eLatencySensors.keySet()) {
            this.streamsMetrics.removeAllNodeLevelSensors(Thread.currentThread().getName(), this.id.toString(), nodeName);
        }
    }

    private void close(boolean clean) {
        switch (this.state()) {
            case SUSPENDED: {
                TaskManager.executeAndMaybeSwallow(clean, this.partitionGroup::close, "partition group close", this.log);
                TaskManager.executeAndMaybeSwallow(clean, () -> StateManagerUtil.closeStateManager(this.log, this.logPrefix, clean, this.eosEnabled, this.stateMgr, this.stateDirectory, Task.TaskType.ACTIVE), "state manager close", this.log);
                TaskManager.executeAndMaybeSwallow(clean, clean ? this.recordCollector::closeClean : this.recordCollector::closeDirty, "record collector close", this.log);
                break;
            }
            case CLOSED: {
                this.log.trace("Skip closing since state is {}", (Object)this.state());
                return;
            }
            case RUNNING: 
            case RESTORING: 
            case CREATED: {
                throw new IllegalStateException("Illegal state " + (Object)((Object)this.state()) + " while closing active task " + this.id);
            }
            default: {
                throw new IllegalStateException("Unknown state " + (Object)((Object)this.state()) + " while closing active task " + this.id);
            }
        }
        this.record = null;
        this.closeTaskSensor.record();
        this.partitionsToResume.clear();
        this.transitionTo(Task.State.CLOSED);
    }

    public boolean isProcessable(long wallClockTime) {
        if (this.state() == Task.State.CLOSED) {
            this.log.info("Stream task {} is already in {} state, skip processing it.", (Object)this.id(), (Object)this.state());
            return false;
        }
        if (this.hasPendingTxCommit) {
            return false;
        }
        boolean readyToProcess = this.partitionGroup.readyToProcess(wallClockTime);
        if (!readyToProcess) {
            if (!this.timeCurrentIdlingStarted.isPresent()) {
                this.timeCurrentIdlingStarted = Optional.of(wallClockTime);
            }
        } else {
            this.timeCurrentIdlingStarted = Optional.empty();
        }
        return readyToProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(long wallClockTime) {
        if (this.record == null) {
            if (!this.isProcessable(wallClockTime)) {
                return false;
            }
            this.record = this.partitionGroup.nextRecord(this.recordInfo, wallClockTime);
            if (this.record == null) {
                return false;
            }
        }
        try {
            TopicPartition partition = this.recordInfo.partition();
            if (!(this.record instanceof CorruptedRecord)) {
                this.doProcess(wallClockTime);
            }
            this.consumedOffsets.put(partition, this.record.offset());
            this.commitNeeded = true;
            if (this.recordInfo.queue().size() == this.maxBufferedSize) {
                this.partitionsToResume.add(partition);
            }
            this.record = null;
        }
        catch (TimeoutException timeoutException) {
            if (!this.eosEnabled) {
                throw timeoutException;
            }
            this.record = null;
            throw new TaskCorruptedException(Collections.singleton(this.id));
        }
        catch (FailedProcessingException failedProcessingException) {
            this.handleException(failedProcessingException.getMessage(), failedProcessingException.getCause());
        }
        catch (StreamsException exception) {
            this.record = null;
            throw exception;
        }
        catch (RuntimeException e) {
            this.handleException(e);
        }
        finally {
            this.processorContext.setCurrentNode(null);
        }
        return true;
    }

    private void handleException(Throwable originalException) {
        this.handleException(String.format("Exception caught in process. taskId=%s, processor=%s, topic=%s, partition=%d, offset=%d", this.id(), this.processorContext.currentNode().name(), this.record.topic(), this.record.partition(), this.record.offset()), originalException);
    }

    private void handleException(String errorMessage, Throwable originalException) {
        if (errorMessage == null) {
            this.handleException(originalException);
        }
        StreamsException error = new StreamsException(errorMessage, originalException);
        this.record = null;
        throw error;
    }

    private void doProcess(long wallClockTime) {
        ProcessorNode<?, ?, ?, ?> currNode = this.recordInfo.node();
        this.log.trace("Start processing one record [{}]", (Object)this.record);
        ProcessorRecordContext recordContext = new ProcessorRecordContext(this.record.timestamp, this.record.offset(), this.record.partition(), this.record.topic(), this.record.headers());
        this.updateProcessorContext(currNode, wallClockTime, recordContext);
        this.maybeRecordE2ELatency(this.record.timestamp, wallClockTime, currNode.name());
        Record<Object, Object> toProcess = new Record<Object, Object>(this.record.key(), this.record.value(), this.processorContext.timestamp(), this.processorContext.headers());
        StreamsMetricsImpl.maybeMeasureLatency(() -> currNode.process(toProcess), this.time, this.processLatencySensor);
        this.log.trace("Completed processing one record [{}]", (Object)this.record);
    }

    @Override
    public void recordProcessBatchTime(long processBatchTime) {
        this.processTimeMs += processBatchTime;
    }

    @Override
    public void recordProcessTimeRatioAndBufferSize(long allTaskProcessMs, long now) {
        this.bufferedRecordsSensor.record(this.partitionGroup.numBuffered());
        this.processRatioSensor.record((double)this.processTimeMs / (double)allTaskProcessMs, now);
        this.processTimeMs = 0L;
    }

    private String getStacktraceString(Throwable e) {
        String stacktrace = null;
        try (StringWriter stringWriter = new StringWriter();
             PrintWriter printWriter = new PrintWriter(stringWriter);){
            e.printStackTrace(printWriter);
            stacktrace = stringWriter.toString();
        }
        catch (IOException ioe) {
            this.log.error("Encountered error extracting stacktrace from this exception", (Throwable)ioe);
        }
        return stacktrace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void punctuate(ProcessorNode<?, ?, ?, ?> node, long timestamp, PunctuationType type, Punctuator punctuator) {
        if (this.processorContext.currentNode() != null) {
            throw new IllegalStateException(String.format("%sCurrent node is not null", this.logPrefix));
        }
        ProcessorRecordContext recordContext = new ProcessorRecordContext(timestamp, -1L, -1, null, new RecordHeaders());
        this.updateProcessorContext(node, this.time.milliseconds(), recordContext);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Punctuating processor {} with timestamp {} and punctuation type {}", new Object[]{node.name(), timestamp, type});
        }
        try {
            StreamsMetricsImpl.maybeMeasureLatency(() -> punctuator.punctuate(timestamp), this.time, this.punctuateLatencySensor);
        }
        catch (TimeoutException timeoutException) {
            if (!this.eosEnabled) {
                throw timeoutException;
            }
            this.record = null;
            throw new TaskCorruptedException(Collections.singleton(this.id));
        }
        catch (FailedProcessingException e) {
            throw this.createStreamsException(node.name(), e.getCause());
        }
        catch (TaskCorruptedException | TaskMigratedException e) {
            throw e;
        }
        catch (RuntimeException processingException) {
            ProcessingExceptionHandler.ProcessingHandlerResponse response;
            DefaultErrorHandlerContext errorHandlerContext = new DefaultErrorHandlerContext(null, recordContext.topic(), recordContext.partition(), recordContext.offset(), recordContext.headers(), node.name(), this.id(), recordContext.timestamp());
            try {
                response = Objects.requireNonNull(this.processingExceptionHandler.handle(errorHandlerContext, null, processingException), "Invalid ProcessingExceptionHandler response.");
            }
            catch (RuntimeException fatalUserException) {
                this.log.error("Processing error callback failed after processing error for record: {}", (Object)errorHandlerContext, (Object)processingException);
                throw new FailedProcessingException("Fatal user code error in processing error callback", fatalUserException);
            }
            if (response == ProcessingExceptionHandler.ProcessingHandlerResponse.FAIL) {
                this.log.error("Processing exception handler is set to fail upon a processing error. If you would rather have the streaming pipeline continue after a processing error, please set the processing.exception.handler appropriately.");
                throw this.createStreamsException(node.name(), processingException);
            }
            this.droppedRecordsSensor.record();
        }
        finally {
            this.processorContext.setCurrentNode(null);
        }
    }

    private StreamsException createStreamsException(String processorName, Throwable cause) {
        return new StreamsException(String.format("%sException caught while punctuating processor '%s'", this.logPrefix, processorName), cause);
    }

    private void updateProcessorContext(ProcessorNode<?, ?, ?, ?> currNode, long wallClockTime, ProcessorRecordContext recordContext) {
        this.processorContext.setRecordContext(recordContext);
        this.processorContext.setCurrentNode(currNode);
        this.processorContext.setSystemTimeMs(wallClockTime);
    }

    private Map<TopicPartition, Long> checkpointableOffsets() {
        HashMap<TopicPartition, Long> checkpointableOffsets = new HashMap<TopicPartition, Long>(this.recordCollector.offsets());
        for (Map.Entry<TopicPartition, Long> entry : this.consumedOffsets.entrySet()) {
            checkpointableOffsets.putIfAbsent(entry.getKey(), entry.getValue());
        }
        this.log.debug("Checkpointable offsets {}", checkpointableOffsets);
        return checkpointableOffsets;
    }

    private void resetOffsetsIfNeededAndInitializeMetadata(java.util.function.Consumer<Set<TopicPartition>> offsetResetter) {
        try {
            Map<TopicPartition, OffsetAndMetadata> offsetsAndMetadata = this.mainConsumer.committed(this.inputPartitions());
            for (Map.Entry<TopicPartition, OffsetAndMetadata> committedEntry : offsetsAndMetadata.entrySet()) {
                OffsetAndMetadata offsetAndMetadata;
                if (!this.resetOffsetsForPartitions.contains(committedEntry.getKey()) || (offsetAndMetadata = committedEntry.getValue()) == null) continue;
                this.mainConsumer.seek(committedEntry.getKey(), offsetAndMetadata);
                this.resetOffsetsForPartitions.remove(committedEntry.getKey());
            }
            offsetResetter.accept(this.resetOffsetsForPartitions);
            this.resetOffsetsForPartitions.clear();
            this.initializeTaskTimeAndProcessorMetadata(offsetsAndMetadata.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
        catch (TimeoutException timeoutException) {
            this.log.warn("Encountered {} while trying to fetch committed offsets, will retry initializing the metadata in the next loop.\nConsider overwriting consumer config {} to a larger value to avoid timeout errors", (Object)this.time.toString(), (Object)"default.api.timeout.ms");
            throw timeoutException;
        }
        catch (KafkaException e2) {
            throw new StreamsException(String.format("task [%s] Failed to initialize offsets for %s", this.id, this.inputPartitions()), e2);
        }
    }

    private void initializeTaskTimeAndProcessorMetadata(Map<TopicPartition, OffsetAndMetadata> offsetsAndMetadata) {
        ProcessorMetadata finalProcessMetadata = new ProcessorMetadata();
        for (Map.Entry<TopicPartition, OffsetAndMetadata> entry : offsetsAndMetadata.entrySet()) {
            TopicPartition partition = entry.getKey();
            OffsetAndMetadata metadata = entry.getValue();
            if (metadata != null) {
                TopicPartitionMetadata committedTimestampAndMeta = TopicPartitionMetadata.decode(metadata.metadata());
                long committedTimestamp = committedTimestampAndMeta.partitionTime();
                this.partitionGroup.setPartitionTime(partition, committedTimestamp);
                this.log.debug("A committed timestamp was detected: setting the partition time of partition {} to {} in stream task {}", new Object[]{partition, committedTimestamp, this.id});
                ProcessorMetadata processorMetadata = committedTimestampAndMeta.processorMetadata();
                finalProcessMetadata.update(processorMetadata);
                continue;
            }
            this.log.debug("No committed timestamp was found in metadata for partition {}", (Object)partition);
        }
        this.processorContext.setProcessorMetadata(finalProcessMetadata);
        HashSet<TopicPartition> nonCommitted = new HashSet<TopicPartition>(this.inputPartitions());
        nonCommitted.removeAll(offsetsAndMetadata.keySet());
        for (TopicPartition partition : nonCommitted) {
            this.log.debug("No committed offset for partition {}, therefore no timestamp can be found for this partition", (Object)partition);
        }
    }

    @Override
    public Map<TopicPartition, Long> purgeableOffsets() {
        HashMap<TopicPartition, Long> purgeableConsumedOffsets = new HashMap<TopicPartition, Long>();
        for (Map.Entry<TopicPartition, Long> entry : this.consumedOffsets.entrySet()) {
            TopicPartition tp = entry.getKey();
            if (!this.topology.isRepartitionTopic(tp.topic())) continue;
            purgeableConsumedOffsets.put(tp, entry.getValue() + 1L);
        }
        return purgeableConsumedOffsets;
    }

    private void initializeTopology() {
        this.log.trace("Initializing processor nodes of the topology");
        for (ProcessorNode<?, ?, ?, ?> node : this.topology.processors()) {
            this.processorContext.setCurrentNode(node);
            try {
                node.init(this.processorContext, this.processingExceptionHandler);
            }
            finally {
                this.processorContext.setCurrentNode(null);
            }
        }
    }

    @Override
    public void addRecords(TopicPartition partition, Iterable<ConsumerRecord<byte[], byte[]>> records) {
        int newQueueSize = this.partitionGroup.addRawRecords(partition, records);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Added records into the buffered queue of partition {}, new queue size is {}", (Object)partition, (Object)newQueueSize);
        }
        if (newQueueSize > this.maxBufferedSize) {
            this.mainConsumer.pause(Collections.singleton(partition));
        }
    }

    public Cancellable schedule(long interval, PunctuationType type, Punctuator punctuator) {
        switch (type) {
            case STREAM_TIME: {
                return this.schedule(0L, interval, type, punctuator);
            }
            case WALL_CLOCK_TIME: {
                return this.schedule(this.time.milliseconds() + interval, interval, type, punctuator);
            }
        }
        throw new IllegalArgumentException("Unrecognized PunctuationType: " + (Object)((Object)type));
    }

    private Cancellable schedule(long startTime, long interval, PunctuationType type, Punctuator punctuator) {
        if (this.processorContext.currentNode() == null) {
            throw new IllegalStateException(String.format("%sCurrent node is null", this.logPrefix));
        }
        PunctuationSchedule schedule = new PunctuationSchedule(this.processorContext.currentNode(), startTime, interval, punctuator);
        switch (type) {
            case STREAM_TIME: {
                return this.streamTimePunctuationQueue.schedule(schedule);
            }
            case WALL_CLOCK_TIME: {
                return this.systemTimePunctuationQueue.schedule(schedule);
            }
        }
        throw new IllegalArgumentException("Unrecognized PunctuationType: " + (Object)((Object)type));
    }

    @Override
    public boolean maybePunctuateStreamTime() {
        long streamTime = this.partitionGroup.streamTime();
        if (streamTime == -1L) {
            return false;
        }
        boolean punctuated = this.streamTimePunctuationQueue.maybePunctuate(streamTime, PunctuationType.STREAM_TIME, this);
        if (punctuated) {
            this.commitNeeded = true;
        }
        return punctuated;
    }

    public boolean canPunctuateStreamTime() {
        long streamTime = this.partitionGroup.streamTime();
        return this.streamTimePunctuationQueue.canPunctuate(streamTime);
    }

    @Override
    public boolean maybePunctuateSystemTime() {
        long systemTime = this.time.milliseconds();
        boolean punctuated = this.systemTimePunctuationQueue.maybePunctuate(systemTime, PunctuationType.WALL_CLOCK_TIME, this);
        if (punctuated) {
            this.commitNeeded = true;
        }
        return punctuated;
    }

    public boolean canPunctuateSystemTime() {
        long systemTime = this.time.milliseconds();
        return this.systemTimePunctuationQueue.canPunctuate(systemTime);
    }

    void maybeRecordE2ELatency(long recordTimestamp, long now, String nodeName) {
        Sensor e2eLatencySensor = this.e2eLatencySensors.get(nodeName);
        if (e2eLatencySensor == null) {
            throw new IllegalStateException("Requested to record e2e latency but could not find sensor for node " + nodeName);
        }
        if (e2eLatencySensor.shouldRecord() && e2eLatencySensor.hasMetrics()) {
            e2eLatencySensor.record(now - recordTimestamp, now);
        }
    }

    void requestCommit() {
        this.commitRequested = true;
    }

    @Override
    public boolean commitRequested() {
        return this.commitRequested;
    }

    public InternalProcessorContext processorContext() {
        return this.processorContext;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        Set<TopicPartition> partitions;
        StringBuilder sb = new StringBuilder();
        sb.append(indent);
        sb.append("TaskId: ");
        sb.append(this.id);
        sb.append("\n");
        if (this.topology != null) {
            sb.append(indent).append(this.topology.toString(indent + "\t"));
        }
        if ((partitions = this.inputPartitions()) != null && !partitions.isEmpty()) {
            sb.append(indent).append("Partitions [");
            for (TopicPartition topicPartition : partitions) {
                sb.append(topicPartition).append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append("]\n");
        }
        return sb.toString();
    }

    @Override
    public boolean commitNeeded() {
        if (this.commitNeeded) {
            return true;
        }
        for (Map.Entry<TopicPartition, Long> entry : this.consumedOffsets.entrySet()) {
            TopicPartition partition = entry.getKey();
            try {
                long offset = this.mainConsumer.position(partition);
                if (offset <= entry.getValue() + 1L) continue;
                this.commitNeeded = true;
                entry.setValue(offset - 1L);
            }
            catch (TimeoutException swallow) {
                this.log.debug(String.format("Could not get consumer position for partition %s", partition), (Throwable)swallow);
            }
            catch (KafkaException fatal) {
                throw new StreamsException(fatal);
            }
        }
        return this.commitNeeded;
    }

    @Override
    public Map<TopicPartition, Long> changelogOffsets() {
        if (this.state() == Task.State.RUNNING) {
            return this.changelogPartitions().stream().collect(Collectors.toMap(Function.identity(), tp -> -2L));
        }
        return Collections.unmodifiableMap(this.stateMgr.changelogOffsets());
    }

    @Override
    public Map<TopicPartition, Long> committedOffsets() {
        return Collections.unmodifiableMap(this.committedOffsets);
    }

    @Override
    public Map<TopicPartition, Long> highWaterMark() {
        return Collections.unmodifiableMap(this.highWatermark);
    }

    private void transitToSuspend() {
        this.log.info("Suspended from {}", (Object)this.state());
        this.transitionTo(Task.State.SUSPENDED);
        this.timeCurrentIdlingStarted = Optional.of(System.currentTimeMillis());
    }

    @Override
    public Optional<Long> timeCurrentIdlingStarted() {
        return this.timeCurrentIdlingStarted;
    }

    public void updateCommittedOffsets(TopicPartition topicPartition, Long offset) {
        this.committedOffsets.put(topicPartition, offset);
    }

    public void updateEndOffsets(TopicPartition topicPartition, Long offset) {
        this.highWatermark.put(topicPartition, offset);
    }

    public boolean hasRecordsQueued() {
        return this.numBuffered() > 0;
    }

    RecordCollector recordCollector() {
        return this.recordCollector;
    }

    int numBuffered() {
        return this.partitionGroup.numBuffered();
    }

    long streamTime() {
        return this.partitionGroup.streamTime();
    }

    private class RecordQueueCreator {
        private final LogContext logContext;
        private final TimestampExtractor defaultTimestampExtractor;
        private final DeserializationExceptionHandler defaultDeserializationExceptionHandler;

        private RecordQueueCreator(LogContext logContext, TimestampExtractor defaultTimestampExtractor, DeserializationExceptionHandler defaultDeserializationExceptionHandler) {
            this.logContext = logContext;
            this.defaultTimestampExtractor = defaultTimestampExtractor;
            this.defaultDeserializationExceptionHandler = defaultDeserializationExceptionHandler;
        }

        public RecordQueue createQueue(TopicPartition partition) {
            SourceNode<?, ?> source = StreamTask.this.topology.source(partition.topic());
            if (source == null) {
                throw new TopologyException("Topic " + partition.topic() + " is unknown to the topology. This may happen if different KafkaStreams instances of the same application execute different Topologies. Note that Topologies are only identical if all operators are added in the same order.");
            }
            TimestampExtractor sourceTimestampExtractor = source.getTimestampExtractor();
            TimestampExtractor timestampExtractor = sourceTimestampExtractor != null ? sourceTimestampExtractor : this.defaultTimestampExtractor;
            return new RecordQueue(partition, source, timestampExtractor, this.defaultDeserializationExceptionHandler, StreamTask.this.processorContext, this.logContext);
        }
    }
}

