/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.kstream.internals.WrappingNullableUtils;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.metrics.ProcessorNodeMetrics;

public class SourceNode<KIn, VIn>
extends ProcessorNode<KIn, VIn, KIn, VIn> {
    private InternalProcessorContext<KIn, VIn> context;
    private Deserializer<KIn> keyDeserializer;
    private Deserializer<VIn> valDeserializer;
    private final TimestampExtractor timestampExtractor;
    private Sensor processAtSourceSensor;

    public SourceNode(String name, TimestampExtractor timestampExtractor, Deserializer<KIn> keyDeserializer, Deserializer<VIn> valDeserializer) {
        super(name);
        this.timestampExtractor = timestampExtractor;
        this.keyDeserializer = keyDeserializer;
        this.valDeserializer = valDeserializer;
    }

    public SourceNode(String name, Deserializer<KIn> keyDeserializer, Deserializer<VIn> valDeserializer) {
        this(name, null, keyDeserializer, valDeserializer);
    }

    KIn deserializeKey(String topic, Headers headers, byte[] data) {
        return this.keyDeserializer.deserialize(topic, headers, data);
    }

    VIn deserializeValue(String topic, Headers headers, byte[] data) {
        return this.valDeserializer.deserialize(topic, headers, data);
    }

    @Override
    public void init(InternalProcessorContext<KIn, VIn> context) {
        this.processAtSourceSensor = ProcessorNodeMetrics.processAtSourceSensor(Thread.currentThread().getName(), context.taskId().toString(), context.currentNode().name(), context.metrics());
        super.init(context);
        this.context = context;
        try {
            this.keyDeserializer = WrappingNullableUtils.prepareKeyDeserializer(this.keyDeserializer, context, this.name());
        }
        catch (ConfigException | StreamsException e) {
            throw new StreamsException(String.format("Failed to initialize key serdes for source node %s", this.name()), e, context.taskId());
        }
        try {
            this.valDeserializer = WrappingNullableUtils.prepareValueDeserializer(this.valDeserializer, context, this.name());
        }
        catch (ConfigException | StreamsException e) {
            throw new StreamsException(String.format("Failed to initialize value serdes for source node %s", this.name()), e, context.taskId());
        }
    }

    @Override
    public void process(Record<KIn, VIn> record) {
        this.context.forward(record);
        this.processAtSourceSensor.record(1.0, this.context.currentSystemTimeMs());
    }

    @Override
    public String toString() {
        return this.toString("");
    }

    public TimestampExtractor getTimestampExtractor() {
        return this.timestampExtractor;
    }
}

