/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Objects;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.streams.kstream.ValueTransformerWithKey;
import org.apache.kafka.streams.kstream.ValueTransformerWithKeySupplier;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableMaterializedValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.KTableProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.TimestampedCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.TimestampedTupleForwarder;
import org.apache.kafka.streams.processor.api.ContextualProcessor;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.ForwardingDisabledProcessorContext;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.KeyValueStoreWrapper;

class KTableTransformValues<K, V, VOut>
implements KTableProcessorSupplier<K, V, K, VOut> {
    private final KTableImpl<K, ?, V> parent;
    private final ValueTransformerWithKeySupplier<? super K, ? super V, ? extends VOut> transformerSupplier;
    private final String queryableName;
    private boolean sendOldValues = false;

    KTableTransformValues(KTableImpl<K, ?, V> parent, ValueTransformerWithKeySupplier<? super K, ? super V, ? extends VOut> transformerSupplier, String queryableName) {
        this.parent = Objects.requireNonNull(parent, "parent");
        this.transformerSupplier = Objects.requireNonNull(transformerSupplier, "transformerSupplier");
        this.queryableName = queryableName;
    }

    @Override
    public Processor<K, Change<V>, K, Change<VOut>> get() {
        return new KTableTransformValuesProcessor((ValueTransformerWithKey)this.transformerSupplier.get());
    }

    @Override
    public KTableValueGetterSupplier<K, VOut> view() {
        if (this.queryableName != null) {
            return new KTableMaterializedValueGetterSupplier(this.queryableName);
        }
        return new KTableValueGetterSupplier<K, VOut>(){
            final KTableValueGetterSupplier<K, V> parentValueGetterSupplier;
            {
                this.parentValueGetterSupplier = KTableTransformValues.this.parent.valueGetterSupplier();
            }

            @Override
            public KTableValueGetter<K, VOut> get() {
                return new KTableTransformValuesGetter(this.parentValueGetterSupplier.get(), KTableTransformValues.this.transformerSupplier.get());
            }

            @Override
            public String[] storeNames() {
                return this.parentValueGetterSupplier.storeNames();
            }
        };
    }

    @Override
    public boolean enableSendingOldValues(boolean forceMaterialization) {
        if (this.queryableName != null) {
            this.sendOldValues = true;
            return true;
        }
        if (this.parent.enableSendingOldValues(forceMaterialization)) {
            this.sendOldValues = true;
        }
        return this.sendOldValues;
    }

    private class KTableTransformValuesGetter
    implements KTableValueGetter<K, VOut> {
        private final KTableValueGetter<K, V> parentGetter;
        private InternalProcessorContext internalProcessorContext;
        private final ValueTransformerWithKey<? super K, ? super V, ? extends VOut> valueTransformer;

        KTableTransformValuesGetter(KTableValueGetter<K, V> parentGetter, ValueTransformerWithKey<? super K, ? super V, ? extends VOut> valueTransformer) {
            this.parentGetter = Objects.requireNonNull(parentGetter, "parentGetter");
            this.valueTransformer = Objects.requireNonNull(valueTransformer, "valueTransformer");
        }

        @Override
        public void init(ProcessorContext<?, ?> context) {
            this.internalProcessorContext = (InternalProcessorContext)context;
            this.parentGetter.init(context);
            this.valueTransformer.init(new ForwardingDisabledProcessorContext(this.internalProcessorContext));
        }

        @Override
        public ValueAndTimestamp<VOut> get(K key) {
            return this.transformValue(key, this.parentGetter.get(key));
        }

        @Override
        public ValueAndTimestamp<VOut> get(K key, long asOfTimestamp) {
            return this.transformValue(key, this.parentGetter.get(key, asOfTimestamp));
        }

        @Override
        public boolean isVersioned() {
            return this.parentGetter.isVersioned();
        }

        @Override
        public void close() {
            this.parentGetter.close();
            this.valueTransformer.close();
        }

        private ValueAndTimestamp<VOut> transformValue(K key, ValueAndTimestamp<V> valueAndTimestamp) {
            ProcessorRecordContext currentContext = this.internalProcessorContext.recordContext();
            this.internalProcessorContext.setRecordContext(new ProcessorRecordContext(valueAndTimestamp == null ? -1L : valueAndTimestamp.timestamp(), -1L, -1, null, new RecordHeaders()));
            ValueAndTimestamp result = ValueAndTimestamp.make(this.valueTransformer.transform(key, ValueAndTimestamp.getValueOrNull(valueAndTimestamp)), valueAndTimestamp == null ? -1L : valueAndTimestamp.timestamp());
            this.internalProcessorContext.setRecordContext(currentContext);
            return result;
        }
    }

    private class KTableTransformValuesProcessor
    extends ContextualProcessor<K, Change<V>, K, Change<VOut>> {
        private final ValueTransformerWithKey<? super K, ? super V, ? extends VOut> valueTransformer;
        private KeyValueStoreWrapper<K, VOut> store;
        private TimestampedTupleForwarder<K, VOut> tupleForwarder;

        private KTableTransformValuesProcessor(ValueTransformerWithKey<? super K, ? super V, ? extends VOut> valueTransformer) {
            this.valueTransformer = Objects.requireNonNull(valueTransformer, "valueTransformer");
        }

        @Override
        public void init(ProcessorContext<K, Change<VOut>> context) {
            super.init(context);
            InternalProcessorContext internalProcessorContext = (InternalProcessorContext)context;
            this.valueTransformer.init(new ForwardingDisabledProcessorContext(internalProcessorContext));
            if (KTableTransformValues.this.queryableName != null) {
                this.store = new KeyValueStoreWrapper(context, KTableTransformValues.this.queryableName);
                this.tupleForwarder = new TimestampedTupleForwarder(this.store.getStore(), context, new TimestampedCacheFlushListener(context), KTableTransformValues.this.sendOldValues);
            }
        }

        @Override
        public void process(Record<K, Change<V>> record) {
            Object newValue = this.valueTransformer.transform(record.key(), record.value().newValue);
            if (KTableTransformValues.this.queryableName != null) {
                Object oldValue = KTableTransformValues.this.sendOldValues ? (Object)ValueAndTimestamp.getValueOrNull(this.store.get(record.key())) : null;
                long putReturnCode = this.store.put(record.key(), newValue, record.timestamp());
                if (putReturnCode != Long.MIN_VALUE) {
                    this.tupleForwarder.maybeForward(record.withValue(new Change<Object>(newValue, oldValue, putReturnCode == -1L)));
                }
            } else {
                Object oldValue = KTableTransformValues.this.sendOldValues ? (Object)this.valueTransformer.transform((Object)record.key(), (Object)record.value().oldValue) : null;
                this.context().forward(record.withValue(new Change<Object>(newValue, oldValue, record.value().isLatest)));
            }
        }

        @Override
        public void close() {
            this.valueTransformer.close();
        }
    }
}

