/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.WindowedSerdes;
import org.apache.kafka.streams.state.internals.SessionKeySchema;

public class SessionWindowedDeserializer<T>
implements Deserializer<Windowed<T>> {
    private Deserializer<T> inner;

    public SessionWindowedDeserializer() {
    }

    public SessionWindowedDeserializer(Deserializer<T> inner) {
        this.inner = inner;
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        String windowedInnerClassSerdeConfig = (String)configs.get("windowed.inner.class.serde");
        Serde windowInnerClassSerde = null;
        if (windowedInnerClassSerdeConfig != null) {
            try {
                windowInnerClassSerde = Utils.newInstance(windowedInnerClassSerdeConfig, Serde.class);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigException("windowed.inner.class.serde", windowedInnerClassSerdeConfig, "Serde class " + windowedInnerClassSerdeConfig + " could not be found.");
            }
        }
        if (this.inner != null && windowedInnerClassSerdeConfig != null) {
            if (!this.inner.getClass().getName().equals(windowInnerClassSerde.deserializer().getClass().getName())) {
                throw new IllegalArgumentException("Inner class deserializer set using constructor (" + this.inner.getClass().getName() + ") is different from the one set in windowed.inner.class.serde config (" + windowInnerClassSerde.deserializer().getClass().getName() + ").");
            }
        } else {
            if (this.inner == null && windowedInnerClassSerdeConfig == null) {
                throw new IllegalArgumentException("Inner class deserializer should be set either via constructor or via the windowed.inner.class.serde config");
            }
            if (this.inner == null) {
                this.inner = windowInnerClassSerde.deserializer();
            }
        }
    }

    @Override
    public Windowed<T> deserialize(String topic, byte[] data) {
        WindowedSerdes.verifyInnerDeserializerNotNull(this.inner, this);
        if (data == null || data.length == 0) {
            return null;
        }
        return SessionKeySchema.from(data, this.inner, topic);
    }

    @Override
    public void close() {
        if (this.inner != null) {
            this.inner.close();
        }
    }

    Deserializer<T> innerDeserializer() {
        return this.inner;
    }
}

