/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility.internal.primitive;

import java.util.Collection;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.iterator.FloatIterator;

public final class FloatIteratorIterate {
    private FloatIteratorIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static void forEach(FloatIterator iterator2, FloatProcedure procedure) {
        while (iterator2.hasNext()) {
            procedure.value(iterator2.next());
        }
    }

    public static <R extends MutableFloatCollection> R select(FloatIterator iterator2, FloatPredicate predicate, R targetCollection) {
        while (iterator2.hasNext()) {
            float item = iterator2.next();
            if (!predicate.accept(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <R extends MutableFloatCollection> R reject(FloatIterator iterator2, FloatPredicate predicate, R targetCollection) {
        while (iterator2.hasNext()) {
            float item = iterator2.next();
            if (predicate.accept(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <V, R extends Collection<V>> R collect(FloatIterator iterator2, FloatToObjectFunction<? extends V> function, R targetCollection) {
        while (iterator2.hasNext()) {
            float item = iterator2.next();
            targetCollection.add(function.valueOf(item));
        }
        return targetCollection;
    }

    public static float detectIfNone(FloatIterator iterator2, FloatPredicate predicate, float ifNone) {
        while (iterator2.hasNext()) {
            float item = iterator2.next();
            if (!predicate.accept(item)) continue;
            return item;
        }
        return ifNone;
    }

    public static int count(FloatIterator iterator2, FloatPredicate predicate) {
        int count = 0;
        while (iterator2.hasNext()) {
            if (!predicate.accept(iterator2.next())) continue;
            ++count;
        }
        return count;
    }

    public static boolean anySatisfy(FloatIterator iterator2, FloatPredicate predicate) {
        while (iterator2.hasNext()) {
            if (!predicate.accept(iterator2.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean allSatisfy(FloatIterator iterator2, FloatPredicate predicate) {
        while (iterator2.hasNext()) {
            if (predicate.accept(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean noneSatisfy(FloatIterator iterator2, FloatPredicate predicate) {
        while (iterator2.hasNext()) {
            if (!predicate.accept(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public static <T> T injectInto(FloatIterator iterator2, T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        while (iterator2.hasNext()) {
            result = function.valueOf(result, iterator2.next());
        }
        return result;
    }

    public static double sum(FloatIterator iterator2) {
        double sum = 0.0;
        while (iterator2.hasNext()) {
            sum += (double)iterator2.next();
        }
        return sum;
    }

    public static float max(FloatIterator iterator2) {
        float max = iterator2.next();
        while (iterator2.hasNext()) {
            float next = iterator2.next();
            if (Float.compare(max, next) >= 0) continue;
            max = next;
        }
        return max;
    }

    public static float min(FloatIterator iterator2) {
        float min = iterator2.next();
        while (iterator2.hasNext()) {
            float next = iterator2.next();
            if (Float.compare(next, min) >= 0) continue;
            min = next;
        }
        return min;
    }
}

