/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.set.primitive.ImmutableIntSet;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.set.primitive.AbstractIntSet;

public abstract class AbstractImmutableIntSet
extends AbstractIntSet
implements ImmutableIntSet {
    @Override
    public ImmutableIntSet newWith(int element) {
        return IntHashSet.newSet(this).with(element).toImmutable();
    }

    @Override
    public ImmutableIntSet newWithout(int element) {
        return IntHashSet.newSet(this).without(element).toImmutable();
    }

    @Override
    public ImmutableIntSet newWithAll(IntIterable elements) {
        return IntHashSet.newSet(this).withAll(elements).toImmutable();
    }

    @Override
    public ImmutableIntSet newWithoutAll(IntIterable elements) {
        return IntHashSet.newSet(this).withoutAll(elements).toImmutable();
    }

    @Override
    public IntSet freeze() {
        return this;
    }

    @Override
    public ImmutableIntSet toImmutable() {
        return this;
    }

    @Override
    public RichIterable<IntIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size) {
                result.add(this);
            } else {
                IntIterator iterator2 = this.intIterator();
                while (iterator2.hasNext()) {
                    MutableIntSet batch = IntSets.mutable.empty();
                    for (int i = 0; i < size && iterator2.hasNext(); ++i) {
                        batch.add(iterator2.next());
                    }
                    result.add(batch.toImmutable());
                }
            }
        }
        return result.toImmutable();
    }
}

