/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.util.NoSuchElementException;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.list.primitive.FloatList;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.impl.bag.mutable.primitive.FloatHashBag;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyFloatIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;

public class ReverseFloatIterable
extends AbstractLazyFloatIterable {
    private final FloatList adapted;

    public ReverseFloatIterable(FloatList newAdapted) {
        this.adapted = newAdapted;
    }

    public static ReverseFloatIterable adapt(FloatList floatList) {
        return new ReverseFloatIterable(floatList);
    }

    @Override
    public FloatIterator floatIterator() {
        return new ReverseFloatIterator();
    }

    @Override
    public void each(FloatProcedure procedure) {
        FloatIterator iterator2 = this.floatIterator();
        while (iterator2.hasNext()) {
            procedure.value(iterator2.next());
        }
    }

    @Override
    public double sum() {
        return this.adapted.sum();
    }

    @Override
    public float max() {
        return this.adapted.max();
    }

    @Override
    public float min() {
        return this.adapted.min();
    }

    @Override
    public float minIfEmpty(float defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.min();
    }

    @Override
    public float maxIfEmpty(float defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.max();
    }

    @Override
    public double average() {
        return this.adapted.average();
    }

    @Override
    public double median() {
        return this.adapted.median();
    }

    @Override
    public float[] toSortedArray() {
        return this.adapted.toSortedArray();
    }

    @Override
    public float[] toArray() {
        float[] results = new float[this.adapted.size()];
        int index = 0;
        FloatIterator iterator2 = this.floatIterator();
        while (iterator2.hasNext()) {
            results[index] = iterator2.next();
            ++index;
        }
        return results;
    }

    @Override
    public boolean contains(float value) {
        return this.adapted.contains(value);
    }

    @Override
    public boolean containsAll(float ... source) {
        return this.adapted.containsAll(source);
    }

    @Override
    public boolean containsAll(FloatIterable source) {
        return this.adapted.containsAll(source);
    }

    @Override
    public int size() {
        return this.adapted.size();
    }

    @Override
    public boolean isEmpty() {
        return this.adapted.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.adapted.notEmpty();
    }

    @Override
    public MutableFloatList toList() {
        return FloatArrayList.newList(this);
    }

    @Override
    public MutableFloatSet toSet() {
        return FloatHashSet.newSet(this);
    }

    @Override
    public MutableFloatBag toBag() {
        return FloatHashBag.newBag(this);
    }

    @Override
    public LazyFloatIterable asLazy() {
        return new LazyFloatIterableAdapter(this);
    }

    private class ReverseFloatIterator
    implements FloatIterator {
        private int currentIndex;

        private ReverseFloatIterator() {
            this.currentIndex = ReverseFloatIterable.this.adapted.size() - 1;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex != -1;
        }

        @Override
        public float next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            float next = ReverseFloatIterable.this.adapted.get(this.currentIndex);
            --this.currentIndex;
            return next;
        }
    }
}

