/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.transformations;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.StringJoiner;
import net.datafaker.sequence.FakeSequence;
import net.datafaker.transformations.CompositeField;
import net.datafaker.transformations.Field;
import net.datafaker.transformations.Schema;
import net.datafaker.transformations.SimpleField;
import net.datafaker.transformations.Transformer;

public class JsonTransformer<IN>
implements Transformer<IN, CharSequence> {
    private static final Map<Character, String> ESCAPING_MAP = JsonTransformer.createEscapeMap();
    private static final char[] WRAPPERS = "[]".toCharArray();
    private final boolean commaBetweenObjects;

    private JsonTransformer(boolean commaBetweenObjects) {
        this.commaBetweenObjects = commaBetweenObjects;
    }

    public static <IN> JsonTransformerBuilder<IN> builder() {
        return new JsonTransformerBuilder();
    }

    @Override
    public String apply(IN input, Schema<IN, ?> schema) {
        Field<IN, ?>[] fields = schema.getFields();
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (int i = 0; i < fields.length; ++i) {
            JsonTransformer.value2String(fields[i].getName(), sb);
            sb.append(": ");
            if (fields[i] instanceof CompositeField) {
                sb.append((CharSequence)this.apply(input, (CompositeField)fields[i], i));
            } else {
                this.applyValue(input, sb, ((SimpleField)fields[i]).transform(input));
            }
            if (i >= fields.length - 1) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public String generate(Iterable<IN> input, Schema<IN, ?> schema) {
        FakeSequence fakeSequence;
        if (input instanceof FakeSequence && (fakeSequence = (FakeSequence)input).isInfinite()) {
            throw new IllegalArgumentException("The sequence should be finite of size: " + fakeSequence);
        }
        StringJoiner data = new StringJoiner(LINE_SEPARATOR);
        Iterator<IN> iterator = input.iterator();
        while (iterator.hasNext()) {
            data.add((String)this.apply((Object)iterator.next(), (Schema)schema) + (this.commaBetweenObjects && iterator.hasNext() ? "," : ""));
        }
        return data.length() > 1 ? WRAPPERS[0] + LINE_SEPARATOR + data + LINE_SEPARATOR + WRAPPERS[1] : data.toString();
    }

    @Override
    public String generate(Schema<IN, ?> schema, int limit) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < limit; ++i) {
            sb.append((CharSequence)this.apply(null, schema, i));
            if (!this.commaBetweenObjects || i >= limit - 1) continue;
            sb.append(",").append(LINE_SEPARATOR);
        }
        return limit > 1 ? WRAPPERS[0] + LINE_SEPARATOR + sb + LINE_SEPARATOR + WRAPPERS[1] : sb.toString();
    }

    @Override
    public String getStartStream(Schema<IN, ?> schema) {
        return "[";
    }

    @Override
    public String getEndStream() {
        return "]";
    }

    @Override
    public String getElementSeparator() {
        return ",";
    }

    private void applyValue(IN input, StringBuilder sb, Object value) {
        if (value instanceof Collection) {
            sb.append(this.generate(input, (Collection)value));
        } else if (value != null && value.getClass().isArray()) {
            sb.append(this.generate(input, Arrays.asList((Object[])value)));
        } else {
            JsonTransformer.value2String(value, sb);
        }
    }

    private String generate(IN input, Collection<Object> collection) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int i = 0;
        for (Object value : collection) {
            if (i > 0) {
                sb.append(", ");
            }
            ++i;
            if (value instanceof CompositeField) {
                sb.append((String)this.apply((Object)input, (Schema)((CompositeField)value)));
                continue;
            }
            this.applyValue(input, sb, value);
        }
        sb.append("]");
        return sb.toString();
    }

    private static void value2String(Object value, StringBuilder sb) {
        if (value == null) {
            sb.append("null");
        } else if (value instanceof Integer || value instanceof Long || value instanceof Short || value instanceof BigInteger || value instanceof Boolean || value instanceof Double && BigDecimal.valueOf((Double)value).remainder(BigDecimal.ONE).doubleValue() == 0.0 || value instanceof BigDecimal && ((BigDecimal)value).remainder(BigDecimal.ONE).doubleValue() == 0.0) {
            sb.append(value);
        } else {
            boolean toWrap;
            String val = String.valueOf(value);
            boolean bl = toWrap = !val.startsWith("#{json");
            if (toWrap) {
                sb.append("\"");
            }
            int start = 0;
            int length = val.length();
            for (int i = 0; i < length; ++i) {
                char c = val.charAt(i);
                String escapedValue = ESCAPING_MAP.get(Character.valueOf(c));
                if (escapedValue == null) continue;
                sb.append(val, start, i).append(escapedValue);
                start = i + 1;
            }
            sb.append(val, start, length);
            if (toWrap) {
                sb.append("\"");
            }
        }
    }

    private static Map<Character, String> createEscapeMap() {
        return Map.ofEntries(Map.entry(Character.valueOf('\\'), "\\\\"), Map.entry(Character.valueOf('\"'), "\\\""), Map.entry(Character.valueOf('\b'), "\\b"), Map.entry(Character.valueOf('\f'), "\\f"), Map.entry(Character.valueOf('\n'), "\\n"), Map.entry(Character.valueOf('\r'), "\\r"), Map.entry(Character.valueOf('\t'), "\\t"), Map.entry(Character.valueOf('/'), "\\/"), Map.entry(Character.valueOf('\u0000'), "\\u0000"), Map.entry(Character.valueOf('\u0001'), "\\u0001"), Map.entry(Character.valueOf('\u0002'), "\\u0002"), Map.entry(Character.valueOf('\u0003'), "\\u0003"), Map.entry(Character.valueOf('\u0004'), "\\u0004"), Map.entry(Character.valueOf('\u0005'), "\\u0005"), Map.entry(Character.valueOf('\u0006'), "\\u0006"), Map.entry(Character.valueOf('\u0007'), "\\u0007"), Map.entry(Character.valueOf('\u000b'), "\\u000B"), Map.entry(Character.valueOf('\u000e'), "\\u000E"), Map.entry(Character.valueOf('\u000f'), "\\u000F"), Map.entry(Character.valueOf('\u0010'), "\\u0010"), Map.entry(Character.valueOf('\u0011'), "\\u0011"), Map.entry(Character.valueOf('\u0012'), "\\u0012"), Map.entry(Character.valueOf('\u0013'), "\\u0013"), Map.entry(Character.valueOf('\u0014'), "\\u0014"), Map.entry(Character.valueOf('\u0015'), "\\u0015"), Map.entry(Character.valueOf('\u0016'), "\\u0016"), Map.entry(Character.valueOf('\u0017'), "\\u0017"), Map.entry(Character.valueOf('\u0018'), "\\u0018"), Map.entry(Character.valueOf('\u0019'), "\\u0019"), Map.entry(Character.valueOf('\u001a'), "\\u001A"), Map.entry(Character.valueOf('\u001b'), "\\u001B"), Map.entry(Character.valueOf('\u001c'), "\\u001C"), Map.entry(Character.valueOf('\u001d'), "\\u001D"), Map.entry(Character.valueOf('\u001e'), "\\u001E"), Map.entry(Character.valueOf('\u001f'), "\\u001F"));
    }

    public static class JsonTransformerBuilder<IN> {
        private boolean commaBetweenObjects = true;

        private JsonTransformerBuilder() {
        }

        public JsonTransformerBuilder<IN> withCommaBetweenObjects(boolean commaBetweenObjects) {
            this.commaBetweenObjects = commaBetweenObjects;
            return this;
        }

        public JsonTransformer<IN> build() {
            return new JsonTransformer(this.commaBetweenObjects);
        }
    }
}

