/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.transformations;

import java.util.Iterator;
import net.datafaker.sequence.FakeSequence;
import net.datafaker.transformations.Field;
import net.datafaker.transformations.Schema;
import net.datafaker.transformations.SimpleField;
import net.datafaker.transformations.Transformer;

public class CsvTransformer<IN>
implements Transformer<IN, CharSequence> {
    public static final String DEFAULT_SEPARATOR = ";";
    public static final char DEFAULT_QUOTE = '\"';
    private final String separator;
    private final char quote;
    private final boolean withHeader;

    private CsvTransformer(String separator, char quote, boolean withHeader) {
        this.separator = separator;
        this.quote = quote;
        this.withHeader = withHeader;
    }

    public static <IN> CsvTransformerBuilder<IN> builder() {
        return new CsvTransformerBuilder();
    }

    @Override
    public CharSequence apply(IN input, Schema<IN, ?> schema) {
        Field<IN, ?>[] fields = schema.getFields();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fields.length; ++i) {
            SimpleField f = (SimpleField)fields[i];
            this.addLine(sb, f.transform(input));
            if (i >= fields.length - 1) continue;
            sb.append(this.separator);
        }
        return sb.toString();
    }

    @Override
    public String generate(Iterable<IN> input, Schema<IN, ?> schema) {
        FakeSequence fakeSequence;
        if (input instanceof FakeSequence && (fakeSequence = (FakeSequence)input).isInfinite()) {
            throw new IllegalArgumentException("The sequence should be finite of size: " + fakeSequence);
        }
        StringBuilder sb = new StringBuilder();
        this.generateHeader(schema, sb);
        Iterator<IN> iterator = input.iterator();
        boolean hasNext = iterator.hasNext();
        while (hasNext) {
            IN in = iterator.next();
            sb.append((CharSequence)this.apply((Object)in, (Schema)schema));
            hasNext = iterator.hasNext();
            if (!hasNext) continue;
            sb.append(LINE_SEPARATOR);
        }
        return sb.toString();
    }

    private void addLine(StringBuilder sb, Object transform) {
        if (transform instanceof CharSequence) {
            this.addCharSequence(sb, (CharSequence)transform);
        } else {
            sb.append(transform);
        }
    }

    private void addCharSequence(StringBuilder sb, CharSequence charSequence) {
        sb.append(this.quote);
        int i = 0;
        int length = charSequence.length();
        for (int j = 0; j < length; ++j) {
            char c = charSequence.charAt(j);
            if (c != this.quote) continue;
            sb.append(charSequence, i, j + 1).append(this.quote);
            i = j + 1;
        }
        sb.append(charSequence, i, length);
        sb.append(this.quote);
    }

    private void generateHeader(Schema<?, ?> schema, StringBuilder sb) {
        if (this.withHeader) {
            for (int i = 0; i < schema.getFields().length; ++i) {
                this.addLine(sb, schema.getFields()[i].getName());
                if (i >= schema.getFields().length - 1) continue;
                sb.append(this.separator);
            }
            sb.append(LINE_SEPARATOR);
        }
    }

    @Override
    public String generate(Schema<IN, ?> schema, int limit) {
        StringBuilder sb = new StringBuilder();
        this.generateHeader(schema, sb);
        for (int i = 0; i < limit; ++i) {
            sb.append((CharSequence)this.apply(null, schema, i));
            if (i >= limit - 1) continue;
            sb.append(LINE_SEPARATOR);
        }
        return sb.toString();
    }

    @Override
    public String getStartStream(Schema<IN, ?> schema) {
        StringBuilder sb = new StringBuilder();
        this.generateHeader(null, sb);
        return sb.toString();
    }

    @Override
    public String getEndStream() {
        return null;
    }

    public static class CsvTransformerBuilder<IN> {
        private String separator = ";";
        private char quote = (char)34;
        private boolean withHeader = true;

        public CsvTransformerBuilder<IN> quote(char quote) {
            this.quote = quote;
            return this;
        }

        public CsvTransformerBuilder<IN> separator(String separator) {
            this.separator = separator;
            return this;
        }

        public CsvTransformerBuilder<IN> header(boolean header) {
            this.withHeader = header;
            return this;
        }

        public CsvTransformer<IN> build() {
            return new CsvTransformer(this.separator, this.quote, this.withHeader);
        }
    }
}

