/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.shaded.curiousoddman.rgxgen.visitors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.datafaker.shaded.curiousoddman.rgxgen.config.RgxGenOption;
import net.datafaker.shaded.curiousoddman.rgxgen.config.RgxGenProperties;
import net.datafaker.shaded.curiousoddman.rgxgen.iterators.ReferenceIterator;
import net.datafaker.shaded.curiousoddman.rgxgen.iterators.StringIterator;
import net.datafaker.shaded.curiousoddman.rgxgen.iterators.suppliers.ArrayIteratorSupplier;
import net.datafaker.shaded.curiousoddman.rgxgen.iterators.suppliers.ChoiceIteratorSupplier;
import net.datafaker.shaded.curiousoddman.rgxgen.iterators.suppliers.GroupIteratorSupplier;
import net.datafaker.shaded.curiousoddman.rgxgen.iterators.suppliers.IncrementalLengthIteratorSupplier;
import net.datafaker.shaded.curiousoddman.rgxgen.iterators.suppliers.IndexIteratorSupplier;
import net.datafaker.shaded.curiousoddman.rgxgen.iterators.suppliers.NegativeIteratorSupplier;
import net.datafaker.shaded.curiousoddman.rgxgen.iterators.suppliers.PermutationsIteratorSupplier;
import net.datafaker.shaded.curiousoddman.rgxgen.iterators.suppliers.ReferenceIteratorSupplier;
import net.datafaker.shaded.curiousoddman.rgxgen.iterators.suppliers.SingleCaseInsensitiveValueIteratorSupplier;
import net.datafaker.shaded.curiousoddman.rgxgen.iterators.suppliers.SingleValueIteratorSupplier;
import net.datafaker.shaded.curiousoddman.rgxgen.nodes.Choice;
import net.datafaker.shaded.curiousoddman.rgxgen.nodes.FinalSymbol;
import net.datafaker.shaded.curiousoddman.rgxgen.nodes.Group;
import net.datafaker.shaded.curiousoddman.rgxgen.nodes.GroupRef;
import net.datafaker.shaded.curiousoddman.rgxgen.nodes.Node;
import net.datafaker.shaded.curiousoddman.rgxgen.nodes.NotSymbol;
import net.datafaker.shaded.curiousoddman.rgxgen.nodes.Repeat;
import net.datafaker.shaded.curiousoddman.rgxgen.nodes.Sequence;
import net.datafaker.shaded.curiousoddman.rgxgen.nodes.SymbolSet;
import net.datafaker.shaded.curiousoddman.rgxgen.parsing.dflt.ConstantsProvider;
import net.datafaker.shaded.curiousoddman.rgxgen.visitors.NodeVisitor;

public class UniqueGenerationVisitor
implements NodeVisitor {
    private final List<Supplier<StringIterator>> aIterators = new ArrayList<Supplier<StringIterator>>();
    private final Map<Integer, List<ReferenceIterator>> aReferenceIteratorMap;
    private final Map<Integer, StringIterator> aGroupIterators;
    private final RgxGenProperties aProperties;

    public UniqueGenerationVisitor(RgxGenProperties properties) {
        this(new HashMap<Integer, List<ReferenceIterator>>(), new HashMap<Integer, StringIterator>(), properties);
    }

    public UniqueGenerationVisitor(Map<Integer, List<ReferenceIterator>> referenceIteratorMap, Map<Integer, StringIterator> groupIterators, RgxGenProperties properties) {
        this.aReferenceIteratorMap = referenceIteratorMap;
        this.aGroupIterators = groupIterators;
        this.aProperties = properties;
    }

    @Override
    public void visit(SymbolSet node) {
        if (RgxGenOption.CASE_INSENSITIVE.getFromProperties(this.aProperties).booleanValue()) {
            this.aIterators.add(new IndexIteratorSupplier(node.getCaseInsensitiveSymbolSetIndexer()));
        } else {
            this.aIterators.add(new IndexIteratorSupplier(node.getSymbolSetIndexer()));
        }
    }

    @Override
    public void visit(Choice node) {
        ArrayList<List<Supplier<StringIterator>>> nodeIterators = new ArrayList<List<Supplier<StringIterator>>>(node.getNodes().length);
        for (Node n : node.getNodes()) {
            UniqueGenerationVisitor v = new UniqueGenerationVisitor(this.aReferenceIteratorMap, this.aGroupIterators, this.aProperties);
            n.visit(v);
            nodeIterators.add(v.aIterators);
        }
        this.aIterators.add(new ChoiceIteratorSupplier(nodeIterators));
    }

    @Override
    public void visit(FinalSymbol node) {
        if (RgxGenOption.CASE_INSENSITIVE.getFromProperties(this.aProperties).booleanValue()) {
            this.aIterators.add(new SingleCaseInsensitiveValueIteratorSupplier(node.getValue()));
        } else {
            this.aIterators.add(new SingleValueIteratorSupplier(node.getValue()));
        }
    }

    @Override
    public void visit(Repeat node) {
        UniqueGenerationVisitor v = new UniqueGenerationVisitor(this.aReferenceIteratorMap, this.aGroupIterators, this.aProperties);
        node.getNode().visit(v);
        this.aIterators.add(new IncrementalLengthIteratorSupplier(new PermutationsIteratorSupplier(v.aIterators), node.getMin(), node.getMax()));
    }

    @Override
    public void visit(Sequence node) {
        UniqueGenerationVisitor v = new UniqueGenerationVisitor(this.aReferenceIteratorMap, this.aGroupIterators, this.aProperties);
        for (Node n : node.getNodes()) {
            n.visit(v);
        }
        this.aIterators.add(new PermutationsIteratorSupplier(v.aIterators));
    }

    @Override
    public void visit(NotSymbol node) {
        this.aIterators.add(new NegativeIteratorSupplier(node.getPattern(), new IncrementalLengthIteratorSupplier(new ArrayIteratorSupplier(ConstantsProvider.makeAsciiCharacterArray()), 0, -1)));
    }

    @Override
    public void visit(GroupRef node) {
        this.aIterators.add(new ReferenceIteratorSupplier(this.aReferenceIteratorMap, this.aGroupIterators, node.getIndex()));
    }

    @Override
    public void visit(Group node) {
        UniqueGenerationVisitor v = new UniqueGenerationVisitor(this.aReferenceIteratorMap, this.aGroupIterators, this.aProperties);
        node.getNode().visit(v);
        this.aIterators.add(new GroupIteratorSupplier(new PermutationsIteratorSupplier(v.aIterators), this.aReferenceIteratorMap, this.aGroupIterators, node.getIndex()));
    }

    public StringIterator getUniqueStrings() {
        return this.aIterators.get(0).get();
    }
}

