/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.shaded.curiousoddman.rgxgen.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.datafaker.shaded.curiousoddman.rgxgen.model.SymbolRange;
import net.datafaker.shaded.curiousoddman.rgxgen.model.UnicodeCategory;
import net.datafaker.shaded.curiousoddman.rgxgen.util.Util;
import net.datafaker.shaded.curiousoddman.rgxgen.util.chars.CharList;

public class RgxGenCharsDefinition {
    private final List<SymbolRange> rangeList;
    private final CharList characters;

    public static RgxGenCharsDefinition of(List<SymbolRange> externalRanges) {
        return RgxGenCharsDefinition.of(externalRanges, CharList.empty());
    }

    public static RgxGenCharsDefinition of(UnicodeCategory category) {
        return new RgxGenCharsDefinition(category.getSymbolRanges(), CharList.charList(category.getSymbols()));
    }

    public static RgxGenCharsDefinition of(SymbolRange ... ranges) {
        return new RgxGenCharsDefinition(Arrays.asList(ranges), CharList.empty());
    }

    public static RgxGenCharsDefinition of(char ... characters) {
        return new RgxGenCharsDefinition(Collections.emptyList(), CharList.charList(characters));
    }

    public static RgxGenCharsDefinition of(String characterString) {
        CharList characterList = CharList.charList(characterString);
        ArrayList<SymbolRange> compactedRanges = new ArrayList<SymbolRange>();
        CharList compactedSymbols = CharList.empty();
        Util.compactOverlappingRangesAndSymbols(Collections.emptyList(), characterList, compactedRanges, compactedSymbols);
        return new RgxGenCharsDefinition(compactedRanges, compactedSymbols);
    }

    public static RgxGenCharsDefinition of(CharList charList) {
        return RgxGenCharsDefinition.of(Collections.emptyList(), charList);
    }

    public static RgxGenCharsDefinition of(List<SymbolRange> symbolRanges, CharList symbols) {
        return new RgxGenCharsDefinition(symbolRanges, symbols);
    }

    public static RgxGenCharsDefinition of(RgxGenCharsDefinition other) {
        return RgxGenCharsDefinition.of(other.rangeList, other.characters);
    }

    public RgxGenCharsDefinition withRanges(SymbolRange ... ranges) {
        this.rangeList.addAll(Arrays.asList(ranges));
        return this;
    }

    public RgxGenCharsDefinition withRanges(List<SymbolRange> ranges) {
        this.rangeList.addAll(ranges);
        return this;
    }

    public RgxGenCharsDefinition withCharacters(char ... characters) {
        this.characters.addAll(characters);
        return this;
    }

    public RgxGenCharsDefinition withCharacters(CharList characters) {
        this.characters.addAll(characters);
        return this;
    }

    private RgxGenCharsDefinition(List<SymbolRange> rangeList, CharList characters) {
        this.rangeList = new ArrayList<SymbolRange>(rangeList);
        this.characters = characters.copy();
    }

    public boolean isAsciiOnly() {
        return Stream.concat(this.rangeList.stream().map(SymbolRange::getTo), this.characters.stream().map(c -> c.charValue())).noneMatch(i -> i >= 127);
    }

    public List<SymbolRange> getRangeList() {
        return this.rangeList;
    }

    public CharList getCharacters() {
        return this.characters;
    }

    public void addAll(RgxGenCharsDefinition other) {
        this.rangeList.addAll(other.rangeList);
        this.characters.addAll(other.characters);
    }

    public String toString() {
        return "RgxGenCharsDefinition{rangeList=" + this.rangeList + ", characters=" + this.characters + '}';
    }
}

