/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.shaded.curiousoddman.rgxgen.config;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.datafaker.shaded.curiousoddman.rgxgen.config.RgxGenProperties;
import net.datafaker.shaded.curiousoddman.rgxgen.model.RgxGenCharsDefinition;
import net.datafaker.shaded.curiousoddman.rgxgen.model.WhitespaceChar;

public class RgxGenOption<T> {
    public static final RgxGenOption<Integer> INFINITE_PATTERN_REPETITION = new RgxGenOption<Integer>("generation.infinite.repeat", 100);
    public static final RgxGenOption<Boolean> CASE_INSENSITIVE = new RgxGenOption<Boolean>("matching.case.insensitive", false);
    public static final RgxGenOption<RgxGenCharsDefinition> DOT_MATCHES_ONLY = new RgxGenOption<Object>("dot.matches.only", null);
    public static final RgxGenOption<List<WhitespaceChar>> WHITESPACE_DEFINITION = new RgxGenOption<List<WhitespaceChar>>("whitespace.matches", Arrays.asList(WhitespaceChar.SPACE, WhitespaceChar.TAB));
    private final String key;
    private final T defaultValue;

    public RgxGenOption(String key, T defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
    }

    public String getKey() {
        return this.key;
    }

    public T getDefault() {
        return this.defaultValue;
    }

    public T getFromProperties(RgxGenProperties properties) {
        return (T)Optional.ofNullable(properties).map(props -> props.get(this.key)).orElse(this.defaultValue);
    }

    public void setInProperties(RgxGenProperties properties, T value) {
        Objects.requireNonNull(value);
        properties.put(this.key, value);
    }

    public String toString() {
        return this.key;
    }
}

