/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.sequence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.datafaker.providers.base.BaseProviders;
import net.datafaker.service.RandomService;

public abstract class FakeSequence<T>
implements Iterable<T> {
    protected final RandomService randomService;
    protected final List<Supplier<T>> suppliers;
    protected final double nullRate;
    protected final int minLength;
    protected final int maxLength;

    protected FakeSequence(List<Supplier<T>> suppliers, int minLength, int maxLength, RandomService randomService, double nullRate) {
        this.suppliers = suppliers;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.randomService = randomService;
        this.nullRate = nullRate;
    }

    public abstract <Sequence> Sequence get();

    public boolean isInfinite() {
        return false;
    }

    public T singleton() {
        if (this.nullRate == 0.0 || this.randomService.nextDouble() >= this.nullRate) {
            return this.suppliers.get(this.randomService.nextInt(this.suppliers.size())).get();
        }
        return null;
    }

    public static abstract class Builder<T> {
        protected final List<Supplier<T>> suppliers;
        protected int minLength = -1;
        protected int maxLength = -1;
        protected double nullRate = 0.0;
        protected BaseProviders faker;

        protected Builder() {
            this.suppliers = new ArrayList<Supplier<T>>();
        }

        protected Builder(List<Supplier<T>> list) {
            this.suppliers = new ArrayList<Supplier<T>>(list);
        }

        @SafeVarargs
        protected Builder(Supplier<T> ... elems) {
            this.suppliers = new ArrayList<Supplier<T>>(Arrays.asList(elems));
        }

        public Builder<T> faker(BaseProviders faker) {
            this.faker = faker;
            return this;
        }

        public Builder<T> minLen(int minLength) {
            this.minLength = minLength;
            return this;
        }

        public Builder<T> maxLen(int maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public Builder<T> len(int length) {
            return this.len(length, length);
        }

        public Builder<T> len(int minLength, int maxLength) {
            this.maxLength = maxLength;
            this.minLength = minLength;
            return this;
        }

        public Builder<T> nullRate(double nullRate) {
            if (nullRate < 0.0 || nullRate > 1.0) {
                throw new IllegalArgumentException("Null rate should be between 0 and 1 (received: %s)".formatted(nullRate));
            }
            this.nullRate = nullRate;
            return this;
        }

        @SafeVarargs
        public final Builder<T> suppliers(Supplier<T> ... suppliers) {
            Objects.requireNonNull(suppliers);
            this.suppliers.addAll(Arrays.asList(suppliers));
            return this;
        }

        public abstract FakeSequence<T> build();

        public <S> S generate() {
            return (S)this.build().get();
        }
    }
}

