/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.providers.base;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.concurrent.TimeUnit;
import net.datafaker.providers.base.AbstractProvider;
import net.datafaker.providers.base.BaseProviders;

public class TimeAndDate
extends AbstractProvider<BaseProviders> {
    static final int DEFAULT_MIN_AGE = 18;
    static final int DEFAULT_MAX_AGE = 65;

    protected TimeAndDate(BaseProviders faker) {
        super(faker);
    }

    public Instant future() {
        long FIFTY_YEARS = TimeUnit.DAYS.toMillis(18262L);
        return this.future(((BaseProviders)this.faker).number().numberBetween(1L, FIFTY_YEARS), TimeUnit.MILLISECONDS);
    }

    public Instant future(long atMost, TimeUnit unit) {
        Instant aBitLaterThanNow = Instant.now().plusMillis(1L);
        return this.future(atMost, unit, aBitLaterThanNow);
    }

    public String future(long atMost, TimeUnit unit, String pattern) {
        return TimeAndDate.formatInstant(this.future(atMost, unit), pattern);
    }

    public Instant future(long atMost, long minimum, TimeUnit unit) {
        Instant minimumDate = Instant.now().plus(minimum, unit.toChronoUnit());
        return this.future(atMost - minimum, unit, minimumDate);
    }

    public String future(long atMost, long minimum, TimeUnit unit, String pattern) {
        return TimeAndDate.formatInstant(this.future(atMost, minimum, unit), pattern);
    }

    public Instant future(long atMost, TimeUnit unit, Instant referenceDate) {
        long upperBoundMillis = unit.toMillis(atMost);
        long futureMillis = referenceDate.toEpochMilli() + 1L + ((BaseProviders)this.faker).random().nextLong(upperBoundMillis - 1L);
        return Instant.ofEpochMilli(futureMillis);
    }

    public String future(long atMost, TimeUnit unit, Instant referenceDate, String pattern) {
        return TimeAndDate.formatInstant(this.future(atMost, unit, referenceDate), pattern);
    }

    public Instant past() {
        long FIFTY_YEARS = TimeUnit.DAYS.toMillis(18262L);
        return this.past(((BaseProviders)this.faker).number().numberBetween(1L, FIFTY_YEARS), TimeUnit.MILLISECONDS);
    }

    public Instant past(long atMost, TimeUnit unit) {
        Instant aBitEarlierThanNow = Instant.now().minusMillis(1L);
        return this.past(atMost, unit, aBitEarlierThanNow);
    }

    public String past(long atMost, TimeUnit unit, String pattern) {
        return TimeAndDate.formatInstant(this.past(atMost, unit), pattern);
    }

    public Instant past(long atMost, long minimum, TimeUnit unit) {
        Instant minimumDate = Instant.now().minusMillis(unit.toMillis(minimum));
        return this.past(atMost - minimum, unit, minimumDate);
    }

    public String past(long atMost, long minimum, TimeUnit unit, String pattern) {
        return TimeAndDate.formatInstant(this.past(atMost, minimum, unit), pattern);
    }

    public Instant past(long atMost, TimeUnit unit, Instant referenceDate) {
        long upperBoundMillis = unit.toMillis(atMost);
        long pastMillis = referenceDate.toEpochMilli() - 1L - ((BaseProviders)this.faker).random().nextLong(upperBoundMillis - 1L);
        return Instant.ofEpochMilli(pastMillis);
    }

    public String past(long atMost, TimeUnit unit, Instant referenceDate, String pattern) {
        return TimeAndDate.formatInstant(this.past(atMost, unit, referenceDate), pattern);
    }

    public Instant between(Instant from, Instant to) throws IllegalArgumentException {
        if (to.isBefore(from)) {
            throw new IllegalArgumentException("Invalid date range: the upper bound date (%s) is before the lower bound (%s)".formatted(to, from));
        }
        if (from.equals(to)) {
            return from;
        }
        long offsetMillis = ((BaseProviders)this.faker).random().nextLong(to.toEpochMilli() - from.toEpochMilli());
        return from.plusMillis(offsetMillis);
    }

    public String between(Instant from, Instant to, String pattern) throws IllegalArgumentException {
        return TimeAndDate.formatInstant(this.between(from, to), pattern);
    }

    public LocalDate birthday() {
        return this.birthday(18, 65);
    }

    public String birthday(String pattern) {
        return TimeAndDate.formatInstant(this.birthday(18, 65), pattern);
    }

    public LocalDate birthday(int minAge, int maxAge) {
        LocalDate localDate = LocalDate.now();
        LocalDate from = localDate.minusYears(maxAge);
        if (minAge == maxAge) {
            return from;
        }
        long start = from.toEpochDay();
        long stop = localDate.minusYears(minAge).toEpochDay();
        return LocalDate.ofEpochDay(((BaseProviders)this.faker).random().nextLong(start, stop));
    }

    public String birthday(int minAge, int maxAge, String pattern) {
        return TimeAndDate.formatInstant(this.birthday(minAge, maxAge), pattern);
    }

    public Duration duration(long max, ChronoUnit unit) {
        return this.duration(0L, max, unit);
    }

    public Duration duration(long min, long max, ChronoUnit unit) {
        return Duration.of(((BaseProviders)this.faker).random().nextLong(min, max), unit);
    }

    public Period period(Period min, Period max) {
        if (max.minus(min).isNegative()) {
            throw new IllegalArgumentException("Max period(" + max + ") should be not less than min (" + min + ")");
        }
        return Period.of(((BaseProviders)this.faker).random().nextInt(min.getYears(), max.getYears()), ((BaseProviders)this.faker).random().nextInt(min.getMonths(), max.getMonths()), ((BaseProviders)this.faker).random().nextInt(min.getDays(), max.getDays()));
    }

    private static String formatInstant(TemporalAccessor instant, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern).withZone(ZoneId.systemDefault());
        return formatter.format(instant);
    }
}

