/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.providers.base;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import net.datafaker.providers.base.AbstractProvider;
import net.datafaker.providers.base.BaseProviders;

public class Time
extends AbstractProvider<BaseProviders> {
    protected Time(BaseProviders faker) {
        super(faker);
    }

    public long future(int atMost, ChronoUnit unit) {
        LocalTime now = LocalTime.now();
        long atMostTime = now.plus(atMost, unit).toNanoOfDay();
        long time = now.toNanoOfDay();
        return ((BaseProviders)this.faker).number().numberBetween(time, atMostTime);
    }

    public String future(int atMost, ChronoUnit unit, String pattern) {
        return LocalTime.ofNanoOfDay(this.future(atMost, unit)).format(DateTimeFormatter.ofPattern(pattern));
    }

    public long future(int atMost, int minimum, ChronoUnit unit) {
        LocalTime now = LocalTime.now();
        long atMostTime = now.plus(atMost, unit).toNanoOfDay();
        long time = now.plus(minimum, unit).toNanoOfDay();
        return ((BaseProviders)this.faker).number().numberBetween(time, atMostTime);
    }

    public String future(int atMost, int minimum, ChronoUnit unit, String pattern) {
        return LocalTime.ofNanoOfDay(this.future(atMost, minimum, unit)).format(DateTimeFormatter.ofPattern(pattern));
    }

    public long past(int atLeast, ChronoUnit unit) {
        LocalTime now = LocalTime.now();
        long atLeastTime = now.minus(atLeast, unit).toNanoOfDay();
        long time = now.toNanoOfDay();
        return ((BaseProviders)this.faker).number().numberBetween(atLeastTime, time);
    }

    public String past(int atMost, ChronoUnit unit, String pattern) {
        return LocalTime.ofNanoOfDay(this.past(atMost, unit)).format(DateTimeFormatter.ofPattern(pattern));
    }

    public long past(int atMost, int minimum, ChronoUnit unit) {
        LocalTime now = LocalTime.now();
        long atMostTime = now.minus(atMost, unit).toNanoOfDay();
        long time = now.minus(minimum, unit).toNanoOfDay();
        return ((BaseProviders)this.faker).number().numberBetween(atMostTime, time);
    }

    public String past(int atMost, int minimum, ChronoUnit unit, String pattern) {
        return LocalTime.ofNanoOfDay(this.past(atMost, minimum, unit)).format(DateTimeFormatter.ofPattern(pattern));
    }

    public long between(LocalTime from, LocalTime to) throws IllegalArgumentException {
        if (to.isBefore(from)) {
            throw new IllegalArgumentException("Invalid time range: the upper bound time (%s) is before the lower bound (%s)".formatted(to, from));
        }
        if (from.equals(to)) {
            return from.toNanoOfDay();
        }
        return ((BaseProviders)this.faker).number().numberBetween(from.toNanoOfDay(), to.toNanoOfDay());
    }

    public String between(LocalTime from, LocalTime to, String pattern) throws IllegalArgumentException {
        return LocalTime.ofNanoOfDay(this.between(from, to)).format(DateTimeFormatter.ofPattern(pattern));
    }
}

