/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.providers.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import net.datafaker.annotations.Deterministic;
import net.datafaker.providers.base.AbstractProvider;
import net.datafaker.providers.base.BaseProviders;

public class Locality
extends AbstractProvider<BaseProviders> {
    private static final List<String> LOCALES = List.of("_al", "_bg", "_by", "_ca", "_ch", "_cn", "_cz", "_ee", "_ge", "_in", "_md", "_mk", "_ru", "_us", "ar", "be", "bg", "by", "ca", "ca-cat", "cs", "cs-cz", "da-dk", "de", "de-at", "de-ch", "el-gr", "en", "en-au", "en-au-ocker", "en-bork", "en-ca", "en-gb", "en-in", "en-md", "en-ms", "en-nep", "en-ng", "en-nz", "en-pak", "en-ph", "en-pk", "en-sg", "en-ug", "en-us", "en-za", "es", "es-ar", "es-mx", "es-py", "et", "fa", "fi-fi", "fr", "fr-ca", "fr-ch", "he", "hr", "hu", "hy", "id", "id-id", "it", "ja", "ka", "ko", "lv", "mk", "nb-no", "nl", "nl-be", "no-no", "pl", "pt", "pt-br", "ro-md", "ru", "ru-md", "sk", "sq", "sv", "sv-se", "ta", "ta-in", "th", "tr", "uk", "vi", "zh-cn", "zh-tw");
    private final List<String> shuffledLocales = new ArrayList<String>();
    private int shuffledLocaleIndex = 0;

    public Locality(BaseProviders baseProviders) {
        super(baseProviders);
    }

    @Deprecated
    public List<String> allSupportedLocales(Set<String> fileMasks) {
        return this.allSupportedLocales();
    }

    @Deterministic
    public final List<String> allSupportedLocales() {
        return LOCALES;
    }

    public String displayName() {
        int randomIndex = ((BaseProviders)this.faker).random().nextInt(LOCALES.size());
        Locale locale = Locale.forLanguageTag(LOCALES.get(randomIndex));
        Object displayLanguage = locale.getDisplayLanguage(Locale.ROOT);
        String displayCountry = locale.getDisplayCountry(Locale.ROOT);
        if (!displayCountry.isEmpty()) {
            displayLanguage = (String)displayLanguage + " (" + displayCountry + ")";
        }
        return ((String)displayLanguage).isEmpty() ? Locale.ENGLISH.getDisplayLanguage(Locale.ROOT) : displayLanguage;
    }

    public String localeString() {
        return this.localeStringWithRandom(((BaseProviders)this.faker).random().getRandomInternal());
    }

    public String localeStringWithRandom(Random random) {
        int randomIndex = random.nextInt(LOCALES.size());
        return LOCALES.get(randomIndex);
    }

    public String localeStringWithoutReplacement() {
        return this.localeStringWithoutReplacement(((BaseProviders)this.faker).random().getRandomInternal());
    }

    public synchronized String localeStringWithoutReplacement(Random random) {
        if (this.shuffledLocales.isEmpty() || this.shuffledLocaleIndex >= this.shuffledLocales.size() - 1) {
            this.shuffledLocales.clear();
            this.shuffledLocales.addAll(LOCALES);
            this.shuffledLocaleIndex = 0;
            Collections.shuffle(this.shuffledLocales, random);
        }
        return this.shuffledLocales.get(this.shuffledLocaleIndex++);
    }
}

