/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.providers.base;

import java.util.List;
import net.datafaker.providers.base.AbstractProvider;
import net.datafaker.providers.base.BaseProviders;

public class Aviation
extends AbstractProvider<BaseProviders> {
    protected Aviation(BaseProviders faker) {
        super(faker);
    }

    public String aircraft() {
        return this.resolve(List.of("aviation.aircraft.airplane", "aviation.aircraft.warplane", "aviation.aircraft.army_helicopter", "aviation.aircraft.civil_helicopter", "aviation.aircraft.general", "aviation.aircraft.cargo").get(((BaseProviders)this.faker).number().numberBetween(0, 6)));
    }

    public String airplane() {
        return this.resolve("aviation.aircraft.airplane");
    }

    public String warplane() {
        return this.resolve("aviation.aircraft.warplane");
    }

    public String general() {
        return this.resolve("aviation.aircraft.general");
    }

    public String cargo() {
        return this.resolve("aviation.aircraft.cargo");
    }

    public String armyHelicopter() {
        return this.resolve("aviation.aircraft.army_helicopter");
    }

    public String civilHelicopter() {
        return this.resolve("aviation.aircraft.civil_helicopter");
    }

    public String airport() {
        return this.resolve("aviation.airport");
    }

    public String airportName() {
        return this.resolve("aviation.airport_name");
    }

    public String METAR() {
        return this.resolve("aviation.metar");
    }

    public String manufacturer() {
        return this.resolve("aviation.manufacturer");
    }

    public String specialTypeDesignator() {
        return this.resolve("aviation.aircraft_type_special_designator");
    }

    public String engineType() {
        return this.resolve("aviation.engine_type");
    }

    public String flight(String type) {
        String airline = "ICAO".equalsIgnoreCase(type) ? this.resolve("aviation.ICAO_airline") : this.resolve("aviation.IATA_airline");
        int number = ((BaseProviders)this.faker).number().numberBetween(0, 9999);
        return airline + number;
    }

    public String flight() {
        return this.flight("IATA");
    }

    public String flightStatus() {
        return this.resolve("aviation.flight_status");
    }

    public String gate() {
        boolean shouldBePureNumeric = ((BaseProviders)this.faker).random().nextBoolean();
        Object gate = shouldBePureNumeric ? String.valueOf(((BaseProviders)this.faker).number().numberBetween(1, 256)) : ((BaseProviders)this.faker).regexify("[A-Z]") + ((BaseProviders)this.faker).number().numberBetween(1, 256);
        return gate;
    }

    public String airline() {
        return this.resolve("aviation.airline");
    }
}

