/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.idnumbers.pt.br;

import net.datafaker.idnumbers.pt.br.DocumentFormatterUtil;
import net.datafaker.providers.base.BaseProviders;

public final class IdNumberGeneratorPtBrUtil {
    private IdNumberGeneratorPtBrUtil() {
    }

    public static String cnpj(BaseProviders faker, boolean formatted, boolean valid, boolean multiBranch) {
        String result;
        Object cnpj;
        if (valid) {
            StringBuilder partial = new StringBuilder();
            for (int i = 0; i < 8; ++i) {
                partial.append(faker.random().nextInt(9));
            }
            if (multiBranch) {
                String string = String.valueOf(faker.random().nextInt(1, 9999));
                partial.append(String.valueOf('0').repeat(Math.max(0, 4 - string.length())));
                partial.append(string);
            } else {
                partial.append("0001");
            }
            cnpj = partial.toString();
            int d1 = IdNumberGeneratorPtBrUtil.digit(IdNumberGeneratorPtBrUtil.calculateWeight((String)cnpj, 9, 4, 12) + IdNumberGeneratorPtBrUtil.calculateWeight((String)cnpj, 5, 0, 4));
            int d2 = IdNumberGeneratorPtBrUtil.digit(d1 * 2 + IdNumberGeneratorPtBrUtil.calculateWeight((String)cnpj, 9, 5, 12) + IdNumberGeneratorPtBrUtil.calculateWeight((String)cnpj, 6, 0, 5));
            cnpj = (String)cnpj + d1 + d2;
        } else {
            cnpj = String.valueOf((long)faker.random().nextInt(1000000000) + (long)(faker.random().nextInt(90) + 10) * 1000000000000L);
        }
        String string = result = formatted ? DocumentFormatterUtil.cnpj((String)cnpj) : cnpj;
        if (IdNumberGeneratorPtBrUtil.isCNPJValid(result) != valid) {
            result = IdNumberGeneratorPtBrUtil.cnpj(faker, formatted, valid, multiBranch);
        }
        return result;
    }

    public static String cpf(BaseProviders faker, boolean formatted, boolean valid) {
        String result;
        Object cpf;
        if (valid) {
            char[] partial = new char[9];
            for (int i = 0; i < 9; ++i) {
                partial[i] = (char)(48 + faker.random().nextInt(9));
            }
            cpf = String.valueOf(partial);
            int d1 = IdNumberGeneratorPtBrUtil.digit(IdNumberGeneratorPtBrUtil.calculateWeight((String)cpf, 10, 0, ((String)cpf).length()));
            int d2 = IdNumberGeneratorPtBrUtil.digit(d1 * 2 + IdNumberGeneratorPtBrUtil.calculateWeight((String)cpf, 11, 0, ((String)cpf).length()));
            cpf = (String)cpf + d1 + d2;
        } else {
            cpf = String.valueOf((long)faker.random().nextInt(1000000000) + (long)(faker.random().nextInt(90) + 10) * 1000000000L);
        }
        String string = result = formatted ? DocumentFormatterUtil.cpf((String)cpf) : cpf;
        if (IdNumberGeneratorPtBrUtil.isCPFValid(result) != valid) {
            result = IdNumberGeneratorPtBrUtil.cpf(faker, formatted, valid);
        }
        return result;
    }

    public static boolean isCNPJValid(String cnpj) {
        String cnpjUnmask = DocumentFormatterUtil.unmask(cnpj);
        int cnpjPartialLength = 12;
        if (!cnpjUnmask.regionMatches(0, cnpjUnmask, 0, 12)) {
            return false;
        }
        int d1 = IdNumberGeneratorPtBrUtil.digit(IdNumberGeneratorPtBrUtil.calculateWeight(cnpjUnmask, 9, 4, 12) + IdNumberGeneratorPtBrUtil.calculateWeight(cnpjUnmask, 5, 0, 4));
        int d2 = IdNumberGeneratorPtBrUtil.digit(d1 * 2 + IdNumberGeneratorPtBrUtil.calculateWeight(cnpjUnmask, 9, 5, 12) + IdNumberGeneratorPtBrUtil.calculateWeight(cnpjUnmask, 6, 0, 5));
        String other = "" + d1 + d2;
        return cnpjUnmask.regionMatches(12, other, 0, other.length());
    }

    public static Boolean isCPFValid(String cpf) {
        String cpfUnmask = DocumentFormatterUtil.unmask(cpf);
        String cpfPartial = cpfUnmask.substring(0, 9);
        int d1 = IdNumberGeneratorPtBrUtil.digit(IdNumberGeneratorPtBrUtil.calculateWeight(cpfUnmask, 10, 0, 9));
        int d2 = IdNumberGeneratorPtBrUtil.digit(d1 * 2 + IdNumberGeneratorPtBrUtil.calculateWeight(cpfUnmask, 11, 0, 9));
        return cpfUnmask.equals(cpfPartial + d1 + d2);
    }

    public static int calculateWeight(String num, int weight, int start, int end) {
        int sum = 0;
        int weightAux = weight;
        for (int index = start; index < end; ++index) {
            sum += (num.charAt(index) - 48) * weightAux--;
        }
        return sum;
    }

    public static int digit(int verifyingDigit) {
        int remainder = verifyingDigit % 11;
        if (remainder == 0 || remainder == 1) {
            return 0;
        }
        return 11 - remainder;
    }
}

