/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.idnumbers;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import net.datafaker.idnumbers.IdNumberGenerator;
import net.datafaker.idnumbers.Utils;
import net.datafaker.providers.base.BaseProviders;
import net.datafaker.providers.base.IdNumber;
import net.datafaker.providers.base.PersonIdNumber;

public class SouthAfricanIdNumber
implements IdNumberGenerator {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyMMdd");
    private static final String[] VALID_PATTERN = new String[]{"##########08#", "##########18#"};
    private static final String[] CODE_PATTERN = new String[]{"18", "08"};

    @Override
    public String countryCode() {
        return "ZA";
    }

    @Deprecated
    public String getValidSsn(BaseProviders faker) {
        return this.generateValid(faker);
    }

    @Override
    public PersonIdNumber generateValid(BaseProviders f, IdNumber.IdNumberRequest request) {
        LocalDate birthday = Utils.birthday(f, request);
        PersonIdNumber.Gender gender = Utils.gender(f, request);
        String basePart = DATE_TIME_FORMATTER.format(birthday) + SouthAfricanIdNumber.sequentialNumber(f, gender) + f.options().option(CODE_PATTERN);
        return new PersonIdNumber(basePart + SouthAfricanIdNumber.calculateChecksum(basePart, 12), birthday, gender);
    }

    static String sequentialNumber(BaseProviders f, PersonIdNumber.Gender gender) {
        int number = switch (gender) {
            default -> throw new IncompatibleClassChangeError();
            case PersonIdNumber.Gender.FEMALE -> f.number().numberBetween(0, 5000);
            case PersonIdNumber.Gender.MALE -> f.number().numberBetween(5000, 10000);
        };
        return "%04d".formatted(number);
    }

    @Deprecated
    public String getInValidSsn(BaseProviders f) {
        return this.generateInvalid(f);
    }

    @Override
    public String generateInvalid(BaseProviders f) {
        String ssn = f.numerify(f.options().option(VALID_PATTERN));
        while (SouthAfricanIdNumber.isValidEnZASsn(ssn)) {
            String pattern = this.getPattern(f);
            ssn = f.numerify(pattern);
        }
        return ssn;
    }

    private String getPattern(BaseProviders faker) {
        return faker.options().option(VALID_PATTERN);
    }

    public static boolean isValidEnZASsn(String ssn) {
        if (ssn.length() != 13) {
            return false;
        }
        try {
            if (SouthAfricanIdNumber.parseDate(ssn)) {
                return false;
            }
        }
        catch (NumberFormatException | DateTimeParseException ignore) {
            return false;
        }
        return ssn.charAt(12) - 48 == SouthAfricanIdNumber.calculateChecksum(ssn, 12);
    }

    private static boolean parseDate(String ssn) {
        if (ChronoField.YEAR.range().isValidIntValue(Integer.parseInt(ssn, 0, 2, 10)) && ChronoField.MONTH_OF_YEAR.range().isValidIntValue(Integer.parseInt(ssn, 2, 4, 10)) && ChronoField.DAY_OF_MONTH.range().isValidIntValue(Integer.parseInt(ssn, 4, 6, 10))) {
            String dateString = ssn.substring(0, 6);
            LocalDate date = LocalDate.parse(dateString, DATE_TIME_FORMATTER);
            String reversed = date.format(DATE_TIME_FORMATTER);
            return !reversed.equals(dateString);
        }
        return false;
    }

    private static int calculateChecksum(String number, int length2Check) {
        int totalNumber = 0;
        for (int i = length2Check - 1; i >= 0; i -= 2) {
            int tmpNumber = SouthAfricanIdNumber.calculate((number.charAt(i) - 48) * 2);
            if (i == 0) {
                totalNumber += tmpNumber;
                continue;
            }
            totalNumber += tmpNumber + number.charAt(i - 1) - 48;
        }
        if (totalNumber >= 0 && totalNumber < 9) {
            return 10 - totalNumber;
        }
        int res = totalNumber % 10;
        return res == 0 ? res : 10 - res;
    }

    private static int calculate(int number) {
        int res = 0;
        while (number > 0) {
            res += number % 10;
            number /= 10;
        }
        return res;
    }
}

