/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.idnumbers;

import java.time.LocalDate;
import net.datafaker.idnumbers.IdNumberGenerator;
import net.datafaker.idnumbers.Utils;
import net.datafaker.providers.base.BaseProviders;
import net.datafaker.providers.base.IdNumber;
import net.datafaker.providers.base.PersonIdNumber;
import net.datafaker.service.RandomService;

public class SingaporeIdNumber
implements IdNumberGenerator {
    private static final int[] CODE = new int[]{0, 2, 7, 6, 5, 4, 3, 2};
    private static final String FIN_LETTERS = "XWUTRQPNMLK";
    private static final String UIN_LETTERS = "JZIHGFEDCBA";

    @Override
    public String countryCode() {
        return "SG";
    }

    private static String format(LocalDate issueDate, boolean citizen, int[] randomDigits) {
        int checkDigitInitialValue = issueDate.getYear() < 2000 ? 0 : 4;
        char firstLetter = citizen ? SingaporeIdNumber.centuryPrefixCitizen(issueDate) : SingaporeIdNumber.centuryPrefixForeigner(issueDate);
        String matchLetters = citizen ? UIN_LETTERS : FIN_LETTERS;
        int checkDigit = checkDigitInitialValue;
        StringBuilder id = new StringBuilder(11);
        id.append(firstLetter);
        for (int i = 0; i < randomDigits.length; ++i) {
            checkDigit += randomDigits[i] * CODE[i];
            id.append(randomDigits[i]);
        }
        id.append(matchLetters.charAt(checkDigit %= 11));
        return id.toString();
    }

    @Override
    public String generateValid(BaseProviders faker) {
        return this.generateValid(faker, new IdNumber.IdNumberRequest(0, 100, IdNumber.GenderRequest.ANY)).idNumber();
    }

    @Override
    public PersonIdNumber generateValid(BaseProviders faker, IdNumber.IdNumberRequest request) {
        LocalDate birthDate = Utils.birthday(faker, request);
        boolean citizen = faker.bool().bool();
        PersonIdNumber.Gender gender = Utils.gender(faker, request);
        return SingaporeIdNumber.generateValidIdNumber(faker, birthDate, citizen, gender);
    }

    private static PersonIdNumber generateValidIdNumber(BaseProviders faker, LocalDate birthDate, boolean citizen, PersonIdNumber.Gender gender) {
        int[] number = SingaporeIdNumber.randomDigits(faker);
        String idNumber = SingaporeIdNumber.format(birthDate, citizen, number);
        return new PersonIdNumber(idNumber, birthDate, gender);
    }

    @Override
    public String generateInvalid(BaseProviders faker) {
        return this.generateValid(faker) + "42";
    }

    public static String getValidFIN(BaseProviders f, Type type) {
        LocalDate birthDate = SingaporeIdNumber.randomBirthDate(f, type);
        boolean citizen = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.SINGAPOREAN_TWENTIETH_CENTURY, Type.SINGAPOREAN_TWENTY_FIRST_CENTURY -> true;
            case Type.FOREIGNER_TWENTIETH_CENTURY, Type.FOREIGNER_TWENTY_FIRST_CENTURY -> false;
        };
        return SingaporeIdNumber.generateValidIdNumber(f, birthDate, citizen, Utils.randomGender(f)).idNumber();
    }

    static LocalDate randomBirthDate(BaseProviders faker, Type type) {
        int now = LocalDate.now().getYear();
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.SINGAPOREAN_TWENTIETH_CENTURY, Type.FOREIGNER_TWENTIETH_CENTURY -> faker.timeAndDate().birthday(now - 1999, now - 1900);
            case Type.SINGAPOREAN_TWENTY_FIRST_CENTURY, Type.FOREIGNER_TWENTY_FIRST_CENTURY -> faker.timeAndDate().birthday(Math.max(0, now - 2099), now - 2000);
        };
    }

    private static int[] randomDigits(BaseProviders f) {
        RandomService random = f.random();
        int[] number = new int[7];
        for (int i = 0; i < number.length; ++i) {
            number[i] = random.nextInt(0, 9);
        }
        return number;
    }

    static char centuryPrefixCitizen(LocalDate issueDate) {
        int century = issueDate.getYear() / 100;
        return (char)(65 + century - 1);
    }

    static char centuryPrefixForeigner(LocalDate issueDate) {
        int century = issueDate.getYear() / 100;
        return (char)(65 + century - 14);
    }

    public static enum Type {
        SINGAPOREAN_TWENTIETH_CENTURY,
        FOREIGNER_TWENTIETH_CENTURY,
        SINGAPOREAN_TWENTY_FIRST_CENTURY,
        FOREIGNER_TWENTY_FIRST_CENTURY;

    }
}

