/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.idnumbers;

import net.datafaker.idnumbers.IdNumberGenerator;
import net.datafaker.idnumbers.Utils;
import net.datafaker.providers.base.BaseProviders;
import net.datafaker.providers.base.IdNumber;
import net.datafaker.providers.base.PersonIdNumber;

public class PortugueseIdNumber
implements IdNumberGenerator {
    private static final Character[] VALID_FIRST_DIGITS = new Character[]{Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('8')};
    private static final String[] VALID_FIRST_DOUBLE_DIGITS = new String[]{"45", "70", "71", "72", "74", "75", "77", "79", "90", "91", "98", "99"};

    @Override
    public String countryCode() {
        return "PT";
    }

    @Override
    public String generateInvalid(BaseProviders faker) {
        String digits = faker.number().digits(8);
        int digitSum = this.calculateDigitSum(digits);
        return digits + (digitSum + 5);
    }

    @Override
    public String generateValid(BaseProviders faker) {
        String digits;
        if (faker.random().nextBoolean()) {
            char firstDigit = faker.options().option((E[])VALID_FIRST_DIGITS).charValue();
            digits = firstDigit + faker.number().digits(7);
        } else {
            String firstDoubleDigit = faker.options().option(VALID_FIRST_DOUBLE_DIGITS);
            digits = firstDoubleDigit + faker.number().digits(6);
        }
        int digitSum = this.calculateDigitSum(digits);
        return digits + digitSum;
    }

    @Override
    public PersonIdNumber generateValid(BaseProviders faker, IdNumber.IdNumberRequest request) {
        return new PersonIdNumber(this.generateValid(faker), Utils.birthday(faker, request), Utils.gender(faker, request));
    }

    private int calculateDigitSum(String numbers) {
        int val;
        int checkSum = 0;
        for (int i = 1; i <= numbers.length(); ++i) {
            int digit = Character.getNumericValue(numbers.charAt(i - 1));
            checkSum += (10 - i) * digit;
        }
        checkSum = (checkSum -= (val = checkSum / 11 * 11)) == 0 || checkSum == 1 ? 0 : 11 - checkSum;
        return checkSum;
    }
}

